# Querit Search

Web search skill for [OpenClaw](https://github.com/openclaw/openclaw) powered by [Querit.ai](https://querit.ai).

Search the web, get structured results, and extract page content as markdown — all from your OpenClaw agent.

## Quick Start

1. **Install the skill** (pick one method below)
2. **Set your API key**: `export QUERIT_API_KEY="your-key-here"`
3. **Use it**: Ask OpenClaw to "search the web for..." and it handles the rest

## Installation

### One-line installer

```bash
curl -fsSL https://raw.githubusercontent.com/interskh/querit-search/main/install.sh | bash
```

### Manual (git clone)

```bash
git clone https://github.com/interskh/querit-search.git ~/.openclaw/skills/querit-search
cd ~/.openclaw/skills/querit-search && npm ci
```

### Manual (copy)

Copy the skill files to `~/.openclaw/skills/querit-search/` and run `npm ci` in that directory.

## Configuration

Get a free API key at [querit.ai](https://querit.ai) (1,000 queries/month, no credit card required).

### Option A: Environment variable

```bash
export QUERIT_API_KEY="your-key-here"
```

Add to your `~/.bashrc`, `~/.zshrc`, or `~/.profile` to persist.

### Option B: OpenClaw config

In `~/.openclaw/openclaw.json`:

```json
{
  "skills": {
    "entries": {
      "querit-search": {
        "apiKey": "your-key-here"
      }
    }
  }
}
```

### Option C: .env file

Create `~/.openclaw/.env`:

```
QUERIT_API_KEY=your-key-here
```

## Usage Examples

Just ask OpenClaw naturally:

- *"Search for React server components best practices"*
- *"Find the latest Node.js release notes"*
- *"Look up how to use CSS container queries"*
- *"Search for TypeScript 5.4 new features and read the first result"*

OpenClaw will use the skill automatically when it needs to search the web.

## CLI Reference

### search.js

```
search.js <query> [options]

Options:
  -n <count>                Number of results (default: 5, max: 100)
  --lang <language>         Language filter
  --country <country>       Country filter
  --date <range>            Date filter: d1 (day), w1 (week), m1 (month), y1 (year)
  --site-include <domain>   Only include results from this domain (repeatable)
  --site-exclude <domain>   Exclude results from this domain (repeatable)
  --content                 Also fetch and extract page content as markdown
  --json                    Output raw JSON
```

**Supported languages:** english, japanese, korean, german, french, spanish, portuguese

**Supported countries:** argentina, australia, brazil, canada, colombia, france, germany, india, indonesia, japan, mexico, nigeria, philippines, south korea, spain, united kingdom, united states

### content.js

```
content.js <url>
```

Fetches a URL and extracts the main readable content as markdown using Readability + Turndown.

## API Limits

| Plan | Price | Queries | Rate limit |
|------|-------|---------|------------|
| Free | $0 | 1,000/month | 1 QPS |
| Pro | $4/1,000 requests | Unlimited | 10 QPS |
| Enterprise | $6/1,000 requests | Unlimited | Unlimited |

Additional constraints:
- Query: max 72 characters (auto-truncated with warning)
- Results: max 100 per query
- Site filters: max 20 domains each

## Troubleshooting

### "QUERIT_API_KEY environment variable is not set"

Make sure your API key is exported in the shell where OpenClaw runs. If using OpenClaw config, check the path is `skills.entries.querit-search.apiKey`.

### "npm ci failed" during install

Try `npm install` instead. Make sure you have Node.js 18+ (`node -v`).

### "API returned error 401"

Your API key is invalid or expired. Generate a new one at [querit.ai](https://querit.ai).

### "API returned error 429"

Rate limit exceeded. Free tier allows 1 query per second and 1,000 queries per month.

### "Could not extract readable content from page"

Some pages (SPAs, paywalled content, PDFs) can't be extracted by Readability. This is expected — the search results themselves are still useful.

## Contributing

1. Clone the repo
2. Make changes
3. Test locally:
   ```bash
   ./search.js "test query"
   ./search.js "test" --json
   ./content.js https://example.com
   ```
4. Submit a PR

## License

MIT
