# QuantClaw Trading Framework

Reference document for the QuantClaw LLM decision engine. Derived from BebBot V3's
production prompter system (2,232 lines) and management prompter (509 lines).

---

## Architecture: Agent-as-Brain

QuantClaw is an LLM that IS the decision-maker. The agent receives structured market
data (200+ features) and makes its own trading decisions — no scoring templates,
no rigid signal systems.

The agent receives:
- **Strategy-aware analysis output** (3-tier hierarchy: primary TF prominent, context condensed, all TFs compact)
- **Strategy-filtered trade flow** (only the CVD window appropriate for the strategy)
- **Per-strategy risk gates** (thresholds tuned to hold period)
- **Fundamentals context** (macro narrative, crypto sentiment, scheduled events)
- **Account state** (equity, margin, open positions)

The agent outputs:
- **Direction** (BUY / SELL / HOLD)
- **Position sizing** (allocation %, leverage, USD size)
- **Risk levels** (stop loss, take profit)
- **Rationale** (reasoning and evidence)

---

## A. Strategy Selection

Pick a strategy based on the user's stated intent. Default to SWING if unspecified.

| User Says | Strategy | Primary TF | Hold Period |
|-----------|----------|------------|-------------|
| "quick scalp", "scalp this" | FAST | 5m | 10-60 min |
| "swing trade", no preference | SWING | 15m | 2-8 hours |
| "hold overnight", "medium term" | MEDIUM | 30m | 4-12 hours |
| "position trade", "weekly" | POSITION | Daily | 1-4 weeks |

Run analysis with the selected strategy:
```
quantclaw analyze BTCUSDT --strategy swing
```

The strategy determines:
1. Which timeframe is your **decision chart** (primary TF)
2. Which CVD window the agent sees (prevents noise-driven exits)
3. Which risk gate thresholds apply (spread, depth, chop)
4. Which risk constraints apply (min SL, min TP, R:R bounds)
5. How fundamentals are weighted (sentiment-first vs macro-first)

---

## B. Reading the Analysis Output

The analysis output is organized in a 3-tier hierarchy. This is intentional —
it shapes how you reason about the market.

### Tier 1: Primary Timeframe (prominent)

This is your **decision chart**. Full indicator detail: RSI, MACD, Bollinger,
ATR, ADX (+DI/-DI), Chop, CCI, Williams %R, EMA cross, Stochastic, Volume Ratio.

Look here for:
- Setup identification (divergences, breakouts, trend continuation)
- Entry timing (RSI + MACD + BB% alignment)
- Trend strength (ADX + Chop combination)

### Tier 2: Contextual Timeframes (condensed)

Two frames: one lower (entry timing precision) and one higher (macro trend).

| Strategy | Lower | Higher | Lower Purpose | Higher Purpose |
|----------|-------|--------|---------------|----------------|
| FAST | 1m | 1h | Scalp entry precision | Avoid counter-trend |
| SWING | 5m | 4h | Entry timing | Trend direction |
| MEDIUM | 15m | D | Entry timing | Daily bias |
| POSITION | 4h | W | Retracement entry | Weekly structure |

The higher TF is the trend you're trading **within**. If it conflicts with your
primary TF signal, reduce conviction or skip the trade.

### Tier 3: Multi-TF Summary (compact)

One-line per timeframe: RSI, MACD direction, ADX, Chop. Use this for:
- **Alignment check**: How many timeframes agree on direction?
- **Regime identification**: All Chop > 60 = ranging market, reduce size
- **Divergence spotting**: RSI 70+ on 1h but 30 on 4h = potential reversal

---

## C. CVD Interpretation Per Strategy

**This is the single most impactful filter.** Using the wrong CVD window caused
38% noise-driven closes on SWING in BebBot V3 production.

| Strategy | CVD Window | Why |
|----------|-----------|-----|
| FAST | 30s slope + 30s accel | Real-time flow for scalp entries |
| SWING | 1h slope | Avoids getting shaken out by 30s noise |
| MEDIUM | 1h slope | Same as SWING — hourly flow is the signal |
| POSITION | 4h slope | Only cares about sustained directional flow |

### Rules

- **FAST**: 30s CVD confirms immediate order flow direction. If CVD slope flips
  against your position while scalping, consider exit. The 30s acceleration
  (slope of slope) warns of flow momentum changes before the slope itself flips.

- **SWING**: 1h CVD slope shows whether smart money is accumulating or distributing
  over the last hour. Ignore 30s noise — it will shake you out of valid swings.
  A SWING entry with positive 1h CVD slope and negative 30s slope is fine —
  the 30s is just noise within the hourly trend.

- **POSITION**: 4h CVD slope shows sustained institutional flow. Short-term CVD
  readings are irrelevant for multi-day holds. Only exit on CVD if the 4h slope
  has been negative for multiple readings (flow reversal, not noise).

The analysis output **only shows your strategy's CVD window**. The other windows
are hidden to prevent you from anchoring on the wrong signal.

---

## D. Dual Direction Evaluation

Every decision cycle evaluates BOTH long and short setups simultaneously.
Never pre-select a direction — this eliminates directional anchoring bias.

### Process

1. **Build long case**: Entry, SL (using primary ATR), TP, R:R, supporting evidence
2. **Build short case**: Entry, SL (using primary ATR), TP, R:R, supporting evidence
3. **Compare**: Pick the direction with stronger evidence
4. **Decision**:
   - Strong long case, weak short → BUY
   - Strong short case, weak long → SELL
   - Both weak or conflicting → HOLD
   - Both strong but equal → HOLD (ambiguity = no edge)

### SL Placement

Use the **primary timeframe ATR** for stop loss distance:
- FAST: `atr.pct_5m` — typically 0.3-0.8%
- SWING: `atr.pct_15m` — typically 0.5-1.5%
- MEDIUM: `atr.pct_30m` — typically 0.8-2.0%
- POSITION: `atr.pct_D` — typically 2.0-5.0%

Place SL at 1.0-1.5x ATR beyond the nearest structure level (swing high/low,
support/resistance). This gives the trade room to breathe without
using arbitrary percentages.

---

## E. Execution Protocol

### Phase 0: Signal Alignment Check

Before deciding, acknowledge three independent signal sources:

1. **Technical Signal**: What does the primary TF chart say?
   - Key pattern or setup from indicators, price structure, trend analysis
   - Direction: BULLISH / BEARISH / NEUTRAL

2. **Fundamental Signal**: What does the news/macro context say?
   - Is the top-weighted factor (per strategy) a tailwind or headwind?
   - Any blocking events?
   - Direction: BULLISH / BEARISH / NEUTRAL

3. **Flow Signal**: What does the strategy-appropriate CVD show?
   - Is order flow confirming or diverging from the technical setup?
   - Direction: BULLISH / BEARISH / NEUTRAL

Alignment count determines conviction:
- 0/3 aligned → HOLD
- 1/3 aligned → Low conviction (small size, low leverage)
- 2/3 aligned → Medium conviction (moderate size)
- 3/3 aligned → High conviction (full allocation)

### Phase 1: Scheduled Events Filter

Check upcoming economic events in the fundamentals context:
- FOMC, CPI, NFP, or major scheduled event within 4 hours? → **HOLD**
- Reasoning: Event risk destroys edge. Sitting out costs nothing.
- Exception: If already in a position with a wide SL (POSITION strategy),
  you may hold through events — the SL handles it.

### Phase 2: Evidence Audit

List the key signals for and against:
- Which indicators on the primary TF confirm the direction?
- Does the higher contextual TF agree or disagree?
- Is the CVD slope aligned with the direction?
- Are support/resistance levels favorable for the entry?
- Is the market regime trending (ADX > 25, Chop < 50) or choppy?
- Are risk gates passing?

If opposing evidence is strong, reduce conviction by one tier.

---

## F. Risk Management Per Strategy

### Stop Loss Policy

Every trade requires a stop loss. No exceptions.

| Strategy | Min SL | Min TP | R:R Floor | R:R Ceiling | Primary ATR |
|----------|--------|--------|-----------|-------------|-------------|
| FAST | 0.5% | 0.8% | 1.2 | 2.0 | atr.pct_5m |
| SWING | 1.5% | 2.5% | 1.5 | 3.0 | atr.pct_15m |
| MEDIUM | 0.8% | 1.0% | 1.5 | 3.0 | atr.pct_30m |
| POSITION | 2.0% | 5.0% | 1.5 | 4.0 | atr.pct_D |

### R:R Ceiling (Why It Exists)

The R:R ceiling prevents gaming via unrealistically tight stops. BebBot V3 data
showed that trades with R:R > 2.0 on FAST strategy had a 22% win rate and
-$155 average PnL per trade. The tight stop gets hit by normal volatility
before the target can be reached.

If your calculated R:R exceeds the ceiling, either:
- Widen the stop loss (increase risk distance)
- Tighten the take profit (reduce reward distance)
- Or don't take the trade — the setup isn't clean enough

### Risk Gate Thresholds Per Strategy

| Gate | FAST | SWING | MEDIUM | POSITION |
|------|------|-------|--------|----------|
| Max Spread (bps) | 15 | 25 | 15 | 40 |
| Min Depth (USD) | $40K | $50K | $75K | $120K |
| Max Chop Index | 61 | 65 | 60 | 75 |

FAST needs tight spreads because slippage eats scalp profits.
POSITION tolerates wider spreads because the profit target is much larger.
MEDIUM needs the deepest order book because it trades larger sizes with longer holds.

### Leverage

Range: 1x to 5x default maximum (up to 10x if user explicitly requests).

Leverage scales with conviction:
- Low conviction (1/3 aligned) → 1-2x
- Medium conviction (2/3 aligned) → 2-3x
- High conviction (3/3 aligned) → 3-5x

### Position Sizing

```
size_usd = available_balance * (allocation_pct / 100) * leverage
```

Allocation scales from 0 to max based on conviction. Conservative approach:
- FAST: max 5-10% of balance per trade
- SWING: max 10-15% of balance per trade
- MEDIUM/POSITION: max 15-25% of balance per trade

---

## G. Position Management (Blindspot Monitor)

Once a position is open, management evaluation runs on each check cycle.

### Core Principle

The management agent is a **blindspot monitor**, NOT a second-guesser:
- SL/TP handle price-based exits (mechanical, set at entry)
- The agent's ONLY job: check if something in the **WORLD** changed

### HOLD (Default) — FUNDAMENTALS_INTACT

Hold when:
- No material news or macro change since entry
- The world looks roughly the same as when you entered
- Price is moving against you but within SL range — this is normal
- Technical indicators have shifted slightly — irrelevant, SL handles it

**Default to HOLD.** The SL and TP are doing their job.

### CLOSE — MACRO_SHIFT

Close only when something **external** happened that changes the risk:

- **Fed surprise**: Unexpected hawkish shift when long, dovish when short
- **Regulatory action**: SEC lawsuit, exchange ban, stablecoin crackdown
- **Black swan**: Exchange hack, major protocol exploit, liquidation cascade
- **Geopolitical shock**: War escalation, sanctions targeting crypto
- **Narrative collapse**: The catalyst that drove the entry has been denied/failed

### What Management Ignores (Critical)

- **Price levels or PnL** — SL/TP handle this
- **Technical indicators** — Already evaluated at entry, not re-evaluated
- **Whether the thesis "looks right"** in hindsight — Irrelevant
- **Other traders' opinions** — Not a signal
- **Unrealized PnL being negative** — This is what the SL is for

### Thesis Invalidation

Each entry trade should specify invalidation levels:
- **Long**: Downside invalidation — support level that breaks the long thesis
  (e.g., "1H close below $95,000")
- **Short**: Upside invalidation — resistance level that breaks the short thesis
  (e.g., "4H close above $100,000")

These are structural levels, not price targets. A breach means the setup
premise is broken — close regardless of PnL.

---

## H. Fundamentals Weighting Per Strategy

### Weighting Order

| Strategy | Weight Order |
|----------|-------------|
| FAST | sentiment > events > upcoming > macro |
| SWING | sentiment > events > upcoming > macro |
| MEDIUM | macro > upcoming > events > sentiment |
| POSITION | macro > upcoming > events > sentiment |

FAST/SWING care about short-term narrative: "Is there panic? Is there FOMO?
Did something just happen?" The 15-minute to 2-hour hold period means
short-term sentiment drives price more than macro fundamentals.

MEDIUM/POSITION care about the big picture: "Where are rates going?
Is crypto adoption accelerating or stalling? What's the regulatory trajectory?"
Multi-day to multi-week holds are driven by macro forces, not today's headlines.

### Fundamentals Categories

1. **Sentiment**: Crypto-specific market mood — fear/greed, whale movements,
   exchange flows, social momentum, narrative shifts

2. **Events**: Recent notable happenings — protocol upgrades, hacks, delistings,
   major announcements, ETF flows

3. **Upcoming**: Scheduled economic calendar — FOMC, CPI, NFP, PCE, Powell
   speeches, options expiry, token unlocks

4. **Macro**: Fed policy direction, interest rates, inflation trajectory,
   DXY strength, risk-on/risk-off regime, liquidity conditions

### How to Use Fundamentals

The analysis output shows "Fundamentals weight: X > Y > Z > W" for your strategy.
This tells you which category matters most for your trade.

Before every decision:
1. Pull current market context using available news/search tools
2. Evaluate each category
3. Weight them in the order shown
4. If the top-weighted category is a headwind, reduce conviction by one tier
5. If a blocking event (FOMC/CPI within 4h), consider HOLD regardless

If you cannot assess the current fundamental landscape:
- Flag to the user: "No current fundamental data — proceeding on technicals only"
- Reduce max conviction to 2/3 (never full conviction without fundamentals)

---

## Decision Output

### For Entry Decisions (BUY/SELL)

Present to the user before executing:

```
Direction: LONG/SHORT
Strategy: SWING (15m chart, 2-8h holds)

Alignment: 2/3 (Technical: BULLISH, Fundamental: NEUTRAL, Flow: BULLISH)
Conviction: Medium

Entry: $67,432 (current mark)
Stop Loss: $66,300 (-1.68%, 1.2x ATR_15m)
Take Profit: $69,400 (+2.92%)
R:R: 1.73

Size: $500 @ 2x leverage
Key supporting: [RSI divergence on 15m, 1h CVD slope positive, bid-heavy OB]
Key risks: [4h trend neutral, upcoming CPI in 8h]
```

Wait for user confirmation before executing.

### For Management Decisions (HOLD/CLOSE)

```
Decision: HOLD
Reason: FUNDAMENTALS_INTACT
Notes: No material change since entry. Price down 0.8% but within SL range.
       1h CVD still positive. No scheduled events within 4h.
```

Or:

```
Decision: CLOSE
Reason: MACRO_SHIFT
Event: Unexpected hawkish Fed commentary — rate cut expectations repriced
Impact: Risk-off shift, BTC correlation to rates elevated
Action: Close LONG at market
```
