# QuantClaw Fundamentals Guide

Reference document for the fundamentals enrichment system. This defines how QuantClaw
gathers, structures, and uses news/macro context in trading decisions.

---

## Overview

Fundamentals provide the "world context" that pure technical/quantitative analysis
cannot see. Before every decision cycle, the agent receives a structured narrative
covering four categories of news, plus a scheduled events calendar.

The fundamentals system answers: **"What is happening in the world that affects
this trade?"**

---

## 4-Category News Structure

News is gathered and organized into four categories, each with specific relevance
to crypto trading.

### 1. Crypto News

Direct cryptocurrency market news. Highest immediacy for short-term strategies.

**What to look for:**
- Major exchange events (listings, delistings, hacks, outages)
- Protocol upgrades or failures (hard forks, exploits, bridge hacks)
- Large whale movements or liquidation cascades
- ETF flows (Bitcoin/Ethereum spot ETF inflows/outflows)
- Stablecoin events (depegs, regulatory action on USDT/USDC)
- Market-wide sentiment shifts (fear/greed extremes)

**Search query**: `cryptocurrency market news today bitcoin ethereum`
**Freshness**: Past day

### 2. Macro / Fed News

Federal Reserve policy, interest rates, and inflation data. Drives risk-on/risk-off
sentiment across all markets including crypto.

**What to look for:**
- Fed rate decisions and forward guidance
- Inflation data surprises (CPI above/below expectations)
- Employment data (NFP, unemployment claims)
- Dollar strength/weakness (DXY moves)
- Treasury yield movements
- Risk appetite signals (VIX, equity market moves)

**Search query**: `federal reserve interest rates inflation crypto impact`
**Freshness**: Past week

### 3. Regulatory News

Government and regulatory actions specific to crypto. Can cause sudden, large moves.

**What to look for:**
- SEC enforcement actions and lawsuits
- New legislation or executive orders
- Country-level bans or restrictions
- Exchange regulatory compliance issues
- Stablecoin regulation developments
- Tax policy changes

**Search query**: `cryptocurrency regulation SEC lawsuit ban enforcement`
**Freshness**: Past day (time-sensitive)

### 4. Geopolitical Events

Global events that affect market risk appetite. Less frequent but higher impact.

**What to look for:**
- Military conflicts and escalation/de-escalation
- Trade wars, tariffs, sanctions
- Political instability in major economies
- Energy/commodity supply disruptions
- International agreements or breakdowns

**Search query**: `geopolitical risk sanctions war tariff market impact`
**Freshness**: Past day (breaking news)

---

## Nuclear Events Calendar

Certain scheduled economic events can destroy any trade setup regardless of
technical quality. These "nuclear" events cause outsized volatility and make
all technical analysis temporarily unreliable.

### Nuclear Events List

| Event | Frequency | Typical Impact | Why It Matters |
|-------|-----------|----------------|----------------|
| **NFP** (Non-Farm Payrolls) | Monthly (1st Friday) | Extreme | Employment health drives Fed policy expectations |
| **FOMC** (Fed Meeting) | ~8x/year | Extreme | Rate decisions + forward guidance move all markets |
| **CPI** (Consumer Price Index) | Monthly | Very High | Inflation data directly affects rate expectations |
| **Interest Rate Decision** | With FOMC | Extreme | Actual rate changes vs expectations |
| **Powell Speeches** | Irregular | High | Fed chair comments can shift narrative instantly |

### Nuclear Event Keywords

The system monitors for these keywords in the economic calendar:
- `nonfarm`, `non-farm`, `payroll` (NFP)
- `fomc` (Fed meetings and minutes)
- `cpi` (inflation data)
- `interest rate` (rate decisions)
- `powell` (Fed chair speeches)
- `trump`, `president` (tariff/policy regime driver)

### Trading Rules Around Nuclear Events

- **Within 4 hours of a nuclear event**: HOLD (do not enter new positions)
- **During event**: No new entries. Management agent may hold existing positions
  unless the event outcome contradicts the trade thesis.
- **After event**: Wait for initial volatility to settle before re-evaluating.

### Calendar Source

Economic calendar data comes from Forex Factory's free structured API, filtered to:
- USD-denominated events only
- High-impact events only
- Future events (past events discarded)

Events are formatted with time-until, forecast, and previous values:
```
FOMC Rate Decision [HIGH] - in 6 hours (forecast: 5.50%, prev: 5.50%)
CPI m/m [HIGH] - tomorrow (forecast: 0.2%, prev: 0.3%)
```

---

## Sentiment Assessment Framework

The fundamentals system produces a structured sentiment assessment consumed by the
trading agent.

### Sentiment Fields

| Field | Type | Description |
|-------|------|-------------|
| `macro_context` | string | 1-2 sentences about macro conditions |
| `crypto_sentiment` | string | 1-2 sentences about crypto market sentiment |
| `key_events` | list | Recent notable events (up to 5) |
| `upcoming_events` | list | Scheduled economic events (up to 5) |
| `direction` | enum | BULLISH / BEARISH / NEUTRAL |
| `score` | float | -1.0 to 1.0 sentiment score |

### Direction Assessment

- **BULLISH**: Risk-on environment, dovish Fed, positive crypto news, institutional inflows
- **BEARISH**: Risk-off environment, hawkish Fed, negative crypto news, regulatory pressure
- **NEUTRAL**: Mixed signals, uncertainty, no clear directional bias

### Score Scale

| Score Range | Interpretation |
|-------------|----------------|
| 0.7 to 1.0 | Strong bullish (clear risk-on, multiple positive catalysts) |
| 0.3 to 0.7 | Moderate bullish (generally positive but some uncertainty) |
| -0.3 to 0.3 | Neutral (mixed signals, no clear direction) |
| -0.7 to -0.3 | Moderate bearish (generally negative but not extreme) |
| -1.0 to -0.7 | Strong bearish (clear risk-off, multiple negative catalysts) |

---

## Fundamentals Integration with Trading

### For Entry Decisions

Fundamentals are one of the three "brains" in the triangulation process:

1. **Technical**: Chart patterns, indicators, price structure
2. **Fundamental**: Macro + crypto narrative (this guide)
3. **Agent synthesis**: Combining all inputs into a decision

The weight of fundamentals varies by strategy:
- **FAST/SWING**: `sentiment > events > upcoming > macro`
  (Short-term trades care more about immediate sentiment shifts)
- **MEDIUM/POSITION**: `macro > upcoming > events > sentiment`
  (Longer trades care more about macro trends and upcoming catalysts)

### For Management Decisions

The management agent acts as a **fundamentals watchdog**:
- Default: HOLD (the world looks the same as when the trade was entered)
- Only close if the fundamental context has materially changed AGAINST the position

The management agent ignores price/PnL and focuses exclusively on:
- Has breaking news changed the risk profile?
- Has macro context shifted against this position?
- Is there a regulatory/geopolitical event that makes this trade dangerous?

---

## Soft Brain Gate

If the fundamentals system cannot produce a valid assessment (API failures,
no search results, stale data), the agent flags this to the user rather than
trading blind.

### Gate Conditions

- **No fundamentals data available**: Flag as `BRAIN_INCOMPLETE`. The agent should
  not enter new positions without a current market narrative.
- **Stale data** (snapshot expired): Treat as missing. The fundamentals snapshot has
  a TTL and becomes invalid after expiration.
- **Partial data** (some categories returned empty): Acceptable. Not all categories
  will have results at all times. The agent can work with available data.

### Behavior When Gated

- New entries: HOLD (do not trade without world context)
- Existing positions: Continue managing based on SL/TP mechanics. The management
  agent can still hold existing positions while flagging the data gap.
- User notification: Log a warning that fundamentals are unavailable

The gate is "soft" because it does not crash the system - it prevents new entries
while allowing existing position management to continue.

---

## Data Flow

```
Search APIs (Brave)  ──→  4-category results
Forex Factory        ──→  Economic calendar
                          │
                          ▼
               LLM Summarizer
          (condense into narrative)
                          │
                          ▼
            FundamentalsSnapshot
     (macro_context, crypto_sentiment,
      key_events, upcoming_events,
      direction, score)
                          │
                          ▼
         Injected into agent prompt
      (as market_context XML/Markdown)
```

The snapshot is cached with a TTL. Multiple trading strategies can share the same
fundamentals snapshot since world context is not timeframe-specific.
