# Bybit Setup Guide

Step-by-step guide to set up Bybit for use with QuantClaw.

---

## 1. Create a Bybit Account

1. Go to [bybit.com](https://www.bybit.com)
2. Click "Sign Up" and register with email or phone
3. Complete identity verification (KYC) if required for your region
4. Enable 2FA (two-factor authentication) - required for API access

### Demo Account (Testnet)

For paper trading without real funds:

1. Go to [testnet.bybit.com](https://testnet.bybit.com)
2. Create a separate testnet account (different from live)
3. No KYC required for testnet

---

## 2. Generate API Keys

### For Demo (Testnet)

1. Log in to [testnet.bybit.com](https://testnet.bybit.com)
2. Click your profile icon → **API Management**
3. Click **Create New Key**
4. Select **System-generated API Keys**
5. Name: `quantclaw-demo` (or any descriptive name)
6. Key Permissions:
   - **Read-Write** (required for placing orders)
   - Enable: **Contract - Order**, **Contract - Position**
   - Enable: **Wallet - Account Transfer**, **Wallet - Subaccount Transfer** (for balance checks)
7. IP restriction: Optional for testnet (recommended for live)
8. Click **Submit** and complete 2FA
9. **Copy both the API Key and API Secret immediately** - the secret is only shown once

### For Live Trading

1. Log in to [bybit.com](https://www.bybit.com)
2. Same steps as above, but with additional security:
   - **Restrict to your server's IP address** (strongly recommended)
   - Consider using a sub-account for isolation
   - Set appropriate permission scope (minimum required)

---

## 3. Fund Demo Account

Bybit testnet provides free test funds:

1. Log in to [testnet.bybit.com](https://testnet.bybit.com)
2. Go to **Assets** → **Spot Account** or **Derivatives Account**
3. Click **Deposit** or use the testnet faucet
4. Request test USDT (typically 10,000 USDT available)
5. Transfer funds to your **Unified Trading Account** if needed:
   - Assets → Transfer → From Spot to Unified Trading Account

Testnet funds have no real value and can be replenished at any time.

---

## 4. Set Up Environment Variables

Create a `.env` file in your QuantClaw project root or export the variables in your shell.

### Required Variables

```bash
# Bybit API credentials
BYBIT_API_KEY=your_api_key_here
BYBIT_API_SECRET=your_api_secret_here

# Trading mode: "demo" for testnet, "live" for real trading
BYBIT_MODE=demo
```

### How to Set Them

**Option A: .env file** (recommended for development)

Create `/path/to/quantclaw/.env`:
```
BYBIT_API_KEY=AbCdEfGhIjKlMnOp
BYBIT_API_SECRET=xYz123456789AbCdEfGhIjKlMnOpQrSt
BYBIT_MODE=demo
```

**Option B: Shell export** (for server/CI)

```bash
export BYBIT_API_KEY=AbCdEfGhIjKlMnOp
export BYBIT_API_SECRET=xYz123456789AbCdEfGhIjKlMnOpQrSt
export BYBIT_MODE=demo
```

### API Endpoints

QuantClaw automatically selects the correct endpoint based on `BYBIT_MODE`:
- `demo` → `https://api-testnet.bybit.com`
- `live` → `https://api.bybit.com`

---

## 5. Verify Setup

Run the balance check command to confirm everything is connected:

```bash
uv run quantclaw balance
```

### Expected Output (Demo)

```
Bybit Account Balance (DEMO)
━━━━━━━━━━━━━━━━━━━━━━━━━━━━
Total Equity:      10,000.00 USDT
Available Balance:  10,000.00 USDT
Used Margin:             0.00 USDT
Unrealized PnL:          0.00 USDT
```

### Troubleshooting

| Error | Cause | Fix |
|-------|-------|-----|
| `Invalid API key` | Wrong key or key from wrong environment | Ensure demo key is from testnet, live key from bybit.com |
| `Permission denied` | API key lacks required permissions | Re-create key with Contract + Wallet permissions |
| `IP restriction` | Your IP is not in the API key's allowlist | Add your current IP or remove IP restriction |
| `Timestamp error` | System clock is out of sync | Sync your system clock (`ntpdate` or equivalent) |
| `BYBIT_API_KEY not set` | Environment variable missing | Check your .env file or shell exports |

---

## Security Notes

- **Never commit API keys to git**. Add `.env` to your `.gitignore`.
- **Use IP restrictions on live keys**. Restrict to your server's IP address.
- **Use a sub-account for trading**. Isolate trading funds from your main account.
- **Start with demo mode**. Always test strategies on testnet before going live.
- **Monitor API key usage**. Bybit shows API call history in the dashboard.
- **Rotate keys periodically**. Delete and recreate keys on a regular schedule.
