---
name: quant-trading-cn
description: 量化交易专家 - 基于印度股市实战经验，支持策略生成、回测、实盘交易（Zerodha/A股适配）
metadata:
  openclaw:
    emoji: "📈"
    category: "finance"
    tags: ["trading", "quant", "algotrading", "india", "zerodha", "backtest"]
    requires:
      bins: ["python3"]
---

# 量化交易专家

基于 1780 行印度股市实战经验的量化交易系统。

## 功能

### 🎯 交互式机器人生成向导

```bash
# 启动向导
./scripts/wizard.sh

# 选择：
# 1. 从头生成交易机器人
# 2. 增强现有代码（修复问题、优化）
# 3. 从实时指数数据创建股票池
# 4. 运行回测对比
# 5. 分析表现
```

### 📊 16 个知识领域

1. **Zerodha 集成** - Tick size 四舍五入、仓位对账、止损生命周期
2. **回测-实盘一致性** - 数据缓存、T vs T-1 对齐、VWAP 重置
3. **信号生成** - Fortress 信号（65% 胜率）、多因子确认
4. **调仓逻辑** - 周频 vs 日频、交易成本建模
5. **股票池选择** - 流动性过滤、动量评分
6. **性能优化** - Parquet（28x）、Polars 向量化（37x）
7. **印度市场特性** - 交易时段、熔断机制、T+1 结算
8. **失败模式** - 5 个生产问题 + 修复
9. **指标公式** - RSI、MACD、ATR、ADX、VWAP、EMA
10. **多时间框架** - 日内 vs 波段、MTF 对齐
11. **日志可观测** - 结构化日志、实时监控
12. **交易后分析** - P&L 分解、夏普比率、回撤分析
13. **信号归因** - 追踪哪个指标触发
14. **退出策略** - 时间衰减、追踪止损、部分退出
15. **风险管理** - Kelly Criterion、组合热度
16. **资金复利** - 市场状态检测、牛市放大

### ⚠️ 30+ 常见陷阱

```markdown
🔥 关键：Tick Size 四舍五入
错误：kite.place_order(price=1847.35, ...)
报错："Tick size for this script is 5.00"
修复：price = round(price / tick_size) * tick_size  # 1847.35 → 1850.00
影响：90% 订单拒绝是 tick size 错误

🔥 关键：VWAP 必须每日重置
错误：跨天累计 VWAP
症状：回测 65% 胜率，实盘 40%
修复：开盘时重置（9:15）
影响：回测-实盘不一致的第一大原因
```

## 使用方法

### 生成第一个交易机器人

```bash
./scripts/wizard.sh
```

向导会问：
- 交易风格：日内、波段、持仓
- 股票池：Nifty 50、中盘、自定义
- 策略：动量、VWAP 回调、开盘突破
- 资金：起始资金和单笔风险
- 风险偏好：保守（0.5%）、平衡（1%）、激进（2%）

### 获取股票池

```bash
# 从 NSE 获取最新成分股
./scripts/universe-fetch.sh --indices nifty50,nifty100,midcap150
```

### 分析现有代码

```bash
./scripts/check-code.sh ./my_trading_bot.py

# 输出：
⚠️ 发现 3 个问题：
1. Tick size 未四舍五入（第 45 行）- 会导致订单拒绝
2. VWAP 未每日重置（第 89 行）- 回测实盘不一致
3. 无股票冷却期（第 120 行）- 报复交易风险
```

## 性能基准

| 优化 | 之前 | 之后 | 提升 |
|------|------|------|------|
| Parquet 缓存 | 2.3s | 0.08s | 28.7x |
| Polars 向量化 | 450ms | 12ms | 37.5x |
| API 批量请求 | 15 次 | 1 次 | 15x |
| 预计算指标 | 180ms | 90ms | 2x |
| **总回测时间** | 5 min | 12 sec | **25x** |

## 文件结构

```
quant-trading-cn/
├── SKILL.md           # 本文件
├── KNOWLEDGE.md       # 16 个领域（1780 行）
├── NUANCES.md         # 30+ 陷阱
├── scripts/
│   ├── wizard.sh      # 交互式向导
│   ├── universe-fetch.sh  # 股票池获取
│   └── check-code.sh  # 代码检查
└── references/
    ├── KNOWLEDGE_en.md   # 原始英文版
    └── NUANCES_en.md     # 原始英文版
```

## A 股适配

本项目基于印度市场，但可适配 A 股：

| 印度 | A 股 |
|------|------|
| Zerodha | 雪球/同花顺 |
| Nifty 50 | 沪深 300 |
| Nifty Midcap | 中证 500 |
| T+1 结算 | T+1 结算 |
| 9:15-15:30 | 9:30-15:00 |

## 注意事项

⚠️ 本 skill 提供教育性指导，不保证盈利。交易有风险，仅用可承受资金。

---

*版本: 1.0.0*
*来源: [skill-algotrader](https://github.com/javajack/skill-algotrader)*
