---
name: quality-manager-qmr
description: Senior Quality Manager Responsible Person (QMR) for HealthTech and MedTech companies. Provides quality system governance, management review leadership, regulatory compliance oversight, and quality performance monitoring per ISO 13485 Clause 5.5.2.
triggers:
  - management review
  - quality policy
  - quality objectives
  - QMR responsibilities
  - quality system effectiveness
  - quality KPIs
  - cost of quality
  - quality performance
  - management accountability
  - regulatory oversight
  - quality culture
  - quality governance
---

# Senior Quality Manager Responsible Person (QMR)

Quality system accountability, management review leadership, and regulatory compliance oversight per ISO 13485 Clause 5.5.2 requirements.

---

## Table of Contents

- [QMR Responsibilities](#qmr-responsibilities)
- [Management Review Workflow](#management-review-workflow)
- [Quality KPI Management Workflow](#quality-kpi-management-workflow)
- [Quality Objectives Workflow](#quality-objectives-workflow)
- [Quality Culture Assessment Workflow](#quality-culture-assessment-workflow)
- [Regulatory Compliance Oversight](#regulatory-compliance-oversight)
- [Decision Frameworks](#decision-frameworks)
- [Tools and References](#tools-and-references)

---

## QMR Responsibilities

### ISO 13485 Clause 5.5.2 Requirements

| Responsibility | Scope | Evidence |
|----------------|-------|----------|
| QMS effectiveness | Monitor system performance and suitability | Management review records |
| Reporting to management | Communicate QMS performance to top management | Quality reports, dashboards |
| Quality awareness | Promote regulatory and quality requirements | Training records, communications |
| Liaison with external parties | Interface with regulators, Notified Bodies | Meeting records, correspondence |

### QMR Accountability Matrix

| Domain | Accountable For | Reports To | Frequency |
|--------|-----------------|------------|-----------|
| Quality Policy | Policy adequacy and communication | CEO/Board | Annual review |
| Quality Objectives | Objective achievement and relevance | Executive Team | Quarterly |
| QMS Performance | System effectiveness metrics | Management | Monthly |
| Regulatory Compliance | Compliance status across jurisdictions | CEO | Quarterly |
| Audit Program | Audit schedule completion, findings closure | Management | Per audit |
| CAPA Oversight | CAPA effectiveness and timeliness | Executive Team | Monthly |

### Authority Boundaries

| Decision Type | QMR Authority | Escalation Required |
|---------------|---------------|---------------------|
| Process changes within QMS | Approve with owner | Major process redesign |
| Document approval | Final QA approval | Policy-level changes |
| Nonconformity disposition | Accept/reject with MRB | Product release decisions |
| Supplier quality actions | Quality holds, audits | Supplier termination |
| Audit scheduling | Adjust internal audit schedule | External audit timing |
| Training requirements | Define quality training needs | Organization-wide training budget |

---

## Management Review Workflow

Conduct management reviews per ISO 13485 Clause 5.6 requirements.

### Workflow: Prepare and Execute Management Review

1. Schedule management review (minimum annually, typically quarterly or semi-annually)
2. Notify all required attendees minimum 2 weeks prior
3. Collect required inputs from process owners:
   - Audit results (internal and external)
   - Customer feedback (complaints, satisfaction, returns)
   - Process performance and product conformity
   - CAPA status and effectiveness
   - Previous review action items
   - Changes affecting QMS (regulatory, organizational)
   - Recommendations for improvement
4. Compile input summary report with trend analysis
5. Prepare presentation materials with supporting data
6. Distribute agenda and input package 1 week prior
7. Conduct review meeting per agenda
8. **Validation:** All required inputs reviewed; decisions documented with owners and due dates

### Required Attendees

| Role | Requirement | Input Responsibility |
|------|-------------|---------------------|
| CEO/General Manager | Required | Strategic decisions |
| QMR | Chair | Overall QMS status |
| Department Heads | Required | Process performance |
| RA Manager | Required | Regulatory changes |
| Production Manager | Required | Product conformity |
| Customer Quality | Required | Complaint data |

### Management Review Input Template

```
MANAGEMENT REVIEW INPUT SUMMARY

Review Period: [Start Date] to [End Date]
Review Date: [Scheduled Date]
Prepared By: [QMR Name]

1. AUDIT RESULTS
   Internal audits completed: [X] of [X] planned
   External audits completed: [X]
   Total findings: [X] major / [X] minor
   Open findings: [X]
   Finding trends: [Analysis]

2. CUSTOMER FEEDBACK
   Complaints received: [X]
   Complaint rate: [X per 1000 units]
   Customer satisfaction score: [X.X/5.0]
   Returns: [X] units ([X]%)
   Top issues: [Categories]

3. PROCESS PERFORMANCE
   [Process 1]: [Metric] vs [Target] - [Status]
   [Process 2]: [Metric] vs [Target] - [Status]
   Out-of-spec processes: [List]

4. PRODUCT CONFORMITY
   First pass yield: [X]%
   Nonconformance rate: [X]%
   Scrap cost: $[X]
   Top defect categories: [List]

5. CAPA STATUS
   Open CAPAs: [X]
   Overdue: [X]
   Effectiveness rate: [X]%
   Average age: [X] days

6. PREVIOUS ACTIONS
   Total from last review: [X]
   Completed: [X] | In progress: [X] | Overdue: [X]

7. CHANGES AFFECTING QMS
   Regulatory: [List changes]
   Organizational: [List changes]
   Process: [List changes]

8. RECOMMENDATIONS
   [Collected improvement opportunities]
```

### Management Review Output Requirements

| Output | Documentation | Owner |
|--------|---------------|-------|
| QMS improvement decisions | Action items with due dates | Assigned per item |
| Resource needs | Resource plan updates | Department heads |
| Quality objectives changes | Updated objectives document | QMR |
| Process improvement needs | Improvement project charters | Process owners |

See: [references/management-review-guide.md](references/management-review-guide.md)

---

## Quality KPI Management Workflow

Establish, monitor, and report quality performance indicators.

### Workflow: Establish Quality KPI Framework

1. Identify quality objectives requiring measurement
2. Select KPIs per objective using SMART criteria:
   - Specific: Clear definition and calculation
   - Measurable: Quantifiable with available data
   - Actionable: Team can influence results
   - Relevant: Aligned to quality objectives
   - Time-bound: Defined measurement frequency
3. Define target values based on baseline data and benchmarks
4. Assign data source and collection responsibility
5. Establish reporting frequency per KPI category
6. Configure dashboard displays and trend analysis
7. Define escalation thresholds and alert triggers
8. **Validation:** Each KPI has owner, target, data source, and escalation criteria

### Core Quality KPIs

| Category | KPI | Target | Calculation |
|----------|-----|--------|-------------|
| Process | First Pass Yield | >95% | (Units passed first time / Total units) × 100 |
| Process | Nonconformance Rate | <1% | (NC count / Total units) × 100 |
| CAPA | CAPA Closure Rate | >90% | (On-time closures / Due closures) × 100 |
| CAPA | CAPA Effectiveness | >85% | (Effective CAPAs / Verified CAPAs) × 100 |
| Audit | Finding Closure Rate | >90% | (On-time closures / Due closures) × 100 |
| Audit | Repeat Finding Rate | <10% | (Repeat findings / Total findings) × 100 |
| Customer | Complaint Rate | <0.1% | (Complaints / Units sold) × 100 |
| Customer | Satisfaction Score | >4.0/5.0 | Average of survey scores |

### KPI Review Frequency

| KPI Type | Review Frequency | Trend Period | Audience |
|----------|------------------|--------------|----------|
| Safety/Compliance | Daily monitoring | Weekly | Operations |
| Production Quality | Weekly | Monthly | Department heads |
| Customer Quality | Monthly | Quarterly | Executive team |
| Strategic Quality | Quarterly | Annual | Board/C-suite |

### Performance Response Matrix

| Performance Level | Status | Action Required |
|-------------------|--------|-----------------|
| >110% of target | Exceeding | Consider raising target |
| 100-110% of target | Meeting | Maintain current approach |
| 90-100% of target | Approaching | Monitor closely |
| 80-90% of target | Below | Improvement plan required |
| <80% of target | Critical | Immediate intervention |

See: [references/quality-kpi-framework.md](references/quality-kpi-framework.md)

---

## Quality Objectives Workflow

Establish and maintain measurable quality objectives per ISO 13485 Clause 5.4.1.

### Workflow: Annual Quality Objectives Setting

1. Review prior year objective achievement
2. Analyze quality performance trends and gaps
3. Align with organizational strategic plan
4. Draft objectives with measurable targets
5. Validate resource availability for achievement
6. Obtain executive approval
7. Communicate objectives organization-wide
8. **Validation:** Each objective is measurable, has owner, target, and timeline

### Quality Objective Structure

```
QUALITY OBJECTIVE [Number]

Objective Statement: [Clear, measurable statement]
Aligned to Policy Element: [Quality policy section]
Target: [Specific measurable target]
Baseline: [Current performance]
Owner: [Name and title]
Due Date: [Target achievement date]

Success Criteria:
- [Criterion 1]
- [Criterion 2]

Measurement Method: [How progress is tracked]
Reporting Frequency: [Monthly/Quarterly]

Supporting Initiatives:
- [Initiative 1]
- [Initiative 2]

Resource Requirements:
- [Resource 1]
- [Resource 2]
```

### Objective Categories

| Category | Example Objectives | Typical Targets |
|----------|-------------------|-----------------|
| Customer Quality | Reduce complaint rate | <0.1% of units sold |
| Process Quality | Improve first pass yield | >96% |
| Compliance | Maintain certification | Zero major NCs |
| Efficiency | Reduce quality costs | <4% of revenue |
| Culture | Increase training completion | >98% on-time |

### Quarterly Objective Review

| Review Element | Assessment | Action |
|----------------|------------|--------|
| Progress vs. target | On track / Behind / Ahead | Adjust resources if behind |
| Relevance | Still valid / Needs update | Modify if conditions changed |
| Resources | Adequate / Insufficient | Request additional if needed |
| Barriers | Identified obstacles | Escalate for resolution |

---

## Quality Culture Assessment Workflow

Assess and improve organizational quality culture.

### Workflow: Annual Quality Culture Assessment

1. Design or select quality culture survey instrument
2. Define survey population (all employees or sample)
3. Communicate survey purpose and confidentiality
4. Administer survey with 2-week response window
5. Analyze results by department, role, and tenure
6. Identify strengths and improvement areas
7. Develop action plan for culture gaps
8. **Validation:** Response rate >60%; action plan addresses bottom 3 scores

### Quality Culture Dimensions

| Dimension | Indicators | Assessment Method |
|-----------|------------|-------------------|
| Leadership commitment | Management visible support for quality | Survey, observation |
| Quality ownership | Employees feel responsible for quality | Survey |
| Communication | Quality information flows effectively | Survey, audit |
| Continuous improvement | Suggestions submitted and implemented | Metrics |
| Training and competence | Employees feel adequately trained | Survey, records |
| Problem solving | Issues addressed at root cause | CAPA analysis |

### Culture Survey Categories

| Category | Sample Questions |
|----------|------------------|
| Leadership | "Management demonstrates commitment to quality" |
| Resources | "I have the tools and training to do quality work" |
| Communication | "Quality expectations are clearly communicated" |
| Empowerment | "I am encouraged to report quality issues" |
| Recognition | "Quality achievements are recognized" |

### Culture Improvement Actions

| Gap Identified | Potential Actions |
|----------------|-------------------|
| Low leadership visibility | Quality gemba walks, all-hands quality updates |
| Inadequate training | Competency-based training program |
| Poor communication | Quality newsletters, department huddles |
| Low reporting | Anonymous reporting system, no-blame culture |
| Lack of recognition | Quality award program, team celebrations |

---

## Regulatory Compliance Oversight

Monitor and maintain regulatory compliance across jurisdictions.

### Multi-Jurisdictional Compliance Matrix

| Jurisdiction | Regulation | Requirement | Status Tracking |
|--------------|------------|-------------|-----------------|
| EU | MDR 2017/745 | CE marking, Notified Body | Technical file, annual review |
| USA | 21 CFR 820 | FDA registration, QSR compliance | Annual registration, inspections |
| International | ISO 13485 | QMS certification | Surveillance audits |
| Germany | MPG/MPDG | National implementation | Competent authority filings |

### Compliance Monitoring Workflow

1. Maintain regulatory requirement register
2. Subscribe to regulatory update services
3. Assess impact of regulatory changes monthly
4. Update affected processes within 90 days of effective date
5. Verify training completion for regulatory changes
6. Document compliance status in management review
7. Maintain inspection readiness checklist
8. **Validation:** All applicable requirements mapped; no expired registrations

### Regulatory Authority Interface

| Activity | QMR Role | Preparation Required |
|----------|----------|---------------------|
| Notified Body audit | Primary contact | Audit package, personnel schedules |
| FDA inspection | Host, escort coordinator | Inspection readiness review |
| Competent Authority inquiry | Response coordinator | Technical file access |
| Regulatory meeting | Attendee or delegate | Briefing materials |

### Inspection Readiness Checklist

| Area | Ready | Action Needed |
|------|-------|---------------|
| Document control system current | ☐ | |
| Training records complete | ☐ | |
| CAPA system current, no overdue items | ☐ | |
| Complaint files complete | ☐ | |
| Equipment calibration current | ☐ | |
| Supplier qualification files complete | ☐ | |
| Management review records available | ☐ | |
| Internal audit program current | ☐ | |

---

## Decision Frameworks

### Escalation Decision Tree

```
Issue Identified
      │
      ▼
Is it a regulatory violation?
      │
  Yes─┴─No
  │      │
  ▼      ▼
Escalate to    Is it a safety issue?
Executive          │
immediately    Yes─┴─No
               │      │
               ▼      ▼
          Escalate to   Does it affect
          Safety Team   multiple departments?
                             │
                         Yes─┴─No
                         │      │
                         ▼      ▼
                    Escalate to  Handle at
                    Executive    department level
```

### Quality Investment Prioritization

| Criteria | Weight | Score Method |
|----------|--------|--------------|
| Regulatory requirement | 30% | Required=10, Recommended=5, Optional=2 |
| Customer impact | 25% | Direct=10, Indirect=5, None=0 |
| Cost savings potential | 20% | >$100K=10, $50-100K=7, <$50K=3 |
| Implementation complexity | 15% | Simple=10, Moderate=5, Complex=2 |
| Strategic alignment | 10% | Core=10, Supporting=5, Peripheral=2 |

### Resource Allocation Matrix

| Resource Type | Allocation Authority | Escalation Threshold |
|---------------|---------------------|---------------------|
| Quality personnel | QMR | >1 FTE addition |
| Quality equipment | QMR | >$25K |
| External consultants | QMR | >$50K or >30 days |
| Quality systems | Executive approval | >$100K |

---

## Tools and References

### Scripts

| Tool | Purpose | Usage |
|------|---------|-------|
| [management_review_tracker.py](scripts/management_review_tracker.py) | Track review inputs, actions, metrics | `python management_review_tracker.py --help` |

**Management Review Tracker Features:**
- Track input collection status from process owners
- Monitor action item completion and aging
- Generate metrics summary for review
- Produce recommendations for review focus areas

### References

| Document | Content |
|----------|---------|
| [management-review-guide.md](references/management-review-guide.md) | ISO 13485 Clause 5.6 requirements, input/output templates, action tracking |
| [quality-kpi-framework.md](references/quality-kpi-framework.md) | KPI categories, targets, calculations, dashboard templates |

### Quick Reference: Management Review Inputs (ISO 13485 Clause 5.6.2)

| Input | Source | Required |
|-------|--------|----------|
| Feedback | Customer complaints, surveys | Yes |
| Audit results | Internal and external audits | Yes |
| Process performance | Process metrics | Yes |
| Product conformity | Inspection, NC data | Yes |
| CAPA status | CAPA system | Yes |
| Previous actions | Prior review records | Yes |
| Changes | Regulatory, organizational | Yes |
| Recommendations | All sources | Yes |

### Quick Reference: Management Review Outputs (ISO 13485 Clause 5.6.3)

| Output | Documentation Required |
|--------|----------------------|
| Improvement to QMS and processes | Action items with owners |
| Improvement to product | Project initiation if needed |
| Resource needs | Resource plan updates |

---

## Related Skills

| Skill | Integration Point |
|-------|-------------------|
| [quality-manager-qms-iso13485](../quality-manager-qms-iso13485/) | QMS process management |
| [capa-officer](../capa-officer/) | CAPA system oversight |
| [qms-audit-expert](../qms-audit-expert/) | Internal audit program |
| [quality-documentation-manager](../quality-documentation-manager/) | Document control oversight |
