# Quality Convergence Engine - Quick Reference

## 🎯 Core Functionality
Deeply deconstruct requirements → Eliminate extreme defects → Define objective standards

## ⚡ Trigger Keywords
- "quality acceptance"
- "code review"
- "architecture review"
- "solution error-proofing"
- "risk assessment"
- "acceptance criteria"

## 🚫 Block Conditions (Do Not Trigger)
- Basic code generation
- Casual conversation
- Pure theoretical discussion
- Simple queries

## 🔍 Analysis Framework

### Perspective A: Value Dimension
- What is the ultimate purpose?
- How is the user experience?
- Are core requirements satisfied?

### Perspective B: Logic Dimension
- Technical feasibility?
- Are boundary conditions clear?
- Edge cases considered?
- Is structure rigorous?

### Perspective C: Error-proofing Dimension
- Common implementation errors?
- Actual execution pain points?
- Easy-to-produce hallucinations?

## 📋 Output Template

### 1. Multi-dimensional Convergence Conclusion (within 150 words)
[Core breakthrough point] + [Maximum risk]

### 2. Red Light Conditions (Failure Bottom Line)
1. [Fatal defect 1 - Specific, falsifiable]
2. [Fatal defect 2 - Specific, falsifiable]
3. [Fatal defect 3 - Specific, falsifiable]

### 3. Green Light Acceptance Criteria (Success Standards)
1. [Core indicator 1]: Verification steps (specifically how to verify)
2. [Core indicator 2]: Verification steps
3. [Core indicator 3]: Verification steps

## 💡 Usage Tips

### Good Red Light Conditions:
✅ "Users can login without email verification"
✅ "Concurrent deductions cause negative inventory"
✅ "Service downtime triggers avalanche effect"

### Poor Red Light Conditions:
❌ "Code quality not high"
❌ "Performance might be poor"
❌ "User experience not good"

### Good Green Light Standards:
✅ "Load 10,000 rows of data, rendering time <3 seconds"
✅ "Simulate 100 concurrent users, inventory accurately deducted"
✅ "Old tokens immediately invalid after token refresh"

### Poor Green Light Standards:
❌ "Code should be elegant"
❌ "Performance should be fast"
❌ "User experience should be good"

## 🚨 Quality Checklist

### Requirement Clarity
- [ ] Is task domain clear?
- [ ] Are specific requirements specific?
- [ ] Are core focus points prominent?

### Risk Identification
- [ ] Based on actual pain points?
- [ ] Consider edge cases?
- [ ] Falsifiable?

### Acceptance Criteria
- [ ] Quantifiable?
- [ ] Verifiable?
- [ ] Verification steps specific?

## 📞 Emergency Contact
If encountering complex scenarios or unsure how to apply, refer to complete examples in EXAMPLES.md.