---
name: qrdex
description: Create, manage, and track QR codes using the QRdex.io REST API. Use when working with QR code generation, URL shortening with QR codes, WiFi QR codes, email/SMS/WhatsApp QR codes, scan tracking, or any QRdex.io operations. Supports all QR types (url, email, telephone, sms, whatsapp, wifi) with customizable colors and shapes.
---

# QRdex

Manage QR codes via the QRdex.io REST API.

## Setup

Set the API key as an environment variable:

```bash
export QRDEX_API_KEY="your-api-key"
```

Get a key from: QRdex.io → Team Settings → API section.
API access requires Growth plan or above.

## Quick Reference

Base URL: `https://qrdex.io/api/v1`

All requests require `Authorization: Bearer $QRDEX_API_KEY` and `Content-Type: application/json`.

### Create a QR Code

```bash
curl -X POST https://qrdex.io/api/v1/qr_codes \
  -H "Authorization: Bearer $QRDEX_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "qr_code": {
      "title": "My Website",
      "qr_type": "url",
      "url": "https://example.com"
    }
  }'
```

### QR Types and Required Fields

| Type | Required Fields |
|------|----------------|
| `url` | `url` |
| `email` | `email_address` (optional: `email_subject`, `message`) |
| `telephone` | `telephone_number` |
| `sms` | `telephone_number` (optional: `message`) |
| `whatsapp` | `telephone_number` (optional: `message`) |
| `wifi` | `wifi_ssid` (optional: `wifi_encryption`, `wifi_password`, `wifi_hidden`) |

### Common Optional Fields

- `foreground_color` — hex color (default: `#000000`)
- `background_color` — hex color (default: `#FFFFFF`)
- `shape` — QR code shape (default: `rounded`)
- `track_scans` — enable scan tracking (default: `true`)

### List QR Codes

```bash
curl https://qrdex.io/api/v1/qr_codes \
  -H "Authorization: Bearer $QRDEX_API_KEY"
```

Query params: `page`, `per_page` (max 100), `qr_type` filter.

### Get / Update / Delete

```bash
# Get
curl https://qrdex.io/api/v1/qr_codes/:id -H "Authorization: Bearer $QRDEX_API_KEY"

# Update (partial — only send changed fields)
curl -X PATCH https://qrdex.io/api/v1/qr_codes/:id \
  -H "Authorization: Bearer $QRDEX_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"qr_code": {"title": "New Title"}}'

# Delete (soft-delete)
curl -X DELETE https://qrdex.io/api/v1/qr_codes/:id -H "Authorization: Bearer $QRDEX_API_KEY"
```

### Download QR Image (SVG)

```bash
curl https://qrdex.io/api/v1/qr_codes/:id/image \
  -H "Authorization: Bearer $QRDEX_API_KEY" -o qr.svg
```

Returns `image/svg+xml`. Use the `image_url` field from any QR code response directly in `<img>` tags.

## Using the Python Script

For programmatic use, use `scripts/qrdex_api.py`:

```bash
# Set API key
export QRDEX_API_KEY="your-key"

# List QR codes
python scripts/qrdex_api.py list

# Create QR codes
python scripts/qrdex_api.py create --title "My Site" --type url --url "https://example.com"
python scripts/qrdex_api.py create --title "WiFi" --type wifi --ssid "Guest" --wifi-password "pass123"
python scripts/qrdex_api.py create --title "Email" --type email --email "hi@example.com"
python scripts/qrdex_api.py create --title "Chat" --type whatsapp --phone "+15551234567" --message "Hello!"

# Get details
python scripts/qrdex_api.py get 123

# Update
python scripts/qrdex_api.py update 123 --title "Updated Title" --fg-color "#FF0000"

# Delete
python scripts/qrdex_api.py delete 123

# Download image
python scripts/qrdex_api.py image 123 -o qr.svg
```

## Error Handling

- `401` — Invalid/missing API key
- `403` — No permission
- `404` — QR code not found or belongs to different team
- `422` — Validation error or plan limit reached
- `429` — Rate limited (100 req/min per key). Check `X-RateLimit-Remaining` header.

## API Reference

For full field descriptions and response schemas, see `references/API_REFERENCE.md`.
