# QR Deployment Patterns

## Restaurant / Hospitality

**Menu QR:**
- Place on every table — durable material (laminated, acrylic stand)
- Size: minimum 4x4 cm at table distance
- Link to mobile-optimized menu (not PDF)
- Consider dynamic QR → can update menu without reprinting

**Payment QR:**
- Separate from menu QR — different action, different placement
- Near register or on bill folder
- Test with all major payment apps in region

**Review collection:**
- After-meal placement (on receipt, bill folder)
- Direct link to Google/TripAdvisor review form
- Not on table — timing matters for reviews

## Retail

**Product info:**
- On shelf tags or packaging
- Link to detailed specs, reviews, comparisons
- Keep small — space is premium

**Loyalty/app download:**
- At checkout, prominent placement
- Incentivize scan (discount, points)
- Dynamic QR for A/B testing offers

## Events

**Tickets:**
- High error correction (H) — phones at angles, varying light
- Include human-readable ID as backup
- Test scanner hardware before event

**Check-in:**
- Large QRs at entrance (fast scan = faster lines)
- Multiple codes if capacity allows parallel scanning
- Backup: manual lookup by name/email

**Networking:**
- Badge QRs with vCard data
- Attendees scan each other → instant contact exchange
- Consider NFC complement for tech-savvy crowds

## Print Marketing

**Business cards:**
- vCard QR — one scan adds contact
- Keep minimal (name, phone, email, website)
- Test at actual card size before bulk print

**Flyers/posters:**
- Size proportional to expected viewing distance
- Clear call-to-action near QR ("Scan for 20% off")
- Track with UTM parameters or short link

**Packaging:**
- Product registration, instructions, support
- Durable print — survives shipping, handling
- Consider placement for post-unboxing visibility

## Digital Displays

**TV/monitors:**
- Hold static for 10+ seconds — people need time to scan
- Don't animate the QR itself
- Ensure screen refresh rate doesn't interfere (rare but possible)

**Presentations:**
- Resources, follow-up links, feedback forms
- Leave slide up long enough
- Provide short URL as text backup

## Best Practices Across All

1. **Always use dynamic QRs for anything that might change** — destinations, offers, menus
2. **Track scans** — use UTM parameters or QR platforms with analytics
3. **Provide text alternative** — some users prefer typing short URLs
4. **Test in actual environment** — lighting, angles, distances
5. **Version your QRs** — when reprinting, increment for tracking
