# 腾讯地图API技能

这是一个集成腾讯地图Web服务API的OpenClaw技能，提供地点搜索、逆地理编码、地理编码、路线规划等功能。

## 功能特性

- **地点搜索**: 按关键词搜索地点信息
- **逆地理编码**: 根据经纬度获取地址详情
- **地理编码**: 根据地址获取经纬度坐标
- **周边搜索**: 搜索指定坐标周围的POI
- **标准化输出**: 所有结果统一为结构化JSON格式

## 安装

1. 将此技能文件夹复制到OpenClaw的skills目录
2. 确保系统已安装`curl`和`python3`
3. 从[腾讯位置服务](https://lbs.qq.com/dev/console/application/)获取API密钥

## 配置

设置环境变量：

```bash
export TENCENT_MAP_KEY="YOUR_TENCENT_MAP_KEY"
```

## 使用示例

### 搜索花店
```bash
# 搜索广州地区的花店
bash /path/to/tencent_map.sh search "花店" "广州"

# 搜索天河区的花店，第一页，每页20个结果
bash /path/to/tencent_map.sh search "花店" "广州天河区" 1 20
```

### 逆地理编码
```bash
# 获取指定坐标的地址信息
bash /path/to/tencent_map.sh reverse_geocode 23.129405 113.264287
```

### 地理编码
```bash
# 获取地址的坐标
bash /path/to/tencent_map.sh geocode "广州市天河区珠江新城"
```

### 周边搜索
```bash
# 搜索指定坐标周围3公里内的花店
bash /path/to/tencent_map.sh around 23.129405 113.264287 "花店" 3000
```

## 输出格式

所有命令返回标准化JSON格式：

```json
{
  "status": 0,
  "message": "success",
  "pois": [
    {
      "id": "poi_id",
      "title": "地点名称",
      "address": "详细地址",
      "category": "类别",
      "tel": "电话号码",
      "location": {
        "lat": 23.129405,
        "lng": 113.264287
      },
      "overall_rating": 4.5
    }
  ],
  "count": 10
}
```

## 注意事项

- 需要有效的腾讯地图API密钥
- API调用受腾讯地图服务条款限制
- 请遵守每日调用次数限制