#!/bin/bash
# ClawHub 手动发布助手

cat << 'EOF'
═══════════════════════════════════════════════════════════
🚀 ClawHub 发布 - 手动步骤指南
═══════════════════════════════════════════════════════════

由于自动化遇到技术限制，请按以下步骤手动发布：

步骤 1: 打开 ClawHub
─────────────────────
在浏览器中访问: https://clawhub.com
确保已登录账号

步骤 2: 进入发布页面
─────────────────────
点击顶部导航栏的 "Publish" 或 "发布 Skill"

步骤 3: 上传文件
─────────────────────
1. 点击 "选择文件" 或 "Upload"
2. 选择文件: ~/Desktop/qqbot-v1.0.0.zip
3. 等待上传完成

步骤 4: 填写信息（直接复制粘贴）
─────────────────────

【名称】
qqbot

【版本】
1.0.0

【描述】（复制全部）
QQ 官方机器人配置指南，包含完整部署流程和常见问题解决方案

一键配置 QQ 官方机器人，支持私聊、群聊、频道消息。

功能特点:
✅ WebSocket 实时连接
✅ 支持私聊、群聊、频道消息
✅ 内置 AI 处理器接口
✅ 完整的故障排除指南
✅ 自动 IP 白名单监控脚本

安装命令: openclaw skill install qqbot

【作者】
小皮

【许可证】
MIT

【标签】（逐个添加）
qq, bot, im, 机器人, qq-bot

【分类】
IM / 通讯

步骤 5: 提交
─────────────────────
检查所有信息 → 点击 "Submit" 或 "发布"

═══════════════════════════════════════════════════════════
✅ 发布后
═══════════════════════════════════════════════════════════

- 审核通常需要几分钟到几小时
- 审核通过后可在市场搜索 "qqbot" 找到
- 其他用户可运行: openclaw skill install qqbot

═══════════════════════════════════════════════════════════
EOF

echo ""
echo "📋 所有信息已准备好，复制粘贴即可！"
echo ""
echo "是否现在打开浏览器？(y/n)"
read -r response

if [ "$response" = "y" ] || [ "$response" = "Y" ]; then
    open https://clawhub.com
    echo "🌐 已打开 ClawHub"
fi
