#!/bin/bash
# ClawHub 发布助手 - 步骤指南

cat << 'EOF'
═══════════════════════════════════════════════════════════
🚀 QQ Bot Skill 发布助手
═══════════════════════════════════════════════════════════

由于当前环境限制，请通过 Web 界面手动发布：

步骤 1: 访问 ClawHub
─────────────────────
打开浏览器访问: https://clawhub.com

步骤 2: 登录账号
─────────────────────
使用你已登录的账号

步骤 3: 发布 Skill
─────────────────────
1. 点击顶部导航栏的 "Publish" 或 "发布 Skill"
2. 点击 "Upload" 或 "上传文件"
3. 选择文件: ~/Desktop/qqbot-v1.0.0.zip

步骤 4: 填写信息
─────────────────────
名称 (Name):        qqbot
版本 (Version):     1.0.0
描述 (Description): QQ 官方机器人配置指南，包含完整部署流程和常见问题解决方案

作者 (Author):      小皮
许可证 (License):   MIT

标签 (Tags):
  - qq
  - bot
  - im
  - 机器人
  - qq-bot

分类 (Category):    IM / 通讯

步骤 5: 提交审核
─────────────────────
点击 "Submit" 或 "提交审核"

═══════════════════════════════════════════════════════════
📋 发布信息预览
═══════════════════════════════════════════════════════════

文件名:     qqbot-v1.0.0.zip
位置:       ~/Desktop/qqbot-v1.0.0.zip
大小:       14K
文件数:     11

元数据:
EOF

cat ~/Desktop/qqbot/_meta.json

cat << 'EOF'

═══════════════════════════════════════════════════════════
📄 发布说明 (复制到 Description)
═══════════════════════════════════════════════════════════

标题: QQ 官方机器人 (QQ Bot)

简介: 
一键配置 QQ 官方机器人，支持私聊、群聊、频道消息。包含完整部
署文档、IP 白名单管理、常见问题解决方案。

功能特点:
✅ WebSocket 实时连接
✅ 支持私聊、群聊、频道消息
✅ 内置 AI 处理器接口
✅ 完整的故障排除指南
✅ 自动 IP 白名单监控脚本

使用场景:
- QQ 机器人开发
- OpenClaw 接入 QQ
- 自动化客服
- 社群管理

安装命令:
openclaw skill install qqbot

═══════════════════════════════════════════════════════════
✅ 准备就绪！请在浏览器中完成发布
═══════════════════════════════════════════════════════════

文件位置: ~/Desktop/qqbot-v1.0.0.zip

EOF

echo ""
echo "是否需要用浏览器打开 ClawHub? (复制链接到浏览器):"
echo "https://clawhub.com"
