# QQ 官方机器人配置指南

QQ 官方机器人 (QQ Bot) 完整配置教程，包含从创建机器人到接入 OpenClaw AI 的全过程，以及常见问题排查。

## 前置条件

- QQ 号（建议使用小号）
- 可访问公网 IP（家庭宽带需处理动态 IP）
- 服务器或本地机器
- OpenClaw 已安装

---

## 配置步骤

### 步骤 1: 创建 QQ 机器人

1. 访问 [QQ 机器人平台](https://bot.q.qq.com/wiki)
2. 点击「登录」，使用 QQ 扫码登录
3. 进入「开发者注册」页面，完成实名认证
4. 点击「创建机器人」，填写基本信息
5. 记录关键信息：
   - AppID (如: 102842119)
   - AppSecret (点击显示，只显示一次，务必保存！)

⚠️ **重要**: AppSecret 只显示一次，立即保存！

---

### 步骤 2: 配置 IP 白名单

**家庭宽带需要公网 IP，并配置到 QQ 开放平台。**

#### 获取公网 IP

```bash
curl https://api.ipify.org
```

#### 配置白名单

1. 进入 [QQ 机器人控制台](https://bot.q.qq.com/console/)
2. 选择你的机器人
3. 点击「开发设置」→「IP 白名单」
4. 添加获取到的公网 IP
5. 保存

⚠️ **注意**: 家庭宽带 IP 会定期变化，需要及时更新白名单，否则会出现错误 11298。

---

### 步骤 3: 配置 OpenClaw

在 `openclaw.json` 中添加 QQ 频道配置：

```json
{
  "channels": {
    "qq": {
      "enabled": true,
      "appId": "你的AppID",
      "appSecret": "你的AppSecret"
    }
  }
}
```

---

### 步骤 4: 部署 QQ Bot 程序

复制 `qq_official_bot.py` 到工作区：

```bash
cp qq_official_bot.py ~/.openclaw/workspace/
```

编辑配置文件：

```python
APP_ID = "你的AppID"
APP_SECRET = "你的AppSecret"
```

---

### 步骤 5: 启动机器人

```bash
# 启动 QQ Bot
~/.openclaw/workspace/qq_bot_daemon.sh start

# 查看状态
~/.openclaw/workspace/qq_bot_daemon.sh status

# 查看日志
tail -f ~/.openclaw/workspace/qq_bot.log
```

---

## 常见问题与解决方案

### 问题 1: 错误 11298 - IP 不在白名单

**现象**: 
```
获取 Token 失败: 11298
接口访问源IP不在白名单
```

**原因**: 
- 当前 IP 未添加到 QQ 开放平台白名单
- 或 IP 已变更

**解决方案**:
1. 获取当前公网 IP: `curl https://api.ipify.org`
2. 登录 [QQ 机器人控制台](https://bot.q.qq.com/console/)
3. 更新 IP 白名单
4. 重启 QQ Bot

**长期方案**:
- 使用云服务器（固定 IP）
- 或使用内网穿透服务

---

### 问题 2: 无法收到消息

**现象**: 
- Bot 已连接 WebSocket
- 心跳正常
- 但没有收到任何消息事件

**原因 1: Intents 权限未开启**

**解决方案**:
1. 登录 [QQ 机器人控制台](https://bot.q.qq.com/console/)
2. 进入「开发设置」→「权限设置」
3. 开启以下 Intents：
   - ✅ GUILDS (基础权限)
   - ✅ GROUP_AND_C2C_EVENT (私聊和群消息)
   - ✅ AT_MESSAGES (@消息)

**原因 2: 事件订阅方式错误**

**解决方案**:
确认选择了「使用长连接接收事件」(WebSocket 模式)，而不是 HTTP 回调。

**原因 3: 机器人未添加好友/进群**

**解决方案**:
- 私聊：添加机器人为 QQ 好友
- 群聊：将机器人邀请到群里

---

### 问题 3: ModuleNotFoundError

**现象**:
```
ModuleNotFoundError: No module named 'requests'
ModuleNotFoundError: No module named 'aiohttp'
```

**解决方案**:
```bash
pip3 install requests aiohttp websockets --user
```

---

### 问题 4: 鉴权成功但无法接收消息

**现象**:
```
✅ 鉴权成功!
Session ID: xxx
💓 心跳确认
```
但没有收到 `C2C_MESSAGE_CREATE` 或 `AT_MESSAGE_CREATE` 事件。

**原因**: Intents 值配置错误

**解决方案**:
使用正确的 Intents 组合：
```python
INTENTS = (1 << 0) | (1 << 25) | (1 << 30)
# GUILDS | GROUP_AND_C2C_EVENT | AT_MESSAGES
```

---

### 问题 5: AI 回复超时

**现象**:
```
⏳ 等待 OpenClaw AI 回复...
抱歉，AI 响应超时
```

**原因**: AI 处理器未运行或响应太慢

**解决方案**:
1. 确保 AI 处理器脚本在运行
2. 检查请求文件是否生成
3. 手动创建回复文件测试

---

## 文件结构

```
~/.openclaw/workspace/
├── qq_official_bot.py      # QQ Bot 主程序
├── qq_bot_daemon.sh        # 启动管理脚本
├── qq_bot.log             # 运行日志
├── qq_queue/              # 消息队列目录
│   ├── ai_request_*.json  # AI 请求
│   └── ai_response_*.txt  # AI 回复
└── qq_ai_handler.sh       # AI 处理器
```

---

## 管理命令

```bash
# 启动
~/.openclaw/workspace/qq_bot_daemon.sh start

# 停止
~/.openclaw/workspace/qq_bot_daemon.sh stop

# 重启
~/.openclaw/workspace/qq_bot_daemon.sh restart

# 查看状态
~/.openclaw/workspace/qq_bot_daemon.sh status

# 查看日志
tail -f ~/.openclaw/workspace/qq_bot.log
```

---

## 调试技巧

### 1. 检查 WebSocket 连接

```bash
tail -f ~/.openclaw/workspace/qq_bot.log | grep -E "连接|心跳|收到"
```

### 2. 检查消息事件

```bash
tail -f ~/.openclaw/workspace/qq_bot.log | grep "收到事件"
```

### 3. 手动测试 AI 回复

```bash
# 创建测试请求
echo '{"request_id":"test","message":"你好"}' > ~/.openclaw/workspace/qq_queue/ai_request_test.json

# 创建回复
echo "你好！我是小皮" > ~/.openclaw/workspace/qq_queue/ai_response_test.txt
```

---

## 参考资料

- [QQ 机器人平台文档](https://bot.q.qq.com/wiki)
- [QQ Bot API 文档](https://bot.q.qq.com/wiki/develop/api/)
- [Intents 说明](https://bot.q.qq.com/wiki/develop/api/gateway/intents.html)

---

**维护者**: 小皮 🦊  
**版本**: 1.0.0  
**更新时间**: 2026-02-23
