---
name: qq-mail-monitor
description: "QQ 邮箱自动监控技能，支持定时检查新邮件、TTS 语音播报提醒、邮件收发功能。适用于邮件通知、验证码提取、自动回复等场景。"
---

# QQ 邮箱监控技能

自动监控 QQ 邮箱新邮件，支持定时检查、语音播报、邮件收发等功能。

## 📋 功能特性

| 功能 | 说明 |
|------|------|
| 🔍 新邮件检查 | 定期检查收件箱，检测新邮件 |
| 🔔 实时提醒 | 发现新邮件时自动通知用户 |
| 🔊 TTS 播报 | 语音播报新邮件主题和发件人 |
| 📤 发送邮件 | 支持纯文本和 HTML 格式邮件 |
| 📎 附件支持 | 可发送带附件的邮件 |
| ⏰ 定时任务 | 可配置检查频率（默认 5 分钟） |

## 🛠️ 工具脚本

### 1. qq_mail_auto_check.py - 自动监控脚本

**用途：** 定时任务专用，检查新邮件并输出通知

**使用方法：**
```bash
python3 scripts/qq_mail_auto_check.py
```

**输出示例：**
```
[2026-03-02 10:40:48] 🔍 检查 QQ 邮箱新邮件...
[!] 📬 发现新邮件！
    主题：GitHub 安全通知
    发件人：noreply@github.com
    时间：03-02 10:35

🔊 TTS: 新邮件提醒。主题：GitHub 安全通知，来自：noreply@github.com
[RESULT] NEW_EMAIL|GitHub 安全通知|noreply@github.com|03-02 10:35
```

### 2. qq_mail_check.py - 手动查看邮件

**用途：** 查看收件箱邮件列表

**使用方法：**
```bash
python3 scripts/qq_mail_check.py
```

**输出示例：**
```
============================================================
QQ 邮箱检查：289688826@qq.com
============================================================

✅ 登录成功
📊 收件箱共有 90 封邮件

最近 10 封邮件:

1. Mon, 02 Mar 2026 10:32:39 +080
   从：QQ 邮箱团队 <10000@qq.com>
   主题：更安全、更高效、更强大，尽在 QQ 邮箱 APP
...
```

### 3. qq_mail_send.py - 发送邮件

**用途：** 发送测试邮件或自定义邮件

**使用方法：**
```bash
python3 scripts/qq_mail_send.py
```

**输出示例：**
```
📤 正在发送邮件...
   发件人：289688826@qq.com
   收件人：289688826@qq.com
   主题：🧪 QQ 邮箱 API 测试邮件

✅ 发送成功！
```

## ⚙️ 配置说明

### 获取授权码

1. 登录 QQ 邮箱网页版 (mail.qq.com)
2. 点击 **设置** → **账户**
3. 找到 **POP3/IMAP/SMTP 服务**
4. 开启 **IMAP/SMTP 服务**
5. 点击 **生成授权码**（需要短信验证）

### 配置邮箱信息

编辑脚本中的配置区域：

```python
# 配置
EMAIL = "你的 QQ 号@qq.com"
AUTH_CODE = "你的授权码"  # 16 位字符串，不是登录密码
IMAP_SERVER = "imap.qq.com"
IMAP_PORT = 993
SMTP_SERVER = "smtp.qq.com"
SMTP_PORT = 465
```

## ⏰ 定时任务配置

### 查看当前任务
```bash
cron list
```

### 修改检查频率
告诉助手："改成每 X 分钟检查邮件"

### 暂停/恢复监控
- 暂停："暂停邮件监控"
- 恢复："恢复邮件监控"

### 立即检查
告诉助手："现在检查邮件"

## 📁 文件结构

```
qq-mail-monitor/
├── SKILL.md                      # 技能说明文档
├── README.md                     # 使用文档
├── _meta.json                    # 元数据
├── .clawhub/
│   └── origin.json               # ClawHub 注册信息
└── scripts/
    ├── qq_mail_auto_check.py     # 自动监控脚本 ⭐
    ├── qq_mail_check.py          # 手动查看脚本
    ├── qq_mail_send.py           # 发送邮件脚本
    └── qq_mail_monitor.py        # 监控脚本（备用）
```

## 🔔 使用场景

| 场景 | 说明 |
|------|------|
| 📧 邮件通知 | 重要邮件实时提醒 |
| 🔐 验证码提取 | 自动读取验证码并播报 |
| 📊 日报汇总 | 定时汇总重要邮件 |
| 🤖 自动回复 | 根据规则自动回复邮件 |
| 📎 附件处理 | 自动下载并保存附件 |

## ⚠️ 注意事项

1. **授权码安全**：授权码不是登录密码，不要泄露
2. **检查频率**：建议不低于 5 分钟，避免触发 QQ 邮箱风控
3. **网络环境**：确保网络可访问 imap.qq.com 和 smtp.qq.com
4. **状态文件**：`.mail_state.json` 记录已检查的邮件，不要删除

## 🆘 常见问题

**Q: 连接失败怎么办？**
A: 检查授权码是否正确，确保已开启 IMAP/SMTP 服务

**Q: 收不到提醒？**
A: 检查 cron 任务是否启用，查看任务日志

**Q: 如何修改提醒方式？**
A: 告诉助手"修改邮件提醒方式"，可调整为消息/TTS/两者

---

**版本：** 1.0.0  
**作者：** OpenClaw  
**更新时间：** 2026-03-02
