# Qlik Cloud Skill for OpenClaw

Complete Qlik Cloud integration with 31 tools for the OpenClaw/Clawd agent platform.

## Features

- **Core**: Health checks, tenant info, search, licensing
- **Apps**: List, create, delete, get details, inspect fields
- **Reloads**: Trigger, monitor, cancel, view history
- **Insight Advisor**: Natural language queries against your data ⭐
- **Automations**: List, run, monitor automation workflows
- **AutoML**: Experiments and deployments
- **Qlik Answers**: AI assistants and Q&A
- **Alerts**: Data alerts management
- **Users & Spaces**: User management, space organization
- **Data**: Dataset info, lineage tracking

## Installation

Copy the `qlik-cloud` folder to your OpenClaw skills directory, or install via ClawdHub (coming soon).

## Setup

1. Get a Qlik Cloud API key:
   - Go to Qlik Cloud → Profile icon → Profile settings → API keys
   - Generate a new key

2. Add to your `TOOLS.md`:
```markdown
### Qlik Cloud
- Tenant URL: https://your-tenant.region.qlikcloud.com
- API Key: your-api-key-here
```

## Usage

All scripts follow the same pattern:

```bash
QLIK_TENANT="https://your-tenant.qlikcloud.com" \
QLIK_API_KEY="your-key" \
bash scripts/<script>.sh [arguments]
```

### Examples

```bash
# Health check
bash scripts/qlik-health.sh

# Search for apps
bash scripts/qlik-search.sh "sales"

# Natural language query
bash scripts/qlik-insight.sh "show revenue by region"

# Trigger app reload
bash scripts/qlik-reload.sh "app-id-here"
```

## Scripts Reference

See [SKILL.md](SKILL.md) for complete documentation.

## Requirements

- bash
- curl
- Python 3 (standard library only)

## License

MIT

## Author

Built by [undsoul](https://github.com/undsoul) with [OpenClaw](https://github.com/moltbot/moltbot).
