# 清博开放平台文章搜索 Skill

## 功能说明

通过清博开放平台的关键词检索文章接口，帮助用户搜索全网文章舆情信息。用户可以根据关键词、时间范围、媒体类型等条件进行检索，并获取文章标题、URL、发布时间等信息。

## 配置说明

### 1. 注册开发者账号
- 访问清博开放平台官网注册账号
- 登录后创建应用，获取 `app_key` 和 `app_secret`

### 2. 配置文件
在 `config.json` 文件中配置以下参数：
```json
{
  "app_key": "您的app_key",
  "app_secret": "您的app_secret"
}
```

## 使用方法

### 基本搜索
输入包含关键词的查询语句，如：
- "搜索关于人工智能的文章"
- "查找2024年1月的科技新闻"

### 高级搜索
可以指定时间范围、平台类型等条件，如：
- "搜索2024年1-3月微信平台关于人工智能的文章"
- "查找最近一周微博上的经济相关新闻"

### 统计分析
可以请求统计信息，如：
- "统计2024年关于人工智能的文章数量"
- "分析2024年1月科技新闻的媒体分布"

## 接口说明

### 关键词检索文章接口
- API地址：`/pubsent/full-search/index`
- 请求方式：GET
- 主要参数：
  - keywords_include：关键词（必填）
  - posttime_start：开始时间（可选）
  - posttime_end：结束时间（可选）
  - media_type：媒体类型（可选）
  - news_emotion：情感属性（可选）
  - refer_province：省份（可选）
  - order：排序方式（可选）
  - sort：排序字段（可选）
  - page：页码（可选）
  - limit：每页数量（可选）

### 响应示例
```json
{
  "success": true,
  "data": {
    "newsList": [
      {
        "news_title": "文章标题",
        "news_url": "文章URL",
        "news_posttime": "发布时间",
        "media_type": "媒体类型",
        "media_name": "媒体名称"
      }
    ],
    "numFound": 100
  }
}
```

## 技术实现

### 关键词提取
使用自然语言处理技术分析用户输入语句，提取关键词、时间范围、平台类型等参数。

### 接口调用
- 签名生成：按照清博API鉴权机制生成请求签名
- 请求发送：发送HTTP请求到清博API接口
- 响应处理：解析API返回的JSON数据

### 结果呈现
根据用户输入的实际需求，返回文章标题、URL、时间等信息，或统计文章总量进行分析。

## 注意事项

- 接口调用会消耗清博平台点数，请合理使用
- 每个接口调用有参数限制，如关键词数量、时间范围等
- 接口返回数据可能包含重复或相似文章（通过sim_hash字段识别）
