# 清博开放平台文章搜索 Skill

## 概述

这个skill提供了通过清博开放平台API搜索全网文章舆情信息的功能。用户可以根据关键词、时间范围、媒体类型等条件进行检索，并获取文章标题、URL、发布时间等信息。

## 安装和配置

### 1. 安装依赖
```bash
cd skills/qingbo_search
npm install
```

### 2. 配置API凭证
编辑 `config.json` 文件，添加您的清博开放平台API凭证：
```json
{
  "app_key": "您的app_key",
  "app_secret": "您的app_secret"
}
```

## 使用方法

### 基本搜索
输入包含关键词的查询语句，如：
- "搜索关于人工智能的文章"
- "查找2024年1月的科技新闻"

### 高级搜索
可以指定时间范围、平台类型等条件，如：
- "搜索2024年1-3月微信平台关于人工智能的文章"
- "查找最近一周微博上的经济相关新闻"

### 统计分析
可以请求统计信息，如：
- "统计2024年关于人工智能的文章数量"
- "分析2024年1月科技新闻的媒体分布"

## API说明

### 主要功能
- **关键词检索文章**：根据关键词、时间范围、媒体类型等条件检索文章
- **情感分析**：支持按文章情感属性（正面、负面、中性、敏感）筛选
- **媒体类型**：支持微信、微博、新闻网站、新闻客户端、报刊、论坛、今日头条等平台

### 调用限制
- 每个接口调用消耗平台点数
- 关键词数量、时间范围等参数有一定限制
- 接口返回数据可能包含重复或相似文章

## 技术实现

### 文件结构
- `SKILL.md`：skill功能说明和配置文档
- `index.js`：主要功能实现
- `config.json`：API凭证配置
- `package.json`：项目依赖配置
- `README.md`：项目说明文档

### 核心功能
- 自然语言分析：提取用户输入中的关键词、时间、平台等参数
- API调用：与清博开放平台API进行交互
- 结果处理：格式化API返回数据，提供用户友好的展示

## 故障排除

### 常见问题

1. **"请先在config.json中配置app_key和app_secret"**：
   - 确保您已在清博开放平台注册开发者账号并创建了应用
   - 从应用详情页面获取API凭证并配置到config.json文件中

2. **API调用失败**：
   - 检查网络连接是否正常
   - 确认API凭证是否正确
   - 检查应用是否有足够的点数

3. **未找到相关文章**：
   - 调整关键词或时间范围
   - 尝试使用更具体的搜索条件

## 更新记录

### 版本 1.0.0 (2025-01-08)
- 初始版本
- 支持基本搜索功能
- 支持高级搜索条件
- 支持统计分析功能
