# QA 最佳实践

## 核心原则

### 1. 清晰的角色分工
- 开发不测试，测试不开发
- 独立验收权
- 互相制衡

### 2. 快速反馈循环
- 发现问题 → 报告 → 修复 → 验证
- 完整循环 < 1 小时
- 问题不累积

## 实践建议

### 早期评审
- 项目启动时就评审需求
- 评审时间 < 开发时间 10%
- 避免后期大规模返工

### 代码审查
- 每提交必审查
- 审查时间 < 30 分钟
- 发现问题立即报告

### 测试执行
- 测试与开发同步
- 自动化测试优先
- 覆盖率 > 80%

### 文档同步
- 代码和注释同时完成
- 文档和代码同步更新
- 避免事后补充

## 常见问题

### Q: 如何平衡速度和质量？
A: 早期投入评审时间，后期节省返工时间

### Q: 如何处理紧急需求？
A: 快速评审，明确范围，优先 P0

### Q: 如何确保测试覆盖？
A: 自动化测试 + 定期检查

---

*最后更新：2026-03-04*
