---
name: publisher
description: Make your skills easy to understand and impossible to ignore
---

# publisher

**Professional documentation and publishing for Clawdbot skills**

Generate adoption-optimized READMEs and publish to GitHub + ClawdHub with one command.

---

## ⚠️ Requirements

- bash
- `jq` (for JSON parsing)
- `gh` CLI (GitHub operations)
- `clawdhub` CLI (publishing)
- git

---

## 📋 What It Does

Automates the complete publishing workflow:

### Documentation Generation
1. Reads your SKILL.md to understand what the skill does
2. Generates 3 one-liner options using proven patterns
3. Creates a README following GitHub best practices:
   - Problem/solution upfront
   - Inverted pyramid structure
   - Emoji headers for scannability
   - Bold outcomes
   - Under 15% text highlighting
4. Updates SKILL.md frontmatter with chosen description

### Publishing
5. Creates GitHub repository (if doesn't exist)
6. Pushes code to GitHub
7. Publishes to ClawdHub with auto-detected version

---

## 🚀 Installation

```bash
clawdhub install skill-publisher
```

---

## 💡 Usage

```bash
cd ~/clawd/skills/your-skill
skill-publisher
```

The script will:
1. Show 3 one-liner options (choose or write your own)
2. Generate README preview
3. Ask for approval
4. Publish to GitHub + ClawdHub

---

## 🎯 One-Liner Generation Patterns

The tool generates options using three proven patterns:

### Pattern A: Continuous Benefit
```
Keep [thing] [desired state] [timeframe]
```
Example: "Keep your Claude access token fresh 24/7"

### Pattern B: Elimination
```
[Do thing] without [pain point]
```
Example: "Build cross-device tools without hardcoding paths"

### Pattern C: Automation
```
Automatically [action] [thing] [when]
```
Example: "Automatically refresh tokens before they expire"

---

## 📚 README Structure Generated

Follows the framework from GitHub's documentation best practices:

### Essential Sections (above the fold)
- Title + subtitle
- **The problem:** (1 sentence)
- **This tool:** (1 sentence)
- 📋 Requirements
- ⚡ What It Does (outcome first, then features)
- 🚀 Installation
- 🔧 How It Works (result first, then process)

### Optional Sections (collapsible)
- Configuration options
- Troubleshooting
- For Developers
- Implementation details

---

## 🔧 How It Works

### Phase 1: Analysis
- Reads SKILL.md frontmatter (if exists)
- Extracts key information: name, description, requirements
- Parses scripts for dependencies

### Phase 2: One-Liner Generation
Analyzes your SKILL.md description and generates 3 options:
- Pattern A: Continuous benefit format
- Pattern B: Pain point elimination format
- Pattern C: Automation format

Shows you all 3, lets you choose or write custom.

### Phase 3: README Generation
Uses the template from `~/clawd/templates/README-template.md`:
- Fills in title, problem, solution
- Extracts requirements from SKILL.md
- Generates "What It Does" from description
- Creates installation steps
- Builds "How It Works" with examples

### Phase 4: Publishing
1. Checks for `gh` CLI (guides setup if missing)
2. Reads VERSION file for version number
3. Creates GitHub repo (using `gh repo create`)
4. Commits and pushes all files
5. Publishes to ClawdHub with `clawdhub publish`

---

## 📁 File Structure Expected

```
your-skill/
├── SKILL.md           # Required: skill description
├── VERSION            # Required: version number (e.g., "1.0.0")
├── scripts/           # Optional: your scripts
│   └── main.sh
├── README.md          # Generated by this tool
└── .gitignore         # Optional
```

---

## ⚙️ Configuration

No configuration needed. The tool auto-detects everything from:
- `SKILL.md` (name, description, requirements)
- `VERSION` (version number)
- `scripts/` (code examples, dependencies)

---

## 🐛 Troubleshooting

### "gh: command not found"

Install GitHub CLI:
```bash
brew install gh
gh auth login
```

### "SKILL.md not found"

Create a minimal SKILL.md:
```markdown
---
name: your-skill
description: Brief description of what it does
---

# your-skill

More details about your skill here.
```

### "VERSION file not found"

Create a VERSION file:
```bash
echo "1.0.0" > VERSION
```

---

## 📖 References

- GitHub documentation best practices: https://docs.github.com/en/contributing/writing-for-github-docs/best-practices-for-github-docs
- README template: `~/clawd/templates/README-template.md`
- One-liner formulas: See "One-Liner Generation Patterns" section above

---

## License

MIT
