# Stress & Resilience Psychology

Understanding stress, building resilience, and preventing burnout.

## Table of Contents

1. [Stress Fundamentals](#stress-fundamentals)
2. [Coping Mechanisms](#coping-mechanisms)
3. [Resilience Building](#resilience-building)
4. [Burnout Prevention](#burnout-prevention)
5. [Recovery Strategies](#recovery-strategies)

---

## Stress Fundamentals

### Stress Response (Fight-Flight-Freeze)

| Phase | Physiological | Psychological |
|-------|---------------|---------------|
| **Alarm** | Cortisol, adrenaline release | Heightened alertness |
| **Resistance** | Continued stress hormones | Coping attempts |
| **Exhaustion** | Resource depletion | Fatigue, breakdown |

### Types of Stress

| Type | Description | Effect |
|------|-------------|--------|
| **Eustress** | Positive, motivating | Performance enhancement |
| **Distress** | Negative, overwhelming | Performance impairment |
| **Acute** | Short-term | Can be beneficial |
| **Chronic** | Long-term | Harmful |

### Stress Appraisal (Lazarus)

| Appraisal | Question | Result |
|-----------|----------|--------|
| **Primary** | Is this a threat? | Harm, threat, or challenge |
| **Secondary** | Can I cope? | Resources available |

**Key insight**: Perception determines stress response.

### Common Stressors

| Category | Examples |
|----------|----------|
| **Work** | Deadlines, workload, conflict, uncertainty |
| **Life** | Health, relationships, finances, change |
| **Environmental** | Noise, crowding, commute |
| **Psychological** | Perfectionism, rumination, fear |

---

## Coping Mechanisms

### Coping Styles

| Style | Description | When Effective |
|-------|-------------|----------------|
| **Problem-focused** | Address the stressor | Controllable situations |
| **Emotion-focused** | Manage emotional response | Uncontrollable situations |
| **Avoidant** | Disengage from stressor | Short-term only |
| **Meaning-focused** | Find purpose in adversity | Significant challenges |

### Adaptive Coping Strategies

| Strategy | Description | Application |
|----------|-------------|-------------|
| **Reappraisal** | Change interpretation | "Challenge not threat" |
| **Problem-solving** | Address cause | Break into steps |
| **Social support** | Connect with others | Talk, ask for help |
| **Relaxation** | Activate parasympathetic | Breathing, meditation |
| **Exercise** | Physical activity | Regular movement |
| **Acceptance** | Allow without judgment | What can't be changed |

### Maladaptive Coping (Avoid)

| Strategy | Why Harmful |
|----------|-------------|
| Substance use | Temporary, creates problems |
| Denial | Problem persists, grows |
| Rumination | Amplifies negative emotions |
| Isolation | Removes support |
| Aggression | Damages relationships |
| Over-eating/under-eating | Health consequences |

### Stress Inoculation

Gradual exposure builds tolerance:

| Phase | Activity |
|-------|----------|
| **Education** | Understand stress response |
| **Skill acquisition** | Learn coping techniques |
| **Practice** | Apply in low-stakes situations |
| **Generalization** | Transfer to real challenges |

---

## Resilience Building

### Resilience Components

| Component | Description | Development |
|-----------|-------------|-------------|
| **Self-efficacy** | Belief in ability | Past successes, mastery |
| **Optimism** | Positive outlook | Reframing, evidence |
| **Flexibility** | Adapt to change | Varied experiences |
| **Social connection** | Support network | Nurture relationships |
| **Purpose** | Meaning and goals | Values clarification |
| **Self-care** | Physical foundation | Sleep, exercise, nutrition |

### Protective Factors

| Factor | Effect |
|--------|--------|
| **Strong relationships** | Buffer against stress |
| **Problem-solving skills** | Agency, control |
| **Self-regulation** | Emotional management |
| **Meaning/purpose** | Motivation, perspective |
| **Growth mindset** | View challenges as learning |
| **Physical health** | Resilience foundation |

### Post-Traumatic Growth

Positive change after adversity:

| Domain | Example |
|--------|---------|
| **Personal strength** | "I'm stronger than I thought" |
| **New possibilities** | New paths, opportunities |
| **Relationships** | Deeper connections |
| **Appreciation** | Gratitude for life |
| **Spiritual** | Existential insight |

### Building Resilience Practices

| Practice | Frequency | Benefit |
|----------|-----------|---------|
| Gratitude journaling | Daily | Positive focus |
| Mindfulness | Daily | Stress reduction, awareness |
| Exercise | 3-5x/week | Physical and mental health |
| Social connection | Regular | Support, belonging |
| Goal-setting | Weekly/monthly | Purpose, direction |
| Self-compassion | Ongoing | Reduce self-criticism |

---

## Burnout Prevention

### Burnout Dimensions (Maslach)

| Dimension | Signs | Antidote |
|-----------|-------|----------|
| **Exhaustion** | Fatigue, depleted | Rest, boundaries |
| **Cynicism** | Detachment, negativity | Meaning, connection |
| **Inefficacy** | Feel ineffective | Wins, recognition |

### Burnout Warning Signs

| Early Signs | Advanced Signs |
|-------------|----------------|
| Tired often | Constant exhaustion |
| Procrastination | Can't get started |
| Irritability | Cynicism, detachment |
| Reduced productivity | Performance collapse |
| Sleep issues | Health problems |
| Questioning purpose | Complete disengagement |

### Prevention Strategies

| Strategy | Implementation |
|----------|----------------|
| **Boundaries** | Clear work/life separation |
| **Recovery** | Daily, weekly, annual |
| **Autonomy** | Control over work |
| **Community** | Workplace relationships |
| **Fairness** | Equitable treatment |
| **Values alignment** | Meaningful work |

### Job Demands-Resources Model

| Balance | Outcome |
|---------|---------|
| High demands, high resources | Engaged, challenged |
| High demands, low resources | Burnout risk |
| Low demands, high resources | Bored but comfortable |
| Low demands, low resources | Disengaged |

### Recovery Activities

| Type | Examples | Benefit |
|------|----------|---------|
| **Psychological detachment** | No work thoughts | Mental rest |
| **Relaxation** | Low-effort activities | Physical rest |
| **Mastery** | Learning, challenges | Self-efficacy |
| **Control** | Choose activities | Autonomy |

---

## Recovery Strategies

### Immediate Stress Relief

| Technique | Time | Effect |
|-----------|------|--------|
| **Box breathing** | 1-5 min | Activate parasympathetic |
| **Progressive muscle relaxation** | 10-15 min | Physical tension release |
| **Grounding (5-4-3-2-1)** | 2-5 min | Present-moment focus |
| **Cold water face** | 30 sec | Dive reflex, calm |
| **Walk in nature** | 20+ min | Cortisol reduction |

### Daily Recovery

| Practice | Duration | Benefit |
|----------|----------|---------|
| Sleep | 7-9 hours | Full restoration |
| Exercise | 30+ min | Stress hormones, mood |
| Social time | Variable | Connection, support |
| Hobby/play | Variable | Joy, engagement |
| Mindfulness | 10-20 min | Awareness, calm |

### Weekly Recovery

| Practice | Benefit |
|----------|---------|
| Full day off | Complete detachment |
| Nature time | Restoration |
| Social activities | Connection |
| Physical activity | Accumulated benefit |
| Reflection | Processing, meaning |

### Return from Burnout

| Phase | Focus | Timeline |
|-------|-------|----------|
| **Rest** | Complete recovery | Weeks |
| **Rebuild** | Gradual re-engagement | Weeks-months |
| **Restructure** | Change contributing factors | Ongoing |
| **Return** | Sustainable engagement | Gradual |

---

## Organizational Implications

### Creating Low-Stress Environments

| Factor | Implementation |
|--------|----------------|
| **Workload** | Realistic expectations |
| **Control** | Autonomy, input on decisions |
| **Recognition** | Acknowledge contributions |
| **Community** | Foster connections |
| **Fairness** | Transparent, equitable policies |
| **Values** | Meaningful work |

### Manager Actions

| Action | Effect |
|--------|--------|
| Model boundaries | Permission for self-care |
| Check in regularly | Early problem detection |
| Provide resources | Coping support |
| Reduce unnecessary stress | Remove obstacles |
| Recognize effort | Combat inefficacy |
| Foster connection | Build community |

### Stress-Aware Design

| Principle | Application |
|-----------|-------------|
| **Reduce friction** | Eliminate unnecessary complexity |
| **Clear expectations** | Reduce ambiguity stress |
| **Progress visibility** | Combat uncertainty |
| **Support access** | Easy help-seeking |
| **Failure tolerance** | Safe experimentation |
| **Recovery time** | Built-in breaks |
