# Social Psychology

Understanding how people think about, influence, and relate to one another.

## Table of Contents

1. [Social Influence](#social-influence)
2. [Group Dynamics](#group-dynamics)
3. [Social Perception](#social-perception)
4. [Attitudes & Persuasion](#attitudes--persuasion)
5. [Prosocial Behavior](#prosocial-behavior)

---

## Social Influence

### Types of Social Influence

| Type | Mechanism | Duration | Example |
|------|-----------|----------|---------|
| **Compliance** | External pressure | Temporary | Following a request |
| **Identification** | Relationship-based | While relationship lasts | Imitating admired figure |
| **Internalization** | Value adoption | Permanent | Genuine belief change |

### Conformity (Asch)

People conform to group opinions even when clearly wrong:
- 75% conformed at least once
- Conformity increases with group size (up to 4-5)
- One ally dramatically reduces conformity

**Factors increasing conformity:**
- Unanimous group
- High status members
- Public response
- Ambiguous situation
- Collectivist culture

### Obedience (Milgram)

65% administered maximum "shock" when authority figure insisted.

**Factors increasing obedience:**
- Legitimate authority
- Gradual escalation
- Physical distance from victim
- Presence of authority
- No role models for defiance

**Application**: Design systems that make unethical behavior difficult, not just discouraged.

### Social Proof Depth

| Type | Strength | Application |
|------|----------|-------------|
| **Expert** | High | Industry leaders, specialists |
| **Celebrity** | Medium-High | Aspirational, attention-getting |
| **User** | High | Relatable, trustworthy |
| **Wisdom of crowds** | Medium | Numbers, statistics |
| **Peers** | Highest | Similar others, local |

**Effective social proof requires:**
1. Similarity to target audience
2. Specificity (names, photos, details)
3. Recency
4. Relevance to decision

### Reciprocity

People feel obligated to return favors:

| Tactic | Description | Ethical Use |
|--------|-------------|-------------|
| **Give first** | Provide value before asking | Free content, samples |
| **Personalize** | Tailored gifts more powerful | Customized recommendations |
| **Unexpected** | Surprise increases impact | Bonus features |
| **Meaningful** | Significant value | Genuine helpfulness |

**Manipulation warning**: Manufactured obligation is manipulative.

---

## Group Dynamics

### Group Formation Stages (Tuckman)

| Stage | Characteristics | Leadership Need |
|-------|-----------------|-----------------|
| **Forming** | Polite, uncertain | Direction, structure |
| **Storming** | Conflict, competition | Facilitation, norms |
| **Norming** | Cohesion, agreement | Support, delegation |
| **Performing** | High productivity | Empowerment |
| **Adjourning** | Completion, separation | Recognition, closure |

### Groupthink (Janis)

Desire for harmony overrides realistic appraisal:

**Symptoms:**
- Illusion of invulnerability
- Collective rationalization
- Belief in group's morality
- Stereotyping out-groups
- Pressure on dissenters
- Self-censorship
- Illusion of unanimity
- Self-appointed mindguards

**Prevention:**
- Encourage dissent
- Assign devil's advocate
- Bring in outside experts
- Anonymous input mechanisms
- Leader speaks last

### Social Loafing

Individuals exert less effort in groups:

| Cause | Solution |
|-------|----------|
| Diffusion of responsibility | Individual accountability |
| Evaluation apprehension | Personal recognition |
| Dispensability perception | Unique contributions |
| Sucker effect | Fairness visibility |

### In-Group/Out-Group

| Phenomenon | Description | Marketing Application |
|------------|-------------|----------------------|
| **In-group favoritism** | Prefer own group | Community building |
| **Out-group homogeneity** | "They're all alike" | Avoid stereotyping |
| **Social identity** | Self-concept from groups | Tribe/identity marketing |
| **Minimal group paradigm** | Trivial distinctions create bias | Membership creates loyalty |

**Creating in-group:**
- Shared identity markers
- Common enemy/competitor
- Exclusive membership
- Rituals and language
- Shared history/narrative

---

## Social Perception

### Attribution Theory

How people explain behavior:

| Attribution | Internal | External |
|-------------|----------|----------|
| **Stable** | Ability | Task difficulty |
| **Unstable** | Effort | Luck |

### Attribution Errors

| Error | Description | Implication |
|-------|-------------|-------------|
| **Fundamental attribution error** | Overweight personality, underweight situation | Judge others harshly |
| **Actor-observer bias** | Others' behavior = personality; own = situation | Self-serving explanations |
| **Self-serving bias** | Success = me; failure = circumstances | Protect self-esteem |

### First Impressions

- Form in milliseconds
- Extremely persistent (primacy effect)
- Confirmation bias maintains them
- Halo effect extends to other traits

**Key dimensions:**
1. Warmth (trustworthiness, friendliness)
2. Competence (capability, intelligence)

**For brands**: Lead with warmth, then demonstrate competence.

### Stereotypes & Schemas

Mental shortcuts for processing social information:

| Aspect | Description |
|--------|-------------|
| **Automatic activation** | Unconscious, fast |
| **Confirmation bias** | Notice confirming info |
| **Self-fulfilling prophecy** | Expectations create reality |
| **Illusory correlation** | See patterns that don't exist |

**Ethical marketing**: Avoid reinforcing harmful stereotypes.

---

## Attitudes & Persuasion

### Attitude Components (ABC)

| Component | Description | Change Strategy |
|-----------|-------------|-----------------|
| **Affective** | Feelings | Emotional appeals |
| **Behavioral** | Actions | Foot-in-the-door |
| **Cognitive** | Beliefs | Information, arguments |

### Cognitive Dissonance

Discomfort when attitudes and behavior conflict:

**Resolution strategies:**
1. Change attitude
2. Change behavior
3. Add consonant cognitions
4. Minimize importance

**Application**: Small commitments create attitude change (self-perception).

### Foot-in-the-Door

Small request → large request more likely accepted.

**Why it works:**
- Self-perception ("I'm the kind of person who...")
- Consistency drive
- Commitment escalation

**Application**: Free trial → paid; newsletter → purchase.

### Door-in-the-Face

Large request (refused) → smaller request more likely accepted.

**Why it works:**
- Reciprocal concession
- Perceptual contrast
- Guilt from refusal

**Application**: Premium tier first → standard tier seems reasonable.

### Elaboration Likelihood Model (ELM)

| Route | Condition | Persuasion Strategy |
|-------|-----------|---------------------|
| **Central** | High motivation + ability | Strong arguments, evidence |
| **Peripheral** | Low motivation or ability | Cues, heuristics, source |

---

## Prosocial Behavior

### Bystander Effect

Helping decreases as bystanders increase:

| Factor | Effect |
|--------|--------|
| **Diffusion of responsibility** | "Someone else will help" |
| **Pluralistic ignorance** | "If no one's reacting, must be okay" |
| **Evaluation apprehension** | Fear of embarrassment |

**Overcoming**: Direct request to specific person.

### Empathy-Altruism Hypothesis

True altruism exists when empathy is aroused:

| Motivation | Driver | Outcome |
|------------|--------|---------|
| **Egoistic** | Reduce own distress | Help if easy escape unavailable |
| **Altruistic** | Reduce other's distress | Help regardless of escape |

**Marketing application**: Evoke empathy for cause marketing.

### Reciprocity Norms

| Norm | Description |
|------|-------------|
| **Reciprocity** | Help those who help you |
| **Social responsibility** | Help those who need it |
| **Equity** | Help proportional to contribution |

### Building Community

| Element | Mechanism |
|---------|-----------|
| **Membership** | Boundaries, symbols, safety |
| **Influence** | Members matter, group matters |
| **Integration** | Needs met through membership |
| **Shared connection** | History, experiences, identity |
