# Sleep & Circadian Psychology

Understanding sleep's role in learning, performance, and well-being.

## Table of Contents

1. [Sleep Architecture](#sleep-architecture)
2. [Sleep & Learning](#sleep--learning)
3. [Circadian Rhythms](#circadian-rhythms)
4. [Sleep Optimization](#sleep-optimization)
5. [Performance Implications](#performance-implications)

---

## Sleep Architecture

### Sleep Stages

| Stage | Duration | Function | Characteristics |
|-------|----------|----------|-----------------|
| **N1** (Light) | 5% | Transition | Easily awakened, hypnic jerks |
| **N2** (Light) | 45% | Memory consolidation | Sleep spindles, K-complexes |
| **N3** (Deep/SWS) | 25% | Physical restoration, declarative memory | Slow waves, hard to wake |
| **REM** | 25% | Procedural memory, creativity, emotion | Dreams, paralysis, eye movement |

### Sleep Cycles

- Full cycle: ~90 minutes
- 4-6 cycles per night
- More deep sleep early, more REM later
- Each stage serves distinct functions

### Sleep Needs by Age

| Age | Hours Needed | Notes |
|-----|--------------|-------|
| Infant (0-1) | 14-17 | Polyphasic, frequent waking |
| Toddler (1-3) | 11-14 | Consolidating to nighttime |
| Preschool (3-5) | 10-13 | May drop naps |
| School (6-12) | 9-12 | Consistent schedule important |
| Teen (13-17) | 8-10 | Delayed phase common |
| Adult (18-64) | 7-9 | Individual variation |
| Older adult (65+) | 7-8 | More fragmented |

---

## Sleep & Learning

### Memory Consolidation

| Memory Type | Sleep Stage | Mechanism |
|-------------|-------------|-----------|
| **Declarative** (facts) | N2, N3 (SWS) | Hippocampal replay |
| **Procedural** (skills) | N2, REM | Motor cortex consolidation |
| **Emotional** | REM | Amygdala processing |
| **Creative insight** | REM | Association formation |

### Sleep Before Learning

| Sleep Deprivation Effect | Impact on Learning |
|--------------------------|-------------------|
| 1 night | 40% reduction in encoding |
| Chronic (<6 hours) | Cumulative cognitive decline |
| Attention impairment | Missed information |
| Hippocampal dysfunction | Poor memory formation |

### Sleep After Learning

| Timing | Effect |
|--------|--------|
| Same day | Best consolidation |
| Nap (20-90 min) | Significant memory boost |
| Within 24 hours | Still beneficial |
| Delayed | Reduced consolidation |

### Study-Sleep Strategies

| Strategy | Implementation |
|----------|----------------|
| Learn, then sleep | Study evening, sleep on it |
| Spaced with sleep | Sessions across days |
| Pre-sleep review | Quick review before bed |
| Morning tests | Recall after sleep |
| Avoid cramming | Distributed > massed |

---

## Circadian Rhythms

### The Body Clock

| Time | Typical State | Best Activities |
|------|---------------|-----------------|
| 6-9 AM | Rising alertness | Light tasks, exercise |
| 9-12 PM | Peak alertness | Analytical work, focus tasks |
| 12-2 PM | Post-lunch dip | Routine tasks, meetings |
| 2-6 PM | Second peak | Creative work, collaboration |
| 6-9 PM | Declining alertness | Light tasks, social |
| 9 PM+ | Sleep preparation | Wind down, relaxation |

### Chronotypes

| Type | Natural Pattern | Percentage |
|------|-----------------|------------|
| **Morning (Lark)** | Early rise, early peak | ~25% |
| **Evening (Owl)** | Late rise, late peak | ~25% |
| **Intermediate** | Standard pattern | ~50% |

### Chronotype Implications

| Chronotype | Optimal Study Time | Optimal Work Schedule |
|------------|-------------------|----------------------|
| Morning | 6-10 AM | Early start, early finish |
| Evening | 6-11 PM | Later start, later finish |
| Intermediate | 9 AM-12 PM, 2-6 PM | Standard hours |

### Circadian Influences

| Factor | Effect |
|--------|--------|
| **Light** | Primary zeitgeber (time-giver) |
| **Meals** | Secondary synchronizer |
| **Exercise** | Can shift phase |
| **Social cues** | Social zeitgebers |
| **Temperature** | Internal rhythm marker |

---

## Sleep Optimization

### Sleep Hygiene Principles

| Principle | Implementation |
|-----------|----------------|
| **Consistency** | Same sleep/wake times daily |
| **Light exposure** | Bright morning, dim evening |
| **Temperature** | Cool bedroom (65-68°F/18-20°C) |
| **Wind-down** | 30-60 min pre-bed routine |
| **Bed = sleep** | No work/screens in bed |
| **Limit stimulants** | No caffeine 6+ hours before |
| **Exercise timing** | Not within 2-3 hours of bed |

### Light Management

| Time | Recommendation |
|------|----------------|
| Morning | Bright light within 30 min of waking |
| Daytime | Natural light exposure |
| Evening | Dim lights 2 hours before bed |
| Nighttime | Blue light blocking, darkness |

### Nap Guidelines

| Nap Type | Duration | Best For |
|----------|----------|----------|
| Power nap | 10-20 min | Quick refresh, no grogginess |
| Full cycle | 90 min | Full restoration, memory |
| Avoid | 30-60 min | Sleep inertia risk |

**Timing**: Before 3 PM to avoid nighttime disruption.

### Sleep Environment

| Factor | Optimization |
|--------|--------------|
| **Darkness** | Blackout curtains, eye mask |
| **Quiet** | White noise, earplugs |
| **Temperature** | Cool (65-68°F) |
| **Comfort** | Quality mattress, pillows |
| **Air quality** | Ventilation, plants |

---

## Performance Implications

### Cognitive Effects of Sleep Loss

| Function | Impact of Deprivation |
|----------|----------------------|
| Attention | First to decline |
| Working memory | Significant impairment |
| Decision-making | Risk-seeking increases |
| Creativity | Requires REM |
| Emotional regulation | Amygdala hyperactive |
| Learning | Encoding severely impaired |

### Sleep Debt

| Debt Level | Recovery |
|------------|----------|
| 1-2 hours/night | 1-2 good nights |
| Chronic (weeks) | Multiple weeks to months |
| Severe | May never fully recover |

### Optimal Performance Scheduling

| Task Type | Best Time | Sleep Requirement |
|-----------|-----------|-------------------|
| Analytical | Morning peak | Well-rested |
| Creative | Afternoon, slight fatigue | REM sleep prior night |
| Memory encoding | Morning | Night before good sleep |
| Memory testing | Morning after sleep | Sleep consolidation |
| Physical | Afternoon | SWS prior night |

### Shift Work Considerations

| Challenge | Mitigation |
|-----------|------------|
| Circadian disruption | Consistent shift patterns |
| Light at night | Blue-blocking glasses |
| Sleep quality | Blackout, white noise |
| Alertness at work | Strategic caffeine, light |
| Recovery | Extra sleep on days off |

---

## Learning & Training Design

### Incorporating Sleep Science

| Principle | Application |
|-----------|-------------|
| **Spaced practice** | Sessions across days for sleep consolidation |
| **Pre-sleep learning** | Review material before bed |
| **Morning testing** | Assess after overnight consolidation |
| **Respect chronotypes** | Flexible scheduling when possible |
| **Avoid sleep deprivation** | Don't encourage all-nighters |

### E-Learning Considerations

| Factor | Design Response |
|--------|-----------------|
| Asynchronous access | Allow learning at personal optimal time |
| Module length | Align with attention cycles (~90 min max) |
| Breaks | Encourage rest, movement |
| Sleep reminders | Don't encourage late-night study |
| Spacing | Build in review across days |

### Workplace Implications

| Factor | Recommendation |
|--------|----------------|
| Meeting times | Avoid early AM or late PM |
| Important decisions | Morning after good sleep |
| Creative sessions | Afternoon |
| Nap rooms | Consider for high-performance environments |
| Shift scheduling | Rotate forward (day→evening→night) |
