# Skill-Specific Acquisition Frameworks

Evidence-based approaches for acquiring specific skill categories optimized by age and context.

## Table of Contents

1. [Languages](#languages)
2. [Programming](#programming)
3. [Mathematics](#mathematics)
4. [Motor Skills](#motor-skills)
5. [Creative Skills](#creative-skills)

---

## Languages

### Critical Period Hypothesis

| Age Window | Capacity | Implication |
|------------|----------|-------------|
| 0-6 | Native-like phonology possible | Maximum immersion value |
| 7-12 | Near-native achievable | Pronunciation still malleable |
| 13-17 | Accent likely; grammar still strong | Focus on communication |
| 18+ | Effortful but possible | Explicit instruction helps |

### Second Language Acquisition Stages

1. **Silent Period** (0-6 months): Comprehension focus; speaking limited
2. **Early Production** (6 months-1 year): 1-2 word responses
3. **Speech Emergence** (1-3 years): Simple sentences, many errors
4. **Intermediate Fluency** (3-5 years): Complex sentences, fewer errors
5. **Advanced Fluency** (5-7 years): Near-native in academic contexts

### Evidence-Based Methods by Age

#### Children (3-12)

| Method | Effectiveness | Best For |
|--------|---------------|----------|
| **Immersion** | Highest | All aspects, esp. pronunciation |
| **TPR** (Total Physical Response) | High | Vocabulary, comprehension |
| **Story-based** | High | Grammar patterns, culture |
| **Songs/Rhymes** | High | Phonology, memory |
| **Games** | Medium-High | Vocabulary, engagement |

**Key Principles:**
- Minimize explicit grammar instruction before age 10
- Maximize comprehensible input
- Focus on high-frequency vocabulary (first 1000 words = 80% of speech)
- Pronunciation correction gentle and indirect

#### Adolescents (13-17)

| Method | Effectiveness | Best For |
|--------|---------------|----------|
| **Communicative** | High | Fluency, confidence |
| **Content-based** | High | Motivation, vocabulary |
| **Task-based** | High | Real-world application |
| **Explicit grammar** | Medium | Accuracy (when ready) |

**Key Principles:**
- Connect to identity and interests
- Peer interaction highly motivating
- Real-world content (music, media, social)
- Balance fluency and accuracy

#### Adults (18+)

| Method | Effectiveness | Best For |
|--------|---------------|----------|
| **Comprehensible input** | High | All aspects |
| **Spaced repetition** | High | Vocabulary retention |
| **Explicit grammar** | Medium-High | Accelerating learning |
| **Shadowing** | Medium | Pronunciation, prosody |
| **Conversation practice** | High | Fluency, confidence |

**Optimal Adult Strategy:**
1. **Foundation** (0-3 months): High-frequency vocabulary (1000 words), basic patterns
2. **Expansion** (3-12 months): Comprehensible input, conversation practice
3. **Refinement** (12+ months): Accuracy focus, specialized vocabulary

### Vocabulary Acquisition

**Frequency Bands:**
| Words | Coverage | Implication |
|-------|----------|-------------|
| 1,000 | ~80% spoken | Focus here first |
| 3,000 | ~95% spoken | Functional fluency |
| 5,000 | ~98% | Comfortable reading |
| 10,000 | ~99% | Native-like reading |

**Retrieval Schedule:**
- New word: Test same day, next day, 3 days, 1 week, 2 weeks, 1 month
- Use spaced repetition software (Anki, etc.) for efficiency

---

## Programming

### Stages of Programming Skill

1. **Syntax** (0-3 months): Language mechanics
2. **Semantics** (3-12 months): What code means/does
3. **Problem Decomposition** (6-24 months): Breaking problems down
4. **Design Patterns** (1-3 years): Recognized solutions
5. **Architecture** (3+ years): System-level thinking

### Age-Appropriate Approaches

#### Children (7-12)

| Tool/Method | Age | Focus |
|-------------|-----|-------|
| **Scratch** | 7-10 | Computational thinking, no syntax |
| **Code.org** | 7-12 | Structured progression, game-based |
| **Minecraft Education** | 8-12 | Motivation, spatial reasoning |
| **Python (simple)** | 10-12 | Text-based introduction |

**Key Principles:**
- Immediate visual feedback essential
- Project-based (games, animations)
- Short sessions (20-30 min)
- Pair programming effective
- Debugging as learning opportunity

#### Adolescents (13-17)

| Approach | Focus | Tools |
|----------|-------|-------|
| **Project-based** | Motivation, application | Any language |
| **Game development** | Engagement | Unity, Godot, Pygame |
| **Web development** | Visible results | HTML/CSS/JS |
| **Competitive** | Challenge, community | Codeforces, USACO |

**Key Principles:**
- Real projects with personal meaning
- Version control early (Git)
- Community involvement (GitHub, Discord)
- Balance tutorials and struggle

#### Adults (18+)

| Context | Approach | Timeline |
|---------|----------|----------|
| **Career change** | Bootcamp-style, intensive | 3-6 months |
| **Enhancement** | Just-in-time, project-driven | Ongoing |
| **Academic** | Theory + practice | 1-2 years |

**Efficient Adult Learning:**
1. **Choose one language** and stick with it (6+ months)
2. **Build projects** immediately (not tutorial hell)
3. **Read code** as much as write it
4. **Deliberate practice** on weak areas
5. **Teach others** to solidify understanding

### Debugging as Metacognition

Debugging skill correlates with programming expertise:

| Level | Debugging Approach |
|-------|-------------------|
| Novice | Random changes, frustration |
| Intermediate | Print statements, systematic |
| Expert | Hypothesis-driven, mental simulation |

**Teaching debugging:**
1. Model think-aloud debugging
2. Rubber duck debugging (explain to object)
3. Binary search strategy (isolate problem)
4. Error message reading skills

### Common Learning Pitfalls

| Pitfall | Description | Remedy |
|---------|-------------|--------|
| Tutorial hell | Endless tutorials, no building | Build immediately |
| Language hopping | Switching languages too often | Commit 6+ months |
| Perfectionism | Waiting to ship | Ship early, iterate |
| Isolation | Learning alone | Community, pair programming |
| Copy-paste | No understanding | Type code, explain each line |

---

## Mathematics

### Mathematical Development Stages

| Stage | Age | Characteristics |
|-------|-----|-----------------|
| **Pre-numeric** | 3-4 | Counting, one-to-one correspondence |
| **Numeric** | 5-7 | Number sense, basic operations |
| **Operational** | 8-11 | Multi-digit, fractions, concepts |
| **Abstract** | 12+ | Variables, proofs, generalization |

### Concrete-Representational-Abstract (CRA) Sequence

**Most effective progression for new concepts:**

1. **Concrete**: Physical manipulatives (blocks, counters)
2. **Representational**: Visual models (diagrams, drawings)
3. **Abstract**: Symbols and notation

**Timeline:** Spend sufficient time at each stage before progressing.

### Age-Appropriate Strategies

#### Children (5-12)

| Concept | Concrete | Representational | Abstract |
|---------|----------|------------------|----------|
| Addition | Counters, fingers | Number lines | 3 + 4 = 7 |
| Fractions | Pizza slices, blocks | Pie charts | 1/2 + 1/4 |
| Multiplication | Arrays of objects | Grid drawings | 3 × 4 = 12 |

**Key Principles:**
- Number sense before procedures
- Multiple representations of same concept
- Productive struggle (not too easy, not impossible)
- Math talk: verbalize reasoning

#### Adolescents/Adults

| Approach | Best For |
|----------|----------|
| **Problem-based** | Motivation, application |
| **Worked examples** | Initial learning, efficiency |
| **Interleaving** | Discrimination, retention |
| **Error analysis** | Misconception correction |

**For math anxiety:**
1. Growth mindset messaging
2. Reduce time pressure initially
3. Emphasize understanding over speed
4. Connect to real applications
5. Small successes build confidence

### Procedural vs Conceptual

| Type | Description | Balance |
|------|-------------|---------|
| **Procedural** | How to do it | Efficient execution |
| **Conceptual** | Why it works | Transfer, flexibility |

**Optimal**: Develop together; neither alone is sufficient.

---

## Motor Skills

### Fitts & Posner's Stages

| Stage | Characteristics | Duration |
|-------|-----------------|----------|
| **Cognitive** | Verbal, effortful, inconsistent | Hours-days |
| **Associative** | Refining, detecting errors | Days-weeks |
| **Autonomous** | Automatic, consistent, parallel processing | Weeks-years |

### Practice Principles

| Principle | Description | Application |
|-----------|-------------|-------------|
| **Distributed** | Spread over time | Short, frequent sessions |
| **Variable** | Vary conditions | Different contexts |
| **Random** | Mix skills | Interleave related skills |
| **Whole-part** | Balance whole and parts | Depends on complexity |

### Feedback Types

| Type | When to Use |
|------|-------------|
| **Knowledge of Results** | After completion, outcome-focused |
| **Knowledge of Performance** | During, process-focused |
| **Bandwidth** | Only when outside acceptable range |
| **Self-generated** | As expertise grows |

**Fading feedback**: Reduce frequency as skill develops to promote self-assessment.

### Age Considerations

| Age | Motor Learning Characteristics |
|-----|------------------------------|
| 3-6 | Fundamental movement patterns; high plasticity |
| 7-12 | Skill refinement; sport specialization premature |
| 13-17 | Peak learning rate; specialization appropriate |
| 18+ | Efficiency focus; transfer from prior skills |

---

## Creative Skills

### Creativity Development

| Component | Description | Development |
|-----------|-------------|-------------|
| **Divergent thinking** | Generate many ideas | Practice, low judgment |
| **Convergent thinking** | Select best ideas | Criteria, evaluation |
| **Domain knowledge** | Foundation for innovation | Deep expertise |
| **Intrinsic motivation** | Engagement driver | Autonomy, mastery |

### Teaching Creative Skills

**Environment factors:**
- Psychological safety (okay to fail)
- Autonomy (choice in approach)
- Challenge (optimal difficulty)
- Resources (tools, time, space)

**Process:**
1. **Incubation**: Allow unconscious processing
2. **Constraints**: Paradoxically boost creativity
3. **Iteration**: Refine through cycles
4. **Feedback**: Specific, growth-oriented

### Domain-Specific (Art, Music, Writing)

| Skill | Beginner Focus | Intermediate | Advanced |
|-------|----------------|--------------|----------|
| **Visual Art** | Basic techniques, copying | Composition, style exploration | Personal voice, conceptual |
| **Music** | Fundamentals, repertoire | Interpretation, improvisation | Composition, mastery |
| **Writing** | Mechanics, imitation | Voice, structure | Style, genre-bending |

**Common thread**: Technical foundation → Imitation → Experimentation → Personal style
