# Safety & Ethics Guidelines

Mandatory guardrails for responsible application of psychology knowledge.

## Table of Contents

1. [Hard Boundaries](#hard-boundaries)
2. [Vulnerable Populations](#vulnerable-populations)
3. [Ethical Persuasion](#ethical-persuasion)
4. [Learning Safety](#learning-safety)
5. [Validation Checklists](#validation-checklists)

---

## Hard Boundaries

### Absolute Prohibitions

| DO NOT | Rationale |
|--------|-----------|
| Provide medical/psychiatric diagnosis | Requires licensed professional |
| Recommend medication or dosage | Medical scope |
| Offer crisis intervention | Requires trained responders |
| Diagnose learning disabilities | Requires assessment |
| Provide therapy | Requires licensed therapist |
| Make clinical predictions | Outside scope |

### When to Refer Out

| Situation | Referral |
|-----------|----------|
| Signs of mental health crisis | Crisis hotline, emergency services |
| Learning difficulties suspected | Educational psychologist |
| Medical symptoms | Healthcare provider |
| Legal concerns | Legal professional |
| Financial decisions (major) | Financial advisor |

### Referral Resources

**Crisis Resources (US):**
- National Suicide Prevention: 988
- Crisis Text Line: Text HOME to 741741
- SAMHSA National Helpline: 1-800-662-4357

**Note**: Localize resources for user's region.

---

## Vulnerable Populations

### Children & Minors

| Principle | Application |
|-----------|-------------|
| **Safety first** | Conservative recommendations |
| **Guardian involvement** | Recommend parental engagement |
| **Age-appropriate** | Match developmental stage |
| **Protection from manipulation** | No persuasion techniques |
| **Privacy** | Minimal data, clear consent |

### Cognitive Vulnerabilities

| Population | Consideration |
|------------|---------------|
| **Learning differences** | Accommodate varied processing |
| **Cognitive decline** | Patient, clear communication |
| **Mental health conditions** | Avoid triggering content |
| **Neurodivergence** | Flexible, non-judgmental |

### High-Stakes Decisions

| Decision Type | Required Safeguards |
|---------------|---------------------|
| **Health** | Recommend professional consultation |
| **Financial** | Disclaim non-advisory role |
| **Legal** | Recommend legal counsel |
| **Career** | Note as guidance only |
| **Relationship** | Suggest counseling for serious issues |

---

## Ethical Persuasion

### Ethical Principles

| Principle | Description | Violation Example |
|-----------|-------------|-------------------|
| **Transparency** | Clear about intent | Hidden fees, deceptive claims |
| **Autonomy** | Respect free choice | Forced actions, dark patterns |
| **Beneficence** | User benefit genuine | Selling harmful products |
| **Non-maleficence** | Avoid harm | Exploiting vulnerabilities |
| **Justice** | Fair treatment | Discriminatory targeting |
| **Truthfulness** | Honest claims | False scarcity, fake reviews |

### Persuasion vs Manipulation

| Persuasion (Ethical) | Manipulation (Unethical) |
|---------------------|-------------------------|
| Transparent intent | Hidden agenda |
| Respects autonomy | Undermines choice |
| Genuine value | Exploits weakness |
| Honest framing | Deceptive framing |
| Mutual benefit | One-sided benefit |
| Withstands scrutiny | Relies on concealment |

### Dark Patterns Prohibition

**Never recommend or implement:**

| Pattern | Description |
|---------|-------------|
| **Confirmshaming** | Guilt-tripping decline options |
| **Hidden costs** | Surprise fees |
| **Roach motel** | Easy in, hard out |
| **Forced continuity** | Silent auto-renewal |
| **Friend spam** | Unauthorized contact harvesting |
| **Privacy zuckering** | Confusing privacy controls |
| **Misdirection** | Distracting from important info |
| **Bait and switch** | Promise one, deliver another |
| **Disguised ads** | Ads that look like content |
| **Trick questions** | Confusing yes/no |

### Marketing Ethics Checklist

Before any persuasion recommendation:

| Question | Required Answer |
|----------|-----------------|
| Is this transparent? | ✓ Yes |
| Is the value genuine? | ✓ Yes |
| Would I want this done to me? | ✓ Yes |
| Can user make informed choice? | ✓ Yes |
| Could this harm vulnerable users? | ✗ No |
| Is scarcity/urgency real? | ✓ Yes |
| Are claims accurate and provable? | ✓ Yes |
| Is this legal in target markets? | ✓ Yes |

---

## Learning Safety

### Avoiding Harm in Learning Design

| Risk | Prevention |
|------|------------|
| **Overwhelm** | Appropriate pacing, chunking |
| **Frustration** | Scaffolding, support access |
| **Anxiety** | Growth mindset framing, safe failure |
| **Comparison harm** | Individual progress focus |
| **Burnout** | Rest, sustainable pace |
| **Dependency** | Build autonomy progressively |

### Age-Appropriate Guidelines

| Age | Guardrails |
|-----|------------|
| **Under 13** | Parental consent, COPPA compliance, safety-first |
| **13-17** | Privacy protection, age-appropriate content |
| **Adults** | Informed consent, autonomy respect |
| **Older adults** | Patience, dignity, accessibility |

### Learning Disability Awareness

**Signs that may indicate need for assessment:**
- Persistent difficulty despite effort
- Inconsistent performance
- Processing speed significantly below peers
- Specific skill deficits (reading, math, writing)

**Response**: Suggest professional assessment, not diagnosis.

---

## Validation Checklists

### Pre-Output Checklist (Learning)

| Check | Status |
|-------|--------|
| Age-appropriate content? | ☐ |
| Realistic expectations set? | ☐ |
| Safety considerations addressed? | ☐ |
| No medical/clinical claims? | ☐ |
| Guardian involvement noted (if minor)? | ☐ |
| Evidence-based approach? | ☐ |
| Limitations acknowledged? | ☐ |

### Pre-Output Checklist (Marketing)

| Check | Status |
|-------|--------|
| Ethical persuasion only? | ☐ |
| No dark patterns? | ☐ |
| Transparent intent? | ☐ |
| Genuine value provided? | ☐ |
| Claims accurate and provable? | ☐ |
| Vulnerable populations protected? | ☐ |
| Legal compliance considered? | ☐ |
| User autonomy preserved? | ☐ |

### Red Flags to Watch For

| User Request | Appropriate Response |
|--------------|---------------------|
| "How to manipulate..." | Decline, offer ethical alternative |
| "Trick customers into..." | Decline, explain ethical persuasion |
| "Make addictive..." | Decline, discuss ethical engagement |
| "Target vulnerable..." | Decline, protect populations |
| "Bypass consent..." | Decline, explain consent importance |
| "Diagnose my..." | Refer to professional |
| "Therapy for..." | Refer to licensed therapist |

### Documentation Requirements

When providing psychology-based recommendations:

| Element | Requirement |
|---------|-------------|
| **Source** | Framework or principle cited |
| **Limitations** | Context-dependent caveats |
| **Individual variation** | "Results may vary" acknowledgment |
| **Professional referral** | When appropriate |
| **Ethical guardrails** | Built into recommendation |

---

## Data & Privacy

### Data Minimization

| Principle | Application |
|-----------|-------------|
| **Collect minimum** | Only what's necessary |
| **Clear purpose** | Explain why needed |
| **Explicit consent** | Before collection |
| **Secure storage** | Protect collected data |
| **Deletion rights** | Allow removal |

### Privacy in Research

| Consideration | Requirement |
|---------------|-------------|
| **Informed consent** | Clear explanation before participation |
| **Anonymization** | Remove identifying information |
| **Right to withdraw** | Can exit at any time |
| **Data protection** | Secure handling |
| **Results sharing** | Aggregated, not individual |

---

## Regulatory Awareness

### Key Regulations

| Regulation | Scope | Key Requirements |
|------------|-------|------------------|
| **GDPR** | EU data | Consent, data rights |
| **CCPA** | California data | Disclosure, opt-out |
| **COPPA** | Children under 13 | Parental consent |
| **FTC Guidelines** | Advertising | Truthful, not deceptive |
| **ADA** | Accessibility | Accommodations |

### Industry Standards

| Standard | Application |
|----------|-------------|
| **APA Ethics Code** | Psychology practice |
| **CAN-SPAM** | Email marketing |
| **TCPA** | Telephone marketing |
| **Platform policies** | Social media, app stores |

**Note**: Always recommend legal review for specific compliance questions.
