# Organizational Psychology

Understanding human behavior in workplace and team contexts.

## Table of Contents

1. [Team Dynamics](#team-dynamics)
2. [Leadership Psychology](#leadership-psychology)
3. [Organizational Culture](#organizational-culture)
4. [Change Management](#change-management)
5. [Workplace Motivation](#workplace-motivation)

---

## Team Dynamics

### Team Development (Tuckman)

| Stage | Characteristics | Leader Role |
|-------|-----------------|-------------|
| **Forming** | Polite, uncertain, dependent | Direct, structure |
| **Storming** | Conflict, competition, resistance | Facilitate, norm-set |
| **Norming** | Cohesion, trust, agreement | Support, delegate |
| **Performing** | High productivity, autonomy | Empower, remove barriers |
| **Adjourning** | Closure, transition | Recognize, celebrate |

### Psychological Safety (Edmondson)

| Characteristic | Signs | Building It |
|----------------|-------|-------------|
| Safe to take risks | Ideas shared freely | Model vulnerability |
| Safe to be wrong | Mistakes discussed openly | Respond to failure positively |
| Safe to ask questions | Curiosity encouraged | Welcome all questions |
| Safe to disagree | Constructive conflict | Invite dissent |

### Team Roles (Belbin)

| Role | Contribution | Weakness |
|------|--------------|----------|
| **Plant** | Creative ideas | Ignores details |
| **Monitor Evaluator** | Critical analysis | Overly critical |
| **Coordinator** | Clarifies goals | Can delegate too much |
| **Resource Investigator** | Networks, explores | Loses enthusiasm |
| **Implementer** | Turns ideas to action | Inflexible |
| **Completer Finisher** | Quality, deadlines | Perfectionist |
| **Teamworker** | Builds relationships | Indecisive |
| **Shaper** | Challenges, drives | Can offend |
| **Specialist** | Deep expertise | Narrow focus |

### High-Performing Team Characteristics

| Characteristic | Description |
|----------------|-------------|
| Clear purpose | Shared understanding of mission |
| Defined roles | Everyone knows responsibilities |
| Psychological safety | Can take risks, be vulnerable |
| Constructive conflict | Disagree productively |
| Accountability | Hold each other to standards |
| Results focus | Collective outcomes over individual |

---

## Leadership Psychology

### Leadership Styles

| Style | Description | Best When |
|-------|-------------|-----------|
| **Directive** | Tell what to do | Crisis, new employees |
| **Coaching** | Develop capabilities | Willing but unable |
| **Supportive** | Facilitate, encourage | Able but unwilling |
| **Delegating** | Hand off responsibility | Able and willing |
| **Transformational** | Inspire vision, change | Need innovation, change |
| **Servant** | Serve team needs | Building trust, culture |

### Situational Leadership (Hersey-Blanchard)

| Follower Readiness | Leader Style |
|-------------------|--------------|
| Unable, unwilling | Directing (high task, low relationship) |
| Unable, willing | Coaching (high task, high relationship) |
| Able, unwilling | Supporting (low task, high relationship) |
| Able, willing | Delegating (low task, low relationship) |

### Emotional Intelligence in Leadership

| Competency | Application |
|------------|-------------|
| **Self-awareness** | Know impact on others |
| **Self-regulation** | Model emotional control |
| **Empathy** | Understand team needs |
| **Social skills** | Build relationships, resolve conflict |
| **Motivation** | Inspire through example |

### Feedback Psychology

| Type | Purpose | Frequency |
|------|---------|-----------|
| **Positive** | Reinforce behavior | Often (3:1 ratio) |
| **Constructive** | Correct behavior | As needed, privately |
| **Developmental** | Grow capabilities | Regular 1:1s |

**Effective feedback formula**: SBI-I (Situation, Behavior, Impact, Intent)

### Power and Influence

| Power Base | Source | Sustainability |
|------------|--------|----------------|
| **Legitimate** | Position | Moderate |
| **Reward** | Can give rewards | Low (transactional) |
| **Coercive** | Can punish | Very low (resentment) |
| **Expert** | Knowledge, skill | High |
| **Referent** | Respect, admiration | Highest |

---

## Organizational Culture

### Culture Levels (Schein)

| Level | Visibility | Example |
|-------|------------|---------|
| **Artifacts** | Visible | Office design, dress code |
| **Espoused Values** | Stated | Mission statement, policies |
| **Basic Assumptions** | Hidden | Unwritten rules, beliefs |

### Culture Types (Competing Values)

| Type | Focus | Characteristics |
|------|-------|-----------------|
| **Clan** | Collaboration | Family-like, mentoring |
| **Adhocracy** | Create | Innovation, risk-taking |
| **Market** | Compete | Results, winning |
| **Hierarchy** | Control | Structure, efficiency |

### Building Culture

| Element | How to Build |
|---------|--------------|
| **Values** | Define, communicate, model |
| **Rituals** | Regular practices, celebrations |
| **Stories** | Share founding stories, heroes |
| **Symbols** | Physical and visual cues |
| **Language** | Shared vocabulary, metaphors |
| **Norms** | Explicit expectations, reinforcement |

### Culture Change

| Phase | Activities |
|-------|------------|
| **Unfreeze** | Create urgency, dissatisfaction |
| **Change** | Implement new behaviors |
| **Refreeze** | Reinforce, institutionalize |

---

## Change Management

### Resistance to Change

| Reason | Response |
|--------|----------|
| Fear of unknown | Clear communication, vision |
| Loss of control | Participation, input |
| Competence concerns | Training, support |
| Bad timing | Acknowledge, adjust pace |
| Lack of trust | Build relationship, transparency |
| Past failures | Address, learn from history |

### Kotter's 8 Steps

| Step | Action |
|------|--------|
| 1. Create urgency | Show why change needed now |
| 2. Build coalition | Get influential supporters |
| 3. Form vision | Clear picture of future |
| 4. Communicate vision | Repeat 10x what you think needed |
| 5. Remove obstacles | Empower action |
| 6. Quick wins | Visible early successes |
| 7. Build on change | Don't declare victory early |
| 8. Anchor in culture | Make it "how we do things" |

### ADKAR Model (Individual Change)

| Element | Question |
|---------|----------|
| **Awareness** | Do they know why change is needed? |
| **Desire** | Do they want to participate? |
| **Knowledge** | Do they know how to change? |
| **Ability** | Can they implement new skills? |
| **Reinforcement** | Will change stick? |

### Communication During Change

| Principle | Application |
|-----------|-------------|
| **Early** | As soon as possible |
| **Often** | Regular updates |
| **Honest** | Even when uncertain |
| **Two-way** | Listen, not just tell |
| **Multi-channel** | Varied formats |
| **Consistent** | Same message everywhere |

---

## Workplace Motivation

### Motivation Theories Comparison

| Theory | Core Idea | Application |
|--------|-----------|-------------|
| **Maslow** | Hierarchy of needs | Meet basic before higher |
| **Herzberg** | Hygiene vs motivators | Fix hygiene, add motivators |
| **SDT** | Autonomy, competence, relatedness | Support all three |
| **Expectancy** | Effort→performance→outcome | Clear links, fair rewards |
| **Equity** | Fairness of inputs/outputs | Perceived fairness |

### Herzberg's Two-Factor Theory

| Hygiene Factors (Prevent dissatisfaction) | Motivators (Create satisfaction) |
|-------------------------------------------|----------------------------------|
| Salary | Achievement |
| Working conditions | Recognition |
| Job security | Work itself |
| Supervision | Responsibility |
| Company policies | Advancement |
| Relationships | Growth |

### Job Design for Motivation

| Characteristic | Description | Enhancement |
|----------------|-------------|-------------|
| **Skill variety** | Use multiple skills | Cross-training |
| **Task identity** | Complete whole piece | End-to-end ownership |
| **Task significance** | Meaningful impact | Connect to purpose |
| **Autonomy** | Control over work | Decision authority |
| **Feedback** | Know performance | Regular, specific |

### Recognition Psychology

| Effective Recognition | Ineffective Recognition |
|----------------------|------------------------|
| Timely | Delayed |
| Specific | Vague |
| Sincere | Perfunctory |
| Personalized | Generic |
| Public (when appropriate) | Always private |
| Aligned with values | Random |

### Engagement Drivers

| Driver | Description |
|--------|-------------|
| **Meaning** | Work matters, has purpose |
| **Autonomy** | Control over how/when/where |
| **Growth** | Learning, development |
| **Impact** | See results of work |
| **Connection** | Relationships, belonging |
| **Recognition** | Appreciated, valued |

---

## Performance Psychology

### Goal-Setting (SMART+)

| Element | Description |
|---------|-------------|
| **Specific** | Clear, unambiguous |
| **Measurable** | Quantifiable |
| **Achievable** | Realistic stretch |
| **Relevant** | Aligned with purpose |
| **Time-bound** | Deadline |
| **+ Feedback** | Regular progress check |

### Performance Conversations

| Type | Frequency | Focus |
|------|-----------|-------|
| Check-ins | Weekly | Progress, blockers |
| 1:1s | Bi-weekly/monthly | Development, relationship |
| Reviews | Quarterly/annually | Assessment, planning |
| Feedback | Ongoing | Specific behaviors |

### Peak Performance Conditions

| Factor | Optimization |
|--------|--------------|
| Challenge-skill balance | Zone of proximal development |
| Clear goals | Specific, visible |
| Immediate feedback | Know how you're doing |
| Focus | Minimize distractions |
| Autonomy | Control over approach |
| Meaning | Connected to purpose |
