# Neuropsychology Basics

Brain-based understanding of learning, behavior, and decision-making.

## Table of Contents

1. [Brain Systems Overview](#brain-systems-overview)
2. [Neuroplasticity](#neuroplasticity)
3. [Neurotransmitter Systems](#neurotransmitter-systems)
4. [Learning & Memory Neuroscience](#learning--memory-neuroscience)
5. [Stress & The Brain](#stress--the-brain)

---

## Brain Systems Overview

### Key Brain Regions

| Region | Function | Relevance |
|--------|----------|-----------|
| **Prefrontal Cortex** | Executive function, planning, impulse control | Decision-making, self-control |
| **Amygdala** | Emotion processing, fear, memory | Emotional responses, threat detection |
| **Hippocampus** | Memory formation, spatial navigation | Learning, recall |
| **Nucleus Accumbens** | Reward, pleasure, motivation | Engagement, habit formation |
| **Anterior Cingulate** | Error detection, conflict monitoring | Attention, problem-solving |
| **Insula** | Interoception, empathy, disgust | Emotional awareness, social |

### Brain Development Timeline

| Age | Key Development | Implication |
|-----|-----------------|-------------|
| 0-3 | Rapid synapse formation | Critical period for basics |
| 3-6 | Language, motor, social | Play-based learning peak |
| 7-12 | Pruning, efficiency | Skill consolidation |
| 13-17 | Limbic before prefrontal | Emotion > logic |
| 18-25 | Prefrontal maturation | Full executive function |
| 25+ | Maintenance, compensation | Experience-based learning |

### Dual-Process Neuroscience

| System | Brain Basis | Characteristics |
|--------|-------------|-----------------|
| **System 1** (Fast) | Subcortical, amygdala, basal ganglia | Automatic, emotional, habitual |
| **System 2** (Slow) | Prefrontal cortex | Deliberate, effortful, rational |

---

## Neuroplasticity

### Types of Plasticity

| Type | Description | Timeframe |
|------|-------------|-----------|
| **Synaptic** | Strengthening/weakening connections | Minutes to hours |
| **Structural** | New connections, dendritic growth | Days to weeks |
| **Cortical map** | Reorganization of brain areas | Weeks to months |

### Hebbian Learning

**"Neurons that fire together, wire together."**

| Principle | Application |
|-----------|-------------|
| Repeated activation strengthens | Practice, repetition |
| Simultaneity matters | Associate concepts together |
| Emotional salience enhances | Emotional learning sticks |
| Use it or lose it | Regular practice maintains |

### Promoting Neuroplasticity

| Factor | Effect | Implementation |
|--------|--------|----------------|
| **Novelty** | Stimulates growth | Varied challenges |
| **Challenge** | Optimal difficulty | Edge of ability |
| **Attention** | Enhances encoding | Focus, reduce distraction |
| **Emotion** | Strengthens memory | Meaningful, relevant |
| **Sleep** | Consolidates learning | Adequate rest |
| **Exercise** | Increases BDNF | Physical activity |

### Critical Periods

| Function | Critical Period | Adult Plasticity |
|----------|-----------------|------------------|
| Vision | 0-5 years | Limited |
| Language phonology | 0-7 years | Accent challenges |
| Grammar | 0-12 years | Possible but harder |
| Motor skills | Ongoing | High plasticity |
| Cognitive | Ongoing | High plasticity |

---

## Neurotransmitter Systems

### Key Neurotransmitters

| Neurotransmitter | Function | Learning/Marketing Relevance |
|------------------|----------|----------------------------|
| **Dopamine** | Reward, motivation, prediction | Engagement, habit formation |
| **Serotonin** | Mood, well-being | Positive emotional state |
| **Norepinephrine** | Alertness, attention | Focus, urgency |
| **Acetylcholine** | Learning, memory, attention | Encoding, concentration |
| **GABA** | Inhibition, calm | Anxiety reduction |
| **Glutamate** | Excitation, learning | Memory formation |

### Dopamine System Deep Dive

| Concept | Description | Application |
|---------|-------------|-------------|
| **Reward prediction error** | Surprise > expected | Exceed expectations |
| **Anticipation** | Wanting > having | Build anticipation |
| **Variable reward** | Unpredictability | Engagement (use ethically) |
| **Progress** | Small wins trigger dopamine | Visible progress |
| **Novelty** | New = dopamine spike | Fresh content |

### Dopamine and Habits

| Phase | Dopamine Role |
|-------|---------------|
| Cue | Anticipation spike |
| Craving | Motivational state |
| Response | Action execution |
| Reward | Learning signal |

**Key insight**: Dopamine drives pursuit, not satisfaction.

### Stress Hormones

| Hormone | Effect | Design Implication |
|---------|--------|-------------------|
| **Cortisol** | Stress response, memory impairment (chronic) | Reduce user stress |
| **Adrenaline** | Fight/flight, enhanced encoding | Emotional memories |
| **Norepinephrine** | Attention, arousal | Moderate stress helps focus |

---

## Learning & Memory Neuroscience

### Memory Systems

| System | Brain Region | Function | Duration |
|--------|--------------|----------|----------|
| **Working** | Prefrontal cortex | Active manipulation | Seconds |
| **Episodic** | Hippocampus | Personal experiences | Long-term |
| **Semantic** | Temporal cortex | Facts, concepts | Long-term |
| **Procedural** | Basal ganglia, cerebellum | Skills, habits | Long-term |

### Memory Consolidation

| Stage | Process | Optimization |
|-------|---------|--------------|
| **Encoding** | Initial learning | Attention, meaning |
| **Consolidation** | Stabilization | Sleep, rest |
| **Reconsolidation** | Updating | Retrieval + new info |
| **Retrieval** | Accessing | Practice, cues |

### Sleep and Learning

| Sleep Stage | Function | Learning Benefit |
|-------------|----------|------------------|
| **Light (N1-N2)** | Transition | Motor skill consolidation |
| **Deep (N3)** | Restoration | Declarative memory |
| **REM** | Dreaming | Creativity, integration |

**Recommendation**: Sleep after learning; critical for consolidation.

### Attention Networks

| Network | Function | Enhancement |
|---------|----------|-------------|
| **Alerting** | Maintaining vigilance | Novelty, breaks |
| **Orienting** | Directing attention | Salience, cues |
| **Executive** | Conflict resolution | Reduce distractions |

---

## Stress & The Brain

### Yerkes-Dodson Law

**Performance peaks at moderate arousal:**

```
Performance
    │
    │       ╱╲
    │      ╱  ╲
    │     ╱    ╲
    │    ╱      ╲
    │   ╱        ╲
    │──╱──────────╲──
    Low   Optimal   High
         Arousal
```

### Acute vs Chronic Stress

| Type | Effect | Implication |
|------|--------|-------------|
| **Acute** | Enhanced focus, memory | Moderate challenge helps |
| **Chronic** | Impaired memory, reduced plasticity | Avoid sustained stress |

### Stress and Learning

| Stress Level | Learning Effect | Design Response |
|--------------|-----------------|-----------------|
| Too low | Boredom, disengagement | Increase challenge |
| Optimal | Peak performance | Zone of proximal development |
| Too high | Anxiety, impaired memory | Reduce pressure, support |

### Amygdala Hijack

Emotional overwhelm bypasses rational brain:

| Sign | Response |
|------|----------|
| Strong emotional reaction | Pause, don't escalate |
| Irrational decision | Cooling-off period |
| Fight/flight activation | Safety, calm signals |

**Design implication**: When users are upset, reduce cognitive load.

---

## Brain-Based Design Principles

### For Learning

| Principle | Brain Basis | Implementation |
|-----------|-------------|----------------|
| **Spaced practice** | Memory consolidation | Distributed sessions |
| **Interleaving** | Discrimination, transfer | Mix topics |
| **Testing** | Retrieval strengthens | Frequent quizzes |
| **Sleep** | Consolidation | Encourage rest |
| **Exercise** | BDNF, neuroplasticity | Movement breaks |
| **Emotion** | Amygdala enhances encoding | Meaningful content |

### For Engagement

| Principle | Brain Basis | Implementation |
|-----------|-------------|----------------|
| **Variable reward** | Dopamine prediction error | Unexpected bonuses |
| **Progress** | Dopamine from milestones | Visible advancement |
| **Novelty** | Attention, dopamine | Fresh content |
| **Social** | Oxytocin, belonging | Community features |
| **Autonomy** | Intrinsic motivation | Choice, control |

### For Conversion

| Principle | Brain Basis | Implementation |
|-----------|-------------|----------------|
| **Reduce cognitive load** | Working memory limits | Simplify decisions |
| **Social proof** | Social brain, conformity | Show others' choices |
| **Loss framing** | Amygdala, loss aversion | What they miss |
| **Urgency** | Norepinephrine | Real deadlines |
| **Reward anticipation** | Dopamine | Preview benefits |
