# Negotiation Psychology

Principles for effective negotiation and persuasion in business contexts.

## Table of Contents

1. [Negotiation Fundamentals](#negotiation-fundamentals)
2. [Psychological Tactics](#psychological-tactics)
3. [Principled Negotiation](#principled-negotiation)
4. [Power Dynamics](#power-dynamics)
5. [Cross-Cultural Negotiation](#cross-cultural-negotiation)

---

## Negotiation Fundamentals

### BATNA (Best Alternative)

| Concept | Description | Application |
|---------|-------------|-------------|
| **BATNA** | Best alternative if no deal | Know yours, estimate theirs |
| **Reservation price** | Walk-away point | Don't reveal it |
| **ZOPA** | Zone of possible agreement | Where deals happen |
| **Aspiration point** | Ideal outcome | Aim high but realistic |

### Negotiation Styles

| Style | Focus | Best When |
|-------|-------|-----------|
| **Distributive** | Win-lose, fixed pie | One-time, zero-sum |
| **Integrative** | Win-win, expand pie | Ongoing relationship |
| **Mixed** | Both elements | Most real negotiations |

### Preparation Checklist

| Area | Questions |
|------|-----------|
| **Interests** | What do I really want? What do they want? |
| **Options** | What creative solutions exist? |
| **Alternatives** | What's my BATNA? Theirs? |
| **Legitimacy** | What standards/criteria apply? |
| **Communication** | How should I approach this? |
| **Relationship** | How important is ongoing relationship? |
| **Commitment** | What am I authorized to agree to? |

---

## Psychological Tactics

### Anchoring

First number strongly influences final outcome:

| Tactic | Application |
|--------|-------------|
| Anchor first | Make the first offer (if informed) |
| Anchor high/low | Start more extreme than target |
| Counter-anchor | Respond with equally extreme counter |
| Re-anchor | Introduce new reference points |

**Defense**: Recognize anchors; don't react emotionally.

### Reciprocity in Negotiation

| Tactic | Description |
|--------|-------------|
| **Concession trading** | Give to get |
| **Labeled concession** | "I'm giving you X" |
| **Graduated concessions** | Start large, decrease size |
| **Contingent concession** | "If you do X, I'll do Y" |

### Scarcity & Urgency

| Tactic | Ethical Use |
|--------|-------------|
| Limited time | Real deadlines only |
| Limited quantity | Genuine scarcity |
| Competition | True alternatives |
| Deadline | Actual constraints |

### Commitment & Consistency

| Tactic | Application |
|--------|-------------|
| Small commitments first | Get agreement on easy items |
| Public commitment | Written or witnessed agreements |
| Active participation | Involve them in generating solutions |
| Escalation | Build on prior agreements |

### Social Proof in Negotiation

| Tactic | Example |
|--------|---------|
| Precedent | "Other clients have accepted..." |
| Standards | "Industry standard is..." |
| Expert opinion | "Analysts recommend..." |
| Peer behavior | "Companies like yours typically..." |

---

## Principled Negotiation

### Harvard Method (Fisher & Ury)

| Principle | Description | Application |
|-----------|-------------|-------------|
| **Separate people from problem** | Attack issue, not person | "We have a problem" not "You're wrong" |
| **Focus on interests** | Underlying needs, not positions | Ask "why" and "why not" |
| **Generate options** | Creative solutions | Brainstorm before deciding |
| **Use objective criteria** | Fair standards | Market value, precedent, law |

### Interest-Based Bargaining

| Position | Interest Behind |
|----------|-----------------|
| "I want $100K salary" | Security, recognition, market value |
| "I need it by Friday" | Meeting downstream deadline |
| "I won't accept less than 50%" | Control, fairness, risk |

**Key**: Ask "Why is that important to you?"

### Expanding the Pie

| Strategy | Description |
|----------|-------------|
| **Add issues** | Include items you value differently |
| **Trade-offs** | Exchange high/low value items |
| **Contingent agreements** | "If X happens, then Y" |
| **Payment structure** | Timing, form, conditions |
| **Non-monetary value** | Recognition, flexibility, access |

### BATNA Development

| Strategy | Implementation |
|----------|----------------|
| **Improve yours** | Develop real alternatives |
| **Weaken theirs** | (Ethically) show your uniqueness |
| **Research theirs** | Understand their alternatives |
| **Walk away willingness** | Be genuinely prepared to leave |

---

## Power Dynamics

### Sources of Power

| Source | Description | Building It |
|--------|-------------|-------------|
| **BATNA** | Alternatives | Develop options |
| **Information** | Knowledge | Research deeply |
| **Expertise** | Credibility | Demonstrate competence |
| **Legitimacy** | Authority, norms | Reference standards |
| **Relationship** | Connection, trust | Build rapport |
| **Time** | Patience, deadlines | Manage time pressure |

### Dealing with Power Imbalance

| When Weaker | Strategy |
|-------------|----------|
| Improve BATNA | Develop real alternatives |
| Build coalition | Find allies |
| Use legitimacy | Appeal to fairness, standards |
| Information power | Know more than they expect |
| Relationship | Build connection |
| Time | Be patient; don't show urgency |

### Handling Difficult Tactics

| Tactic | Counter |
|--------|---------|
| **Good cop/bad cop** | Recognize and address both |
| **Extreme anchor** | Don't react; counter-anchor |
| **Take it or leave it** | Test if real; find alternatives |
| **Deadline pressure** | Verify; manage your timeline |
| **Authority limits** | Verify authority upfront |
| **Emotional outburst** | Stay calm; take a break |

### Ethical Boundaries

| Acceptable | Unacceptable |
|------------|--------------|
| Strategic disclosure | Lying |
| Positive framing | Misrepresentation |
| Anchoring | False claims |
| Silence | Threats |
| Walking away | Personal attacks |
| Objective criteria | Manipulation |

---

## Cross-Cultural Negotiation

### Cultural Dimensions (Hofstede)

| Dimension | High | Low | Negotiation Impact |
|-----------|------|-----|-------------------|
| **Power Distance** | Hierarchy respected | Equality expected | Decision authority |
| **Individualism** | Self-interest | Group harmony | Team vs individual deals |
| **Uncertainty Avoidance** | Detailed contracts | Relationship-based | Contract specificity |
| **Long-Term Orientation** | Patient, relationship | Quick results | Timeline expectations |

### Regional Patterns (Generalizations)

| Region | Tendency | Adaptation |
|--------|----------|------------|
| **North America** | Direct, efficient, contractual | Get to business, clear terms |
| **Western Europe** | Variable by country | Research specific culture |
| **East Asia** | Relationship-first, indirect | Build trust, save face |
| **Middle East** | Relationship-focused, haggling | Hospitality, patience |
| **Latin America** | Personal, flexible timing | Relationship, flexibility |

### Face-Saving Strategies

| Strategy | Application |
|----------|-------------|
| Private communication | Avoid public embarrassment |
| Indirect messages | Allow room for adjustment |
| Third parties | Use intermediaries |
| Reframing | Allow graceful position change |
| Time | Give space to reconsider |

### Communication Styles

| Aspect | Low-Context | High-Context |
|--------|-------------|--------------|
| Communication | Explicit, verbal | Implicit, nonverbal |
| Agreements | Written contracts | Relationships |
| Confrontation | Direct | Indirect |
| Time | Linear, scheduled | Flexible, relationship |
| Trust | Contract-based | Relationship-based |

---

## Salary & Business Negotiation

### Salary Negotiation

| Stage | Approach |
|-------|----------|
| **Research** | Know market rates, company range |
| **Timing** | After offer, before acceptance |
| **Framing** | Value-based, collaborative |
| **Counter** | Specific number (anchoring) |
| **Beyond salary** | Consider total package |

### B2B Negotiation

| Element | Consideration |
|---------|---------------|
| Multiple stakeholders | Map decision-makers |
| Long sales cycle | Patience, relationship |
| Complex pricing | Package creatively |
| Ongoing relationship | Win-win crucial |
| Implementation | Negotiate support, training |

### Vendor Negotiation

| Leverage Point | Usage |
|----------------|-------|
| Competition | Real alternatives |
| Volume | Quantity commitments |
| Timing | End of quarter/year |
| Relationship | Long-term value |
| Bundling | Package deals |
| Payment terms | Timing flexibility |
