# Motivation Frameworks

Comprehensive guide to understanding and optimizing human motivation for learning, behavior change, and engagement.

## Table of Contents

1. [Motivation Theories](#motivation-theories)
2. [Self-Determination Theory](#self-determination-theory)
3. [Goal Theory](#goal-theory)
4. [Habit Formation](#habit-formation)
5. [Behavior Change Models](#behavior-change-models)

---

## Motivation Theories

### Intrinsic vs Extrinsic

| Type | Source | Sustainability | Risk |
|------|--------|----------------|------|
| **Intrinsic** | Activity itself | High | Requires interest match |
| **Extrinsic** | External rewards/punishments | Variable | Undermining effect |

**Overjustification Effect**: External rewards can reduce intrinsic motivation for previously enjoyed activities.

**When extrinsic works:**
- Task is not intrinsically interesting
- Rewards are unexpected
- Rewards are informational (not controlling)
- Needed to initiate behavior

### Expectancy-Value Theory

**Motivation = Expectancy × Value**

| Component | Description | Enhancement Strategy |
|-----------|-------------|---------------------|
| **Expectancy** | Belief in ability to succeed | Past success, modeling, scaffolding |
| **Value** | Importance, interest, utility | Relevance, choice, connection |
| **Cost** | Effort, time, emotional | Reduce barriers, support |

If either expectancy or value is zero, motivation is zero.

### Attribution Theory (Weiner)

How people explain success/failure affects future motivation:

| Attribution | Dimension | Effect on Motivation |
|-------------|-----------|---------------------|
| **Ability** | Internal, stable | Fixed mindset risk |
| **Effort** | Internal, unstable | Growth mindset |
| **Task difficulty** | External, stable | Learned helplessness risk |
| **Luck** | External, unstable | Low control perception |

**Optimal attribution**: Success → ability + effort; Failure → insufficient effort (controllable)

---

## Self-Determination Theory

### Basic Psychological Needs

| Need | Description | Satisfaction Strategies |
|------|-------------|------------------------|
| **Autonomy** | Sense of choice and volition | Options, rationale, acknowledgment |
| **Competence** | Feeling effective | Optimal challenge, feedback, progress |
| **Relatedness** | Connection to others | Belonging, support, collaboration |

**Thwarting any need reduces motivation and well-being.**

### Motivation Continuum

```
Less Self-Determined ←────────────────────────→ More Self-Determined

Amotivation → External → Introjected → Identified → Integrated → Intrinsic
   │              │           │            │            │           │
No value    Rewards/     Guilt/      Personally   Aligned     Inherent
            punishments  self-worth   important    with self   enjoyment
```

### Autonomy-Supportive Practices

| Practice | Description | Example |
|----------|-------------|---------|
| **Provide choice** | Meaningful options | Choose project topic |
| **Offer rationale** | Explain why | "This helps because..." |
| **Acknowledge feelings** | Validate perspective | "I understand this is challenging" |
| **Minimize control** | Reduce coercion | Invitational language |
| **Support exploration** | Allow experimentation | Safe failure space |

### Competence Support

| Practice | Description | Example |
|----------|-------------|---------|
| **Optimal challenge** | Not too easy, not too hard | Zone of proximal development |
| **Positive feedback** | Specific, effort-focused | "Your strategy improved because..." |
| **Structure** | Clear expectations | Rubrics, milestones |
| **Scaffolding** | Graduated support | Fade as skill grows |

### Relatedness Support

| Practice | Description | Example |
|----------|-------------|---------|
| **Warmth** | Care and acceptance | Individual attention |
| **Involvement** | Time and attention | Active engagement |
| **Belonging cues** | Inclusion signals | "You're part of this" |
| **Collaboration** | Peer interaction | Group work, peer feedback |

---

## Goal Theory

### Goal Orientation

| Orientation | Focus | Outcomes |
|-------------|-------|----------|
| **Mastery** | Learning, improvement | Persistence, deep processing |
| **Performance-approach** | Demonstrating competence | Can work short-term |
| **Performance-avoid** | Avoiding failure | Anxiety, shallow processing |

**Mastery orientation is generally optimal for learning.**

### SMART Goals (Enhanced)

| Element | Standard | Enhanced |
|---------|----------|----------|
| **S**pecific | Clear target | Observable behavior |
| **M**easurable | Quantifiable | Leading + lagging indicators |
| **A**chievable | Realistic | Stretch but attainable |
| **R**elevant | Connected to purpose | Aligned with values |
| **T**ime-bound | Deadline | Milestones + final |

### Goal Setting Best Practices

| Practice | Rationale |
|----------|-----------|
| Written goals | Commitment, clarity |
| Process + outcome | Balance direction and control |
| Proximal + distal | Near-term motivation, long-term direction |
| Public commitment | Social accountability |
| Implementation intentions | "If X, then Y" planning |
| Regular review | Course correction |

### Implementation Intentions

**Format**: "When [situation], I will [behavior]"

| Component | Example |
|-----------|---------|
| Situation cue | "When I sit at my desk in the morning..." |
| Desired behavior | "...I will open my coding editor first" |

**Effectiveness**: 2-3x increase in goal completion vs goals alone.

---

## Habit Formation

### Habit Loop (Duhigg/Clear)

```
        ┌─────────┐
        │   Cue   │ ← Trigger (time, location, emotion, people, prior action)
        └────┬────┘
             ↓
        ┌─────────┐
        │ Craving │ ← Motivation (anticipation of reward)
        └────┬────┘
             ↓
        ┌─────────┐
        │Response │ ← Behavior (habit itself)
        └────┬────┘
             ↓
        ┌─────────┐
        │ Reward  │ ← Satisfaction (closes the loop)
        └─────────┘
```

### Four Laws of Behavior Change (Clear)

| To Build Habit | To Break Habit |
|----------------|----------------|
| **Make it obvious** (cue) | Make it invisible |
| **Make it attractive** (craving) | Make it unattractive |
| **Make it easy** (response) | Make it difficult |
| **Make it satisfying** (reward) | Make it unsatisfying |

### Habit Formation Timeline

| Behavior Complexity | Time to Automaticity |
|--------------------|---------------------|
| Simple (drinking water) | 18-21 days |
| Moderate (exercise) | 66 days (average) |
| Complex (new skill practice) | 90-254 days |

**Key insight**: Missing once doesn't ruin habit; missing twice starts new pattern.

### Habit Stacking

**Format**: "After [current habit], I will [new habit]"

| Current Habit | New Habit |
|---------------|-----------|
| After I pour morning coffee | I will review my goals |
| After I close my laptop | I will write one sentence |
| After I sit in my car | I will listen to learning content |

### Environment Design

| Strategy | Description | Example |
|----------|-------------|---------|
| **Reduce friction** | Make desired behavior easy | Pre-set learning app |
| **Increase friction** | Make undesired behavior hard | Phone in different room |
| **Prime the environment** | Visual cues for behavior | Book on pillow |
| **Design for defaults** | Make good choice automatic | Healthy food visible |

### Keystone Habits

Habits that trigger positive cascades:

| Keystone Habit | Common Cascade |
|----------------|----------------|
| Exercise | Better eating, sleep, mood |
| Making bed | Sense of accomplishment, tidiness |
| Tracking | Awareness, improvement |
| Meditation | Focus, emotional regulation |

---

## Behavior Change Models

### Fogg Behavior Model

**B = MAP** (Behavior = Motivation × Ability × Prompt)

```
High │           ┌─────────────────┐
     │           │  Action Line    │
  M  │     ●     │                 │
  o  │   ●   ●   │   Behavior      │
  t  │ ●       ● │   Happens       │
  i  │●         ●│                 │
  v  │           └─────────────────┘
  a  │
  t  │  Behavior
  i  │  Fails
  o  │
  n  │
Low  └────────────────────────────────
     Low        Ability         High
```

**Implication**: If motivation is low, make behavior extremely easy. If ability is low, increase motivation.

### Transtheoretical Model (Stages of Change)

| Stage | Characteristics | Intervention |
|-------|-----------------|--------------|
| **Precontemplation** | Not considering change | Awareness, consequences |
| **Contemplation** | Thinking about change | Pros/cons, envision future |
| **Preparation** | Planning change | Specific plans, commitment |
| **Action** | Actively changing | Support, reinforcement |
| **Maintenance** | Sustaining change | Prevent relapse, identity |

**Key insight**: Match intervention to stage.

### COM-B Model

| Component | Description | Intervention Types |
|-----------|-------------|-------------------|
| **Capability** | Psychological and physical | Training, enablement |
| **Opportunity** | Physical and social environment | Environmental restructuring |
| **Motivation** | Reflective and automatic | Persuasion, incentivization |

**All three required for behavior change.**

### Nudge Theory

Small environmental changes that influence behavior:

| Nudge Type | Description | Example |
|------------|-------------|---------|
| **Default** | Pre-selected option | Opt-out organ donation |
| **Social proof** | Others' behavior | "Most people do X" |
| **Salience** | Make info prominent | Calorie labels |
| **Framing** | How options presented | Loss vs gain framing |
| **Priming** | Subtle environmental cues | Cleanliness → honesty |
| **Commitment** | Stated intention | Public pledges |

### Gamification Elements

| Element | Psychological Lever | Use |
|---------|--------------------|----|
| **Points** | Progress visibility | Track and reward |
| **Badges** | Achievement recognition | Milestone celebration |
| **Leaderboards** | Social comparison | Competition (use carefully) |
| **Levels** | Progression, mastery | Unlock content |
| **Challenges** | Optimal difficulty | Engagement |
| **Narrative** | Meaning, context | Story-based learning |

**Gamification risks:**
- Overjustification (intrinsic→extrinsic)
- Comparison anxiety
- Gaming the system
- Superficial engagement

**Best practice**: Gamify process, not just outcomes.
