# Marketing Psychology

Evidence-based frameworks for ethical persuasion, customer understanding, and conversion optimization.

## Table of Contents

1. [JTBD](#jtbd)
2. [Behavioral Economics](#behavioral-econ)
3. [Persuasion Science](#persuasion)
4. [Messaging Frameworks](#messaging-frameworks)
5. [Dark Patterns (Avoid)](#dark-patterns)

---

## JTBD

### Jobs-to-Be-Done Framework

**Core principle**: People don't buy products; they hire them to do jobs.

### Job Types

| Type | Description | Example |
|------|-------------|---------|
| **Functional** | Practical task | "Help me track expenses" |
| **Emotional** | How I want to feel | "Feel in control of finances" |
| **Social** | How I want to be perceived | "Appear financially responsible" |

### Job Statement Formula

**When [situation], I want to [motivation], so I can [outcome].**

| Component | Description | Example |
|-----------|-------------|---------|
| Situation | Context, trigger | "When I receive my paycheck..." |
| Motivation | What they want to do | "...I want to allocate money wisely..." |
| Outcome | Desired end state | "...so I can save for my goals" |

### Forces Diagram

```
                    Push of Current Situation
                    (Problems, frustrations)
                              │
                              ↓
┌─────────────────────────────────────────────────────────┐
│                      SWITCH                              │
└─────────────────────────────────────────────────────────┘
                              ↑
                    Pull of New Solution
                    (Benefits, aspirations)

                    ────────────────────
                           vs
                    ────────────────────

                    Anxiety of New Solution    Habit of Current Situation
                    (What could go wrong)      (Familiar, comfortable)
```

**To drive adoption**: Increase push/pull; decrease anxiety/habit.

### Interview Questions (JTBD)

| Question | Purpose |
|----------|---------|
| "Walk me through the last time you..." | Uncover actual behavior |
| "What triggered you to look for a solution?" | Identify push |
| "What did you hope would be different?" | Identify pull |
| "What concerns did you have?" | Identify anxiety |
| "What were you doing before?" | Identify habit |

---

## Behavioral Econ

### Key Principles

| Principle | Description | Application |
|-----------|-------------|-------------|
| **Loss aversion** | Losses > gains (2x) | Frame as avoiding loss |
| **Anchoring** | First number influences | Set reference points |
| **Framing** | Context changes perception | Positive framing |
| **Status quo bias** | Prefer current state | Default to desired option |
| **Endowment effect** | Overvalue what we own | Free trials, ownership |
| **Scarcity** | Rare = valuable | Limited availability |
| **Social proof** | Follow others | Show popularity |
| **Reciprocity** | Return favors | Give value first |
| **Commitment** | Consistency with past | Small steps first |
| **Authority** | Trust experts | Credentials, endorsements |

### Prospect Theory (Kahneman & Tversky)

```
     Value
       │
       │    Gains
       │    ╱
       │   ╱
       │  ╱
───────┼──────────── Reference Point
       │╲
       │ ╲
       │  ╲
       │   ╲ Losses (steeper)
       │
```

**Implications:**
1. People evaluate outcomes relative to reference point
2. Loss curve is steeper than gain curve
3. Diminishing sensitivity to both gains and losses

### Choice Architecture

| Element | Description | Example |
|---------|-------------|---------|
| **Defaults** | Pre-selected options | Opt-in vs opt-out |
| **Number of options** | Paradox of choice | 3-5 options optimal |
| **Order** | First/last bias | Position featured option |
| **Decoy** | Asymmetric dominance | Make target option look better |
| **Partitioning** | Break into categories | Organize by use case |

### Mental Accounting

People treat money differently based on mental categories:

| Account | Behavior | Application |
|---------|----------|-------------|
| Windfall gains | Spend more freely | "Use your bonus on..." |
| Budgeted funds | Spend within limits | "Fits in your X budget" |
| Pain of paying | Reduces pleasure | Pre-payment, bundling |

---

## Persuasion

### Cialdini's Principles (Updated)

| Principle | Mechanism | Ethical Application |
|-----------|-----------|---------------------|
| **Reciprocity** | Give before asking | Free value, content, trials |
| **Commitment** | Consistency drive | Small steps, public commitment |
| **Social Proof** | Follow the crowd | Testimonials, numbers, reviews |
| **Authority** | Trust experts | Credentials, research, media |
| **Liking** | Buy from friends | Relatability, similarity, humor |
| **Scarcity** | Want rare things | True limitations, exclusivity |
| **Unity** | In-group belonging | Shared identity, "we" language |

### Elaboration Likelihood Model

| Route | Conditions | Persuasion Strategy |
|-------|------------|---------------------|
| **Central** | High motivation + ability | Strong arguments, evidence |
| **Peripheral** | Low motivation or ability | Cues, heuristics, source credibility |

**Implication**: Match approach to audience engagement level.

### Narrative Persuasion

Stories persuade through:

| Mechanism | Description | Application |
|-----------|-------------|-------------|
| **Transportation** | Immersion in story | Reduce counterarguing |
| **Identification** | Connect with character | Customer-as-hero stories |
| **Emotion** | Affective engagement | Emotional arcs |
| **Modeling** | Behavioral examples | Show transformation |

### Trust Signals

| Signal | Purpose | Example |
|--------|---------|---------|
| **Social proof** | Others trust us | Reviews, testimonials, logos |
| **Authority** | Experts endorse us | Certifications, press, awards |
| **Risk reversal** | Nothing to lose | Guarantees, free trials |
| **Transparency** | Nothing hidden | Pricing, policies, team |
| **Consistency** | Reliable experience | Brand, design, messaging |

---

## Messaging Frameworks

### PAS (Problem-Agitate-Solution)

| Stage | Purpose | Example |
|-------|---------|---------|
| **Problem** | Identify pain point | "Struggling to remember what you learn?" |
| **Agitate** | Amplify the problem | "You spend hours studying, only to forget it all" |
| **Solution** | Present your answer | "Spaced repetition makes learning stick" |

### AIDA

| Stage | Goal | Tactics |
|-------|------|---------|
| **Attention** | Get noticed | Headlines, visuals, hooks |
| **Interest** | Engage | Benefits, relevance, curiosity |
| **Desire** | Create want | Social proof, transformation |
| **Action** | Get conversion | CTA, urgency, risk reversal |

### Before-After-Bridge

| Stage | Content |
|-------|---------|
| **Before** | Current painful state |
| **After** | Desired future state |
| **Bridge** | How your solution gets them there |

### StoryBrand (Miller)

| Element | Description | Example |
|---------|-------------|---------|
| **Character** | Customer is hero | "You want to..." |
| **Problem** | External, internal, philosophical | What's blocking them |
| **Guide** | You as mentor | Authority + empathy |
| **Plan** | Clear steps | "3 simple steps" |
| **Call to Action** | Direct ask | "Start free trial" |
| **Success** | Transformation | Happy ending |
| **Failure** | Stakes | What happens if they don't act |

### Messaging Hierarchy

| Level | Content | Purpose |
|-------|---------|---------|
| 1 | **Primary promise** | What you do for them |
| 2 | **Proof points** | Why believe it |
| 3 | **Differentiators** | Why choose you |
| 4 | **Risk reducers** | Why act now |

---

## Dark Patterns

### Patterns to AVOID

| Pattern | Description | Why Unethical |
|---------|-------------|---------------|
| **Forced continuity** | Auto-renew without clear notice | Deceptive |
| **Roach motel** | Easy to sign up, hard to cancel | Trapping |
| **Hidden costs** | Surprise fees at checkout | Deceptive |
| **Confirmshaming** | Guilt-trip for declining | Manipulative |
| **Disguised ads** | Ads that look like content | Deceptive |
| **Trick questions** | Confusing opt-in/out language | Manipulative |
| **Bait and switch** | Promise one thing, deliver another | Deceptive |
| **Friend spam** | Post without clear consent | Violates trust |
| **Privacy zuckering** | Confusing privacy settings | Exploitative |
| **Misdirection** | Distract from important info | Deceptive |

### Ethical Checklist

Before any persuasion tactic:

| Question | Required Answer |
|----------|-----------------|
| Is this transparent? | Yes |
| Does this provide genuine value? | Yes |
| Would I want this done to me? | Yes |
| Does user have informed choice? | Yes |
| Could this harm vulnerable users? | No |
| Is the scarcity/urgency real? | Yes |
| Are we overselling or misleading? | No |

### Ethical Persuasion Alternatives

| Dark Pattern | Ethical Alternative |
|--------------|---------------------|
| Fake urgency | Genuine limited-time offers |
| Hidden costs | Transparent pricing |
| Confirmshaming | Neutral decline options |
| Forced continuity | Easy cancellation + reminder |
| Privacy exploitation | Clear, simple privacy controls |
| Manipulative defaults | User-beneficial defaults |

---

## Segmentation Psychology

### Psychographic Segmentation

| Dimension | Description | Application |
|-----------|-------------|-------------|
| **Values** | What matters most | Align messaging |
| **Lifestyle** | How they live | Context relevance |
| **Personality** | Traits and tendencies | Tone and approach |
| **Attitudes** | Beliefs about category | Objection handling |
| **Motivations** | Why they buy | Benefit emphasis |

### Buyer Psychology Types

| Type | Characteristics | Appeal |
|------|-----------------|--------|
| **Analytical** | Research-heavy, detail-oriented | Data, comparisons, specs |
| **Driver** | Results-focused, decisive | Efficiency, outcomes |
| **Expressive** | Relationship-focused, emotional | Stories, vision, connection |
| **Amiable** | Consensus-seeking, risk-averse | Testimonials, guarantees |

### Customer Journey Psychology

| Stage | Mental State | Psychological Need |
|-------|--------------|-------------------|
| **Awareness** | Problem recognition | Validation, clarity |
| **Consideration** | Solution evaluation | Trust, comparison help |
| **Decision** | Purchase choice | Risk reduction, confidence |
| **Retention** | Post-purchase | Confirmation, support |
| **Advocacy** | Sharing | Recognition, belonging |
