# Learning & Developmental Psychology

Comprehensive guide to age-appropriate learning design based on cognitive science, developmental psychology, and educational research.

## Table of Contents

1. [Universal Learning Principles](#universal-learning-principles)
2. [Memory Systems](#memory-systems)
3. [Age-Specific Development](#age-specific-development)
4. [Cognitive Load Theory](#cognitive-load-theory)
5. [Learning Transfer](#learning-transfer)

---

## Universal Learning Principles

These principles apply across all ages with age-appropriate modifications.

### The Big Six (Evidence-Based)

| Principle | Mechanism | Application |
|-----------|-----------|-------------|
| **Spacing** | Distributed practice strengthens retrieval pathways | Short sessions over days > cramming |
| **Retrieval Practice** | Testing strengthens memory more than re-reading | Quiz yourself, not just review |
| **Interleaving** | Mixing topics improves discrimination | Alternate related skills |
| **Elaboration** | Connecting to prior knowledge deepens encoding | Ask "how" and "why" |
| **Concrete Examples** | Abstract→concrete→abstract cycle | Start with specific instances |
| **Dual Coding** | Verbal + visual encoding strengthens memory | Combine words with diagrams |

### Desirable Difficulties

Counterintuitive: making learning harder improves retention.

| Difficulty | Why It Works | Implementation |
|------------|--------------|----------------|
| Spacing gaps | Forces reconstruction | Increase intervals progressively |
| Interleaving | Requires discrimination | Mix problem types |
| Generation | Active > passive | Produce before consuming |
| Variation | Builds flexible knowledge | Change contexts and examples |

**Caution**: Only effective when learner can succeed ~80% of time. Excessive difficulty causes disengagement.

---

## Memory Systems

### Working Memory

- **Capacity**: 4±1 chunks (Miller's law revised)
- **Duration**: ~20 seconds without rehearsal
- **Bottleneck**: Primary constraint on learning rate

**Optimization Strategies:**
1. Chunk information (group related items)
2. Reduce extraneous load (clear instructions)
3. Build schemas (organized knowledge structures)
4. Automate basics (free capacity for complex tasks)

### Long-Term Memory

| Type | Description | Example | Encoding Strategy |
|------|-------------|---------|-------------------|
| **Episodic** | Personal experiences | "When I debugged that error" | Emotional engagement, context |
| **Semantic** | Facts and concepts | "Arrays are zero-indexed" | Elaboration, connection |
| **Procedural** | How to do things | Typing, riding a bike | Repetition with feedback |

### Encoding Specificity

Memory retrieval is context-dependent:
- **State-dependent**: Learn in similar mental state to test
- **Context-dependent**: Environmental cues aid recall
- **Mood-congruent**: Emotional state affects retrieval

**Implication**: Practice in varied contexts for robust learning.

### Forgetting Curve (Ebbinghaus)

Without review, retention drops rapidly:
- 1 hour: ~55% retained
- 1 day: ~33% retained
- 1 week: ~25% retained
- 1 month: ~21% retained

**Spacing Schedule (Optimal Review Intervals):**

| Review # | Interval | Cumulative |
|----------|----------|------------|
| 1 | 1 day | Day 1 |
| 2 | 3 days | Day 4 |
| 3 | 7 days | Day 11 |
| 4 | 14 days | Day 25 |
| 5 | 30 days | Day 55 |

---

## Age-Specific Development

### Ages 3-6: Early Childhood

**Cognitive Stage**: Preoperational (Piaget)
- Symbolic thinking emerges
- Egocentric perspective
- Limited logical reasoning
- Magical thinking common

**Learning Characteristics:**
| Strength | Limitation | Design Implication |
|----------|------------|-------------------|
| High neuroplasticity | Short attention (~2-5 min/year age) | Micro-sessions |
| Language acquisition window | Abstract concepts difficult | Concrete, sensory |
| Play-based motivation | Limited metacognition | External structure |
| Imitation learning | Can't separate fantasy/reality | Stories, role-play |

**Recommended Approaches:**
- **Session length**: 10-20 minutes maximum
- **Method**: Multisensory, movement-based, narrative-embedded
- **Practice**: High repetition with variation (songs, games)
- **Feedback**: Immediate, positive, process-focused
- **Support**: Adult scaffolding essential; gradual release

**Language Learning (Critical Period):**
- Phoneme discrimination peaks at 6-8 months
- Grammar acquisition most efficient before age 7
- Accent acquisition best before age 12
- Immersion and consistent exposure most effective

### Ages 7-12: Middle Childhood

**Cognitive Stage**: Concrete Operational (Piaget)
- Logical thinking with concrete objects
- Conservation understanding
- Classification and seriation
- Declining egocentrism

**Learning Characteristics:**
| Strength | Limitation | Design Implication |
|----------|------------|-------------------|
| Growing working memory | Abstract still challenging | Concrete→abstract bridge |
| Metacognition emerging | Self-regulation developing | Explicit strategy teaching |
| Peer influence growing | Comparison sensitivity | Mastery over performance goals |
| Intrinsic curiosity high | Attention still limited | Varied, engaging activities |

**Recommended Approaches:**
- **Session length**: 20-40 minutes with breaks
- **Method**: Guided discovery, visual aids, hands-on practice
- **Practice**: Deliberate practice with clear criteria; gamification effective
- **Feedback**: Specific, effort-focused, growth mindset framing
- **Support**: Gradual release of responsibility; peer collaboration

**Skill Acquisition Tips:**
- **Coding**: Visual programming (Scratch), immediate feedback, project-based
- **Math**: Manipulatives→pictures→symbols progression
- **Languages**: Structured input, games, music, limited grammar focus

### Ages 13-17: Adolescence

**Cognitive Stage**: Formal Operational (emerging)
- Abstract reasoning developing
- Hypothetical thinking
- Metacognition maturing
- Identity formation central

**Neurological Context:**
- Prefrontal cortex still developing (executive function)
- Limbic system highly active (emotional intensity)
- Dopamine sensitivity heightened (reward-seeking)
- Sleep phase delayed (circadian shift)

**Learning Characteristics:**
| Strength | Limitation | Design Implication |
|----------|------------|-------------------|
| Abstract capability growing | Emotional volatility | Relevance and autonomy |
| Identity exploration | Risk-taking tendency | Safe failure environments |
| Peer influence peaks | Authority resistance | Peer learning structures |
| Future orientation emerging | Present bias still strong | Near-term milestones |

**Recommended Approaches:**
- **Session length**: 45-90 minutes with autonomy
- **Method**: Project-based, real-world applications, choice in approach
- **Practice**: Self-directed with checkpoints; mastery-based progression
- **Feedback**: Peer feedback valued; specific and actionable
- **Support**: Coach/mentor role; respect autonomy while providing structure

**Motivation Keys:**
1. **Autonomy**: Choice in how, when, what to learn
2. **Relevance**: Clear connection to goals and identity
3. **Mastery**: Visible progress and competence building
4. **Belonging**: Peer community and social learning

### Ages 18-25: Emerging Adulthood

**Cognitive Stage**: Post-formal (Perry, King & Kitchener)
- Dialectical thinking
- Contextual relativism
- Peak processing speed
- Crystallized intelligence growing

**Learning Characteristics:**
| Strength | Limitation | Design Implication |
|----------|------------|-------------------|
| Peak working memory | Overconfidence possible | Challenge with support |
| Self-directed capable | Competing priorities | Efficiency-focused |
| Abstract mastery | May lack experience base | Theory + application |
| Identity consolidating | Decision paralysis | Clear pathways |

**Recommended Approaches:**
- **Session length**: Flexible; deep work blocks (90-120 min)
- **Method**: Deliberate practice, expert modeling, case studies
- **Practice**: At edge of ability; immediate application
- **Feedback**: Expert feedback highly valued; peer critique
- **Support**: Mentorship, clear criteria, resource access

**Expertise Development:**
- 10,000 hours myth: Quality > quantity
- Deliberate practice requirements:
  1. Specific goals
  2. Full concentration
  3. Immediate feedback
  4. Repetition with refinement

### Ages 26-64: Adulthood

**Cognitive Context:**
- Processing speed gradual decline (~1%/year after 30)
- Crystallized intelligence grows
- Working memory slight decline
- Expertise effects dominate

**Learning Characteristics:**
| Strength | Limitation | Design Implication |
|----------|------------|-------------------|
| Rich prior knowledge | Interference effects | Connect to existing schemas |
| Clear goals usually | Time constraints | Efficiency paramount |
| Self-directed | May have fixed mindset | Growth mindset cultivation |
| Application focus | Patience for basics lower | Skip to application ASAP |

**Recommended Approaches:**
- **Session length**: 30-60 minutes; micro-learning for busy schedules
- **Method**: Problem-centered, immediate utility, leveraging experience
- **Practice**: Spaced, integrated into work; just-in-time learning
- **Feedback**: Self-assessment tools; peer networks
- **Support**: Respect autonomy; remove barriers; flexible pacing

**Andragogy Principles (Knowles):**
1. Self-concept: Adult learners are self-directing
2. Experience: Rich resource for learning
3. Readiness: Learn when relevant to life tasks
4. Orientation: Problem-centered, not subject-centered
5. Motivation: Internal drivers predominate

### Ages 65+: Older Adulthood

**Cognitive Context:**
- Processing speed continues decline
- Working memory more limited
- Crystallized intelligence maintained/growing
- Wisdom and pattern recognition peak

**Learning Characteristics:**
| Strength | Limitation | Design Implication |
|----------|------------|-------------------|
| Deep expertise | Speed/memory constraints | Leverage knowledge |
| Patience/persistence | Anxiety about ability | Confidence building |
| Intrinsic motivation | Sensory changes | Multimodal, clear |
| Wisdom/judgment | Technology barriers possible | Appropriate scaffolding |

**Recommended Approaches:**
- **Session length**: 20-45 minutes; more frequent breaks
- **Method**: Multimodal, self-paced, reduced time pressure
- **Practice**: Overlearning beneficial; distributed practice essential
- **Feedback**: Positive, patient, progress-focused
- **Support**: Explicit instruction; reduce cognitive load; social learning

**Compensation Strategies:**
- External memory aids (notes, checklists)
- Environmental support (reduce distractions)
- Expertise leverage (connect to known domains)
- Pacing control (self-regulated speed)

---

## Cognitive Load Theory

### Load Types

| Type | Definition | Management |
|------|------------|------------|
| **Intrinsic** | Inherent complexity of material | Sequence from simple to complex |
| **Extraneous** | Unnecessary cognitive demands | Eliminate; clear design |
| **Germane** | Effort toward schema construction | Maximize; productive struggle |

### Design Principles

1. **Worked Example Effect**: Show solved examples before practice
2. **Split Attention Effect**: Integrate related info spatially/temporally
3. **Redundancy Effect**: Remove unnecessary duplication
4. **Modality Effect**: Use audio + visual (not text + text)
5. **Element Interactivity**: High interactivity = simplify first

### Expertise Reversal

Techniques effective for novices can harm experts:
- Worked examples: Help novices, slow experts
- Guidance: Essential for novices, constraining for experts

**Implication**: Fade scaffolding as expertise grows.

---

## Learning Transfer

### Transfer Types

| Type | Description | Likelihood |
|------|-------------|------------|
| **Near** | Similar contexts | High |
| **Far** | Different contexts | Low without design |
| **Positive** | Prior learning helps | Depends on similarity |
| **Negative** | Prior learning interferes | Watch for misconceptions |

### Promoting Transfer

1. **Multiple contexts**: Practice in varied settings
2. **Abstract principles**: Extract underlying rules
3. **Comparison**: Explicitly compare cases
4. **Metacognition**: Reflect on when/how to apply
5. **Hugging**: Practice close to target context
6. **Bridging**: Explicitly connect domains

### Common Transfer Barriers

- Surface similarity focus (missing deep structure)
- Context-bound encoding
- Inert knowledge (known but not accessed)
- Fixed mindset about intelligence
