# Emotional Intelligence

Frameworks for understanding, managing, and designing for emotions.

## Table of Contents

1. [EQ Framework](#eq-framework)
2. [Emotional Regulation](#emotional-regulation)
3. [Empathy Design](#empathy-design)
4. [Emotions in Decision-Making](#emotions-in-decision-making)
5. [Emotional Triggers](#emotional-triggers)

---

## EQ Framework

### Goleman's Five Components

| Component | Description | Application |
|-----------|-------------|-------------|
| **Self-Awareness** | Recognizing own emotions | Honest self-assessment |
| **Self-Regulation** | Managing emotions and impulses | Thoughtful responses |
| **Motivation** | Internal drive beyond rewards | Persistence, optimism |
| **Empathy** | Understanding others' emotions | Customer understanding |
| **Social Skills** | Managing relationships | Communication, influence |

### EQ in Business Contexts

| Context | EQ Application |
|---------|----------------|
| Leadership | Inspire, motivate, navigate conflict |
| Sales | Read customer emotions, build rapport |
| Customer service | De-escalation, empathy, resolution |
| Marketing | Emotional resonance, authenticity |
| Product design | User emotional journey |

### Developing EQ

| Component | Development Strategy |
|-----------|---------------------|
| Self-awareness | Reflection, feedback, journaling |
| Self-regulation | Pause before reacting, stress management |
| Motivation | Goal clarity, intrinsic rewards focus |
| Empathy | Active listening, perspective-taking |
| Social skills | Practice, feedback, observation |

---

## Emotional Regulation

### Strategies (Gross Model)

| Strategy | Timing | Description | Effectiveness |
|----------|--------|-------------|---------------|
| **Situation selection** | Early | Avoid/approach situations | High (preventive) |
| **Situation modification** | Early | Change the situation | High |
| **Attention deployment** | Middle | Focus on different aspects | Medium |
| **Cognitive reappraisal** | Middle | Reframe meaning | High (sustainable) |
| **Response modulation** | Late | Suppress/express | Low (costly) |

### Reappraisal Techniques

| Technique | Description | Example |
|-----------|-------------|---------|
| **Reframing** | Change interpretation | "Challenge, not threat" |
| **Distancing** | Psychological distance | "How will I view this in 5 years?" |
| **Normalizing** | Common experience | "Everyone struggles with this" |
| **Benefit finding** | Find positive | "What can I learn?" |
| **Acceptance** | Allow without judgment | "This is uncomfortable, and that's okay" |

### Emotional Granularity

More specific emotion labels = better regulation:

| Vague | Granular |
|-------|----------|
| Bad | Frustrated, disappointed, anxious, sad |
| Good | Excited, content, proud, grateful |
| Angry | Irritated, resentful, indignant, furious |

**Application**: Design feedback systems with nuanced emotion options.

---

## Empathy Design

### Types of Empathy

| Type | Description | Design Application |
|------|-------------|-------------------|
| **Cognitive** | Understanding perspective | User research, personas |
| **Emotional** | Feeling with someone | Emotional journey mapping |
| **Compassionate** | Understanding + action | Solution design |

### Empathy Mapping

| Quadrant | Question |
|----------|----------|
| **Says** | What do they say out loud? |
| **Thinks** | What might they be thinking? |
| **Does** | What actions do they take? |
| **Feels** | What emotions are present? |

### Emotional Journey Mapping

| Stage | Emotional State | Design Response |
|-------|-----------------|-----------------|
| Awareness | Curious/skeptical | Intrigue, credibility |
| Consideration | Interest/anxiety | Value, reassurance |
| Decision | Excited/fearful | Confidence, simplicity |
| Onboarding | Hopeful/confused | Clarity, quick wins |
| Usage | Satisfied/frustrated | Support, delight |
| Loyalty | Connected/indifferent | Recognition, community |

### Designing for Emotional States

| User State | Design Need |
|------------|-------------|
| **Stressed** | Calm, clear, no complexity |
| **Confused** | Simple, guided, supportive |
| **Frustrated** | Acknowledge, help, escalation path |
| **Excited** | Channel energy, clear next steps |
| **Anxious** | Reassurance, control, transparency |
| **Bored** | Engagement, variety, gamification |

---

## Emotions in Decision-Making

### Affect Heuristic

Feelings guide judgments before logic:

| If Feeling | Then Judgment |
|------------|---------------|
| Positive affect | Lower risk, higher benefit |
| Negative affect | Higher risk, lower benefit |

**Implication**: First impression emotional tone shapes all subsequent evaluation.

### Somatic Markers (Damasio)

Body signals guide decisions:
- Gut feelings are processed experience
- Damage to emotional brain impairs decisions
- Pure rationality is insufficient

**Application**: Design experiences that feel right, not just logical.

### Hot vs Cold States

| State | Decision Quality | Design Response |
|-------|------------------|-----------------|
| **Hot** (emotional) | Impulsive, present-focused | Cooling-off periods, reminders |
| **Cold** (rational) | Planned, future-focused | Standard decision support |

### Emotional Influences on Buying

| Emotion | Buying Behavior | Ethical Consideration |
|---------|-----------------|----------------------|
| Fear | Impulsive safety purchases | Don't exploit |
| Joy | Celebratory spending | Appropriate occasions |
| Sadness | Comfort purchases | Don't exploit |
| Anger | Impulsive, revenge spending | Don't trigger |
| Guilt | Compensatory purchases | Don't manipulate |

---

## Emotional Triggers

### Plutchik's Emotion Wheel

Core emotions and their opposites:

| Emotion | Opposite | Combined = |
|---------|----------|------------|
| Joy | Sadness | Sentimentality (joy + sadness) |
| Trust | Disgust | Submission (trust + fear) |
| Fear | Anger | Awe (fear + surprise) |
| Surprise | Anticipation | Disappointment (surprise + sadness) |

### Positive Emotion Triggers

| Trigger | Emotion | Application |
|---------|---------|-------------|
| Accomplishment | Pride | Progress, milestones |
| Connection | Belonging | Community, shared identity |
| Novelty | Excitement | New features, updates |
| Understanding | Satisfaction | Clear explanations |
| Recognition | Validation | Personalization, acknowledgment |
| Control | Confidence | Options, customization |

### Negative Emotion Management

| Emotion | Trigger | Prevention |
|---------|---------|------------|
| Frustration | Blocked goals | Clear paths, help |
| Anxiety | Uncertainty | Transparency, progress |
| Disappointment | Unmet expectations | Accurate promises |
| Regret | Poor decisions | Good guidance, undo |
| Anger | Perceived unfairness | Fair policies, explanation |

### Emotional Contagion

Emotions spread through:
- Facial expressions
- Tone of voice
- Written language
- Visual design

**Application**: Positive brand voice creates positive user emotions.

---

## Measuring Emotions

### Self-Report Methods

| Method | Best For |
|--------|----------|
| Single-item scales | Quick pulse checks |
| PANAS (Positive/Negative Affect) | Comprehensive assessment |
| Emotion wheels | Granular identification |
| Semantic differential | Detailed attribute rating |

### Behavioral Indicators

| Behavior | Possible Emotion |
|----------|------------------|
| Rapid clicking/scrolling | Frustration, impatience |
| Abandonment | Confusion, frustration |
| Return visits | Interest, consideration |
| Sharing | Delight, trust |
| Support contact | Frustration (usually) |

### Physiological Measures

| Measure | Indicates |
|---------|-----------|
| Heart rate variability | Stress, arousal |
| Skin conductance | Emotional intensity |
| Facial expression | Specific emotions |
| Eye tracking | Attention, interest |

**Note**: Use ethically with consent; focus on improving experience.
