# Customer Psychology

Deep understanding of customer behavior, decision-making, and experience design.

## Table of Contents

1. [Decision-Making Process](#decision-making-process)
2. [Customer Emotions](#customer-emotions)
3. [Experience Psychology](#experience-psychology)
4. [Loyalty Psychology](#loyalty-psychology)
5. [Segment Psychology](#segment-psychology)

---

## Decision-Making Process

### Consumer Decision Journey

```
    ┌─────────────────────────────────────────────────┐
    │                LOYALTY LOOP                      │
    │        (Skip to consideration/purchase)         │
    │                                                 │
    │   ┌─────────┐    ┌─────────┐    ┌─────────┐   │
    │   │ Trigger │───→│Consider │───→│Evaluate │   │
    │   └─────────┘    └─────────┘    └────┬────┘   │
    │                                       │        │
    │                                       ↓        │
    │   ┌─────────┐    ┌─────────┐    ┌─────────┐   │
    │   │ Advocate│←───│Experience│←───│Purchase │   │
    │   └─────────┘    └─────────┘    └─────────┘   │
    │        │                                       │
    │        └───────────────────────────────────────┘
    │
    └─────────────────────────────────────────────────┘
```

### Trigger Types

| Type | Description | Marketing Response |
|------|-------------|-------------------|
| **Problem** | Pain point emerges | Problem awareness content |
| **Aspiration** | Goal or desire | Vision and transformation |
| **Life change** | Circumstances shift | Timely targeting |
| **Social** | Others' influence | Referral, social proof |
| **Marketing** | Exposure to message | Top-of-funnel campaigns |

### Consideration Set

How brands enter (and stay in) consideration:

| Factor | Description | Optimization |
|--------|-------------|--------------|
| **Awareness** | Know brand exists | Reach, frequency |
| **Relevance** | Fits the job | Positioning, targeting |
| **Familiarity** | Comfortable with brand | Consistency, exposure |
| **Salience** | Top of mind | Distinctive assets |

### Evaluation Criteria

| Criterion Type | Examples | Content Needs |
|----------------|----------|---------------|
| **Functional** | Features, performance | Specs, comparisons |
| **Experiential** | How it feels to use | Demos, trials, reviews |
| **Social** | What others think | Testimonials, UGC |
| **Financial** | Value for money | Pricing, ROI calculators |

---

## Customer Emotions

### Emotion in Decision-Making

**Somatic marker hypothesis**: Emotions guide decisions before logic.

| Role | Description | Implication |
|------|-------------|-------------|
| **Attention** | Emotion captures focus | Emotional hooks work |
| **Memory** | Emotional events remembered | Create emotional moments |
| **Preference** | Feelings inform choice | Brand affect matters |
| **Action** | Emotion drives behavior | Motivate with emotion |

### Key Customer Emotions

| Emotion | Trigger | Marketing Application |
|---------|---------|----------------------|
| **Trust** | Reliability, transparency | Consistency, reviews |
| **Anticipation** | Expectation of good | Pre-launch, teasers |
| **Joy** | Delight, surprise | Exceed expectations |
| **Fear** | Risk, uncertainty | Acknowledge and address |
| **Anger** | Frustration, injustice | Responsive support |
| **Belonging** | Community, inclusion | Tribe building |
| **Pride** | Achievement, status | Recognition, exclusivity |

### Emotional Journey Mapping

| Stage | Typical Emotions | Design Response |
|-------|------------------|-----------------|
| **Awareness** | Curiosity, skepticism | Intrigue, credibility |
| **Consideration** | Interest, anxiety | Value, reassurance |
| **Purchase** | Excitement, doubt | Confidence, simplicity |
| **Onboarding** | Hope, confusion | Clarity, quick wins |
| **Usage** | Satisfaction, frustration | Support, guidance |
| **Advocacy** | Pride, gratitude | Recognition, rewards |

### Peak-End Rule (Kahneman)

Experience judged by **peak moment** + **ending**, not average.

| Implication | Application |
|-------------|-------------|
| Create positive peaks | Surprise and delight moments |
| End on high note | Exceptional off-boarding |
| Manage negative peaks | Swift recovery from failures |
| Compress negatives | Get pain over quickly |

---

## Experience Psychology

### Expectation Management

**Satisfaction = Perception - Expectation**

| Strategy | Description |
|----------|-------------|
| **Underpromise, overdeliver** | Set achievable expectations, exceed them |
| **Set clear expectations** | Transparency about what to expect |
| **Manage wait psychology** | Occupied time feels shorter |
| **Progress indicators** | Uncertainty reduction |

### Waiting Psychology

| Principle | Description |
|-----------|-------------|
| **Occupied time feels shorter** | Engage during waits |
| **Anxiety makes waits longer** | Reduce uncertainty |
| **Uncertain waits feel longer** | Provide time estimates |
| **Explained waits feel shorter** | Tell them why |
| **Unfair waits feel longer** | Demonstrate fairness |
| **Solo waits feel longer** | Social engagement helps |

### Effort Paradox

Sometimes more effort = more value:

| Effect | Description | Application |
|--------|-------------|-------------|
| **IKEA effect** | We value what we build | Customization, participation |
| **Effort heuristic** | More effort = more quality | Show the work |
| **Labor illusion** | Visible effort increases value | Display processing |

### Choice Paradox

| # of Options | Effect |
|--------------|--------|
| 1 | No agency, resentment possible |
| 2-3 | Clear decision, confident |
| 4-6 | Manageable, slight overwhelm |
| 7+ | Paralysis, regret, dissatisfaction |

**Solution**: Curate, categorize, recommend.

---

## Loyalty Psychology

### Loyalty Drivers

| Driver | Description | Cultivation |
|--------|-------------|-------------|
| **Satisfaction** | Met expectations | Quality, reliability |
| **Switching costs** | Effort to change | Integration, data |
| **Emotional bond** | Affective attachment | Brand personality |
| **Identity** | Self-concept alignment | Community, values |
| **Habit** | Automatic behavior | Routine integration |

### Loyalty Types

| Type | Basis | Durability |
|------|-------|------------|
| **Behavioral** | Repeat purchase | Low (convenience) |
| **Attitudinal** | Positive feelings | Medium (preference) |
| **Cognitive** | Conscious choice | Medium-High (decision) |
| **Action** | Commitment despite obstacles | High (true loyalty) |

### Customer Lifecycle Value

| Stage | Psychology | Strategy |
|-------|------------|----------|
| **Acquisition** | First impression | Exceed expectations |
| **Activation** | First value | Quick win, aha moment |
| **Retention** | Continued value | Habit, engagement |
| **Revenue** | Expanded value | Cross-sell, upsell |
| **Referral** | Advocacy | Recognition, rewards |

### Churn Psychology

Why customers leave:

| Reason | Psychology | Prevention |
|--------|------------|------------|
| **Failure** | Unmet expectations | Quality, support |
| **Alternative** | Better option appeared | Differentiation |
| **Neglect** | Forgot value | Engagement, reminders |
| **Life change** | Circumstances changed | Adapt offering |
| **Relationship** | Poor experience | Service recovery |

### Win-Back Psychology

| Timing | Approach |
|--------|----------|
| **Immediate** (0-30 days) | Understand why, address issue |
| **Recent** (30-90 days) | Remind of value, incentivize |
| **Lapsed** (90-365 days) | What's new, fresh start |
| **Long-term** (365+ days) | Re-introduction, strong offer |

---

## Segment Psychology

### Adoption Curve Psychology

| Segment | Characteristics | Appeal |
|---------|-----------------|--------|
| **Innovators** (2.5%) | Risk-tolerant, curious | New, exclusive, first |
| **Early Adopters** (13.5%) | Opinion leaders, vision | Transformation, status |
| **Early Majority** (34%) | Pragmatic, deliberate | Proof, reliability |
| **Late Majority** (34%) | Skeptical, conservative | Standards, low risk |
| **Laggards** (16%) | Traditional, resistant | Necessity, no choice |

### Generational Considerations

| Generation | Key Values | Communication |
|------------|------------|---------------|
| **Gen Z** (1997-2012) | Authenticity, diversity, digital native | Visual, short-form, values-driven |
| **Millennials** (1981-1996) | Experience, purpose, flexibility | Mobile, social proof, convenience |
| **Gen X** (1965-1980) | Independence, skepticism, work-life | Direct, value-focused, email |
| **Boomers** (1946-1964) | Quality, loyalty, expertise | Detailed, phone/email, respect |

**Caution**: Avoid stereotyping; these are tendencies, not rules.

### B2B Psychology

| Difference | Implication |
|------------|-------------|
| **Multiple stakeholders** | Address each persona |
| **Longer cycles** | Nurture over time |
| **Higher stakes** | Risk mitigation crucial |
| **Rational justification** | Logic + emotion |
| **Relationship-heavy** | Trust-building essential |

### B2B Buying Committee

| Role | Psychology | Content Needs |
|------|------------|---------------|
| **Champion** | Advocates internally | Ammunition, support |
| **Decision Maker** | Approves budget | ROI, strategic fit |
| **Influencer** | Shapes opinion | Expertise, peer validation |
| **User** | Uses daily | Usability, support |
| **Blocker** | Raises objections | Risk mitigation |

---

## Research Methods

### Qualitative Methods

| Method | Use Case | Insights |
|--------|----------|----------|
| **Interviews** | Deep understanding | Motivations, pain points |
| **Focus groups** | Group dynamics | Social influence, language |
| **Usability testing** | Behavior observation | Friction, confusion |
| **Diary studies** | Longitudinal behavior | Context, habits |
| **Ethnography** | Natural context | Unspoken behaviors |

### Quantitative Methods

| Method | Use Case | Insights |
|--------|----------|----------|
| **Surveys** | Broad patterns | Attitudes, preferences |
| **A/B testing** | Behavior causation | What works |
| **Analytics** | Actual behavior | What people do |
| **Cohort analysis** | Segment patterns | Lifecycle insights |
| **NPS/CSAT** | Satisfaction tracking | Health metrics |

### Jobs-to-Be-Done Interview Questions

| Question | Purpose |
|----------|---------|
| "Walk me through the last time you..." | Actual behavior |
| "What triggered you to look for a solution?" | Push factors |
| "What did you hope would change?" | Pull factors |
| "What concerns did you have?" | Anxieties |
| "What would have made this easier?" | Friction |
