# Creativity Psychology

Understanding and fostering creative thinking and innovation.

## Table of Contents

1. [Creative Cognition](#creative-cognition)
2. [Creative Process](#creative-process)
3. [Environmental Factors](#environmental-factors)
4. [Techniques & Methods](#techniques--methods)
5. [Blocks & Barriers](#blocks--barriers)

---

## Creative Cognition

### Divergent vs Convergent Thinking

| Type | Description | When to Use |
|------|-------------|-------------|
| **Divergent** | Generate many ideas | Ideation, brainstorming |
| **Convergent** | Evaluate and select | Decision, refinement |

### Components of Creativity

| Component | Description | Development |
|-----------|-------------|-------------|
| **Fluency** | Number of ideas | Practice generation |
| **Flexibility** | Variety of categories | Cross-domain exposure |
| **Originality** | Uniqueness | Challenge assumptions |
| **Elaboration** | Detail and development | Build on ideas |

### Creative Thinking Modes

| Mode | Brain State | Characterized By |
|------|-------------|------------------|
| **Focused** | Task-positive network | Deliberate, analytical |
| **Diffuse** | Default mode network | Associative, wandering |
| **Flow** | Balanced networks | Effortless, absorbed |

### Incubation Effect

Stepping away from a problem leads to insight:

| Phase | Duration | Activity |
|-------|----------|----------|
| Preparation | Variable | Deep engagement with problem |
| Incubation | Minutes to days | Unrelated activity |
| Illumination | Sudden | Insight appears |
| Verification | Variable | Test and refine |

---

## Creative Process

### Wallas Model

| Stage | Description | Tips |
|-------|-------------|------|
| **Preparation** | Gather information, immerse | Deep research, diverse inputs |
| **Incubation** | Unconscious processing | Walk, shower, sleep |
| **Illumination** | Aha moment | Capture immediately |
| **Verification** | Evaluate and refine | Critical analysis |

### Design Thinking Process

| Stage | Focus | Methods |
|-------|-------|---------|
| **Empathize** | Understand user needs | Interviews, observation |
| **Define** | Frame the problem | Problem statements, POV |
| **Ideate** | Generate solutions | Brainstorming, sketching |
| **Prototype** | Make ideas tangible | Quick builds, mockups |
| **Test** | Get feedback | User testing, iteration |

### Creative Problem-Solving (CPS)

| Phase | Questions |
|-------|-----------|
| **Clarify** | What is the challenge? |
| **Ideate** | What are all possible solutions? |
| **Develop** | How can we strengthen the best ideas? |
| **Implement** | What is the action plan? |

---

## Environmental Factors

### Physical Environment

| Factor | Creative Environment |
|--------|---------------------|
| **Space** | Open, flexible, varied |
| **Color** | Blue (calm, open); green (growth) |
| **Lighting** | Natural light, adjustable |
| **Sound** | Moderate ambient noise (~70 dB) |
| **Temperature** | Comfortable, slightly warm |
| **Nature** | Plants, natural elements |

### Psychological Environment

| Factor | Impact | Creation |
|--------|--------|----------|
| **Psychological safety** | Essential | No judgment, failure okay |
| **Autonomy** | High | Choice in approach |
| **Time** | Moderate pressure | Not too tight, not too loose |
| **Playfulness** | Beneficial | Humor, experimentation |
| **Diversity** | Valuable | Different perspectives |

### Optimal Challenge

| Challenge Level | Effect |
|-----------------|--------|
| Too easy | Boredom, no growth |
| Optimal | Flow, creativity |
| Too hard | Anxiety, blocks |

### Team Creativity

| Factor | Effect |
|--------|--------|
| Diversity | More perspectives, more ideas |
| Trust | Willing to take risks |
| Conflict (task) | Stimulates thinking |
| Conflict (relationship) | Harmful |
| Size | 4-6 optimal for brainstorming |

---

## Techniques & Methods

### Brainstorming Rules

| Rule | Purpose |
|------|---------|
| Defer judgment | No criticism during ideation |
| Go for quantity | More ideas = more options |
| Build on ideas | "Yes, and..." not "no, but" |
| Encourage wild ideas | Unusual often leads to novel |

### Ideation Techniques

| Technique | Description | Use When |
|-----------|-------------|----------|
| **Mind mapping** | Visual association | Exploring connections |
| **SCAMPER** | Systematic modification | Improving existing |
| **Reverse brainstorming** | How to cause the problem | Breaking fixed thinking |
| **Random input** | Forced associations | Stuck on solutions |
| **Analogies** | Borrow from other domains | Need fresh perspective |
| **Six Thinking Hats** | Structured perspectives | Group exploration |
| **Worst possible idea** | Start with bad | Reducing fear |

### SCAMPER Framework

| Letter | Action | Questions |
|--------|--------|-----------|
| **S** | Substitute | What can be replaced? |
| **C** | Combine | What can be merged? |
| **A** | Adapt | What can be adjusted? |
| **M** | Modify/Magnify | What can be changed in scale? |
| **P** | Put to other use | What else can it do? |
| **E** | Eliminate | What can be removed? |
| **R** | Reverse/Rearrange | What if opposite/reordered? |

### Six Thinking Hats

| Hat | Focus | Questions |
|-----|-------|-----------|
| **White** | Facts | What do we know? |
| **Red** | Emotions | How do we feel? |
| **Black** | Caution | What could go wrong? |
| **Yellow** | Benefits | What's good about it? |
| **Green** | Creativity | What are new ideas? |
| **Blue** | Process | What's our approach? |

---

## Blocks & Barriers

### Types of Creative Blocks

| Block Type | Description | Overcome |
|------------|-------------|----------|
| **Perceptual** | Seeing what's expected | Change perspective, constraints |
| **Emotional** | Fear, anxiety, judgment | Psychological safety |
| **Cultural** | Social norms, traditions | Question assumptions |
| **Environmental** | Distractions, resources | Change setting, remove barriers |
| **Intellectual** | Wrong strategy, knowledge gaps | Learn, try different approach |
| **Expressive** | Can't communicate idea | Multiple media, collaboration |

### Overcoming Blocks

| Strategy | Application |
|----------|-------------|
| Change environment | New location, walk |
| Change medium | Draw instead of write |
| Set constraints | Paradoxically frees creativity |
| Take a break | Incubation effect |
| Collaborate | Fresh perspectives |
| Lower stakes | Prototype, experiment |
| Morning pages | Dump mental clutter |

### Fear and Creativity

| Fear | Effect | Mitigation |
|------|--------|------------|
| Failure | Risk avoidance | Celebrate attempts, small experiments |
| Judgment | Self-censoring | Safe space, anonymous ideation |
| Uncertainty | Paralysis | Embrace ambiguity, iterate |
| Imperfection | Never finishing | "Done is better than perfect" |

### Fixed vs Growth Mindset

| Fixed | Growth | Creative Impact |
|-------|--------|-----------------|
| "I'm not creative" | "Creativity is a skill" | Willingness to try |
| "Failure is bad" | "Failure is learning" | Risk-taking |
| "That's not my thing" | "I can learn this" | Cross-domain exploration |

---

## Creativity in Organizations

### Fostering Innovation Culture

| Element | Implementation |
|---------|----------------|
| **Time** | 20% time, innovation sprints |
| **Space** | Creative areas, collaboration zones |
| **Permission** | Explicit encouragement to experiment |
| **Recognition** | Celebrate attempts, not just successes |
| **Resources** | Tools, training, prototyping materials |

### Idea Management

| Stage | Process |
|-------|---------|
| Collection | Easy submission, no barriers |
| Evaluation | Transparent criteria, diverse evaluators |
| Development | Resources for promising ideas |
| Implementation | Clear pathway to action |
| Feedback | Recognition, learning |

### Measuring Creativity

| Metric | What It Measures |
|--------|------------------|
| Number of ideas | Volume/fluency |
| Idea diversity | Flexibility |
| Novelty rating | Originality |
| Implementation rate | Practical creativity |
| Impact metrics | Value created |
