# Communication Psychology

Principles for effective interpersonal and marketing communication.

## Table of Contents

1. [Active Listening](#active-listening)
2. [Verbal Communication](#verbal-communication)
3. [Nonverbal Communication](#nonverbal-communication)
4. [Written Communication](#written-communication)
5. [Difficult Conversations](#difficult-conversations)

---

## Active Listening

### Core Components

| Component | Description | Technique |
|-----------|-------------|-----------|
| **Attending** | Physical presence | Eye contact, posture, nods |
| **Following** | Encouragement | "Go on," "I see," silence |
| **Reflecting** | Mirror content/feeling | Paraphrase, summarize |
| **Probing** | Clarify, deepen | Open questions |

### Levels of Listening

| Level | Description | Quality |
|-------|-------------|---------|
| **Ignoring** | Not listening | Poor |
| **Pretending** | Appearing to listen | Poor |
| **Selective** | Hearing what you want | Limited |
| **Attentive** | Focusing on words | Good |
| **Empathic** | Understanding feeling and meaning | Excellent |

### Barriers to Listening

| Barrier | Description | Overcome |
|---------|-------------|----------|
| **Judging** | Evaluating while listening | Suspend judgment |
| **Advising** | Jumping to solutions | Ask first |
| **Interrupting** | Cutting off speaker | Wait for pauses |
| **Derailing** | Changing subject | Stay on topic |
| **Placating** | False agreement | Be honest |

### Reflective Listening Techniques

| Technique | Example |
|-----------|---------|
| **Paraphrase** | "So what you're saying is..." |
| **Reflect feeling** | "It sounds like you're frustrated" |
| **Summarize** | "Let me make sure I understand..." |
| **Clarify** | "What do you mean by...?" |
| **Validate** | "That makes sense because..." |

---

## Verbal Communication

### Message Structure

| Structure | Use Case | Pattern |
|-----------|----------|---------|
| **BLUF** (Bottom Line Up Front) | Busy audiences | Conclusion → support |
| **Pyramid** | Complex topics | Main point → details |
| **Narrative** | Engagement | Story arc |
| **Problem-Solution** | Proposals | Issue → fix |

### Clarity Principles

| Principle | Description | Example |
|-----------|-------------|---------|
| **Concrete** | Specific, tangible | "Increase by 20%" not "improve" |
| **Simple** | Plain language | 8th grade reading level |
| **Active** | Active voice | "We shipped" not "was shipped" |
| **Short** | Brief sentences | 15-20 words average |
| **Structured** | Organized | Headings, bullets, numbers |

### Framing Effects

| Frame | Effect | Example |
|-------|--------|---------|
| **Gain** | Risk-averse choices | "Save $100" |
| **Loss** | Risk-seeking choices | "Don't lose $100" |
| **Positive** | Higher acceptance | "95% success rate" |
| **Negative** | Lower acceptance | "5% failure rate" |

### Power Words

| Category | Words | Use |
|----------|-------|-----|
| **You** | You, your, yours | Personal relevance |
| **New** | New, discover, introducing | Novelty appeal |
| **Free** | Free, bonus, gift | Value perception |
| **Because** | Because, since, therefore | Reason-giving |
| **Easy** | Easy, simple, quick | Reduce friction perception |
| **Proven** | Proven, guaranteed, results | Credibility |

---

## Nonverbal Communication

### Channels

| Channel | % of Message | Components |
|---------|--------------|------------|
| **Words** | 7% | Content |
| **Tone** | 38% | Pitch, pace, volume |
| **Body** | 55% | Posture, gesture, face |

*Note: Percentages from Mehrabian's study apply to emotional/relational communication.*

### Body Language Signals

| Signal | Positive | Negative |
|--------|----------|----------|
| **Eye contact** | Engaged, honest | Avoiding (discomfort, dishonesty) |
| **Posture** | Open, leaning in | Closed, leaning back |
| **Arms** | Relaxed, open | Crossed (defensive) |
| **Hands** | Visible, gesturing | Hidden, fidgeting |
| **Face** | Animated, smiling | Flat, tense |

### Cultural Variations

| Element | Western | Other Cultures |
|---------|---------|----------------|
| Eye contact | Respect, attention | May indicate disrespect (some Asian) |
| Personal space | ~18 inches | Varies widely |
| Touch | Limited | More/less depending on culture |
| Gestures | OK sign = positive | Offensive in some cultures |
| Silence | Uncomfortable | Valued (some Asian cultures) |

### Voice Elements

| Element | Effect | Use |
|---------|--------|-----|
| **Pace** | Fast = energy; Slow = emphasis | Vary for engagement |
| **Pitch** | Higher = excitement; Lower = authority | Match content |
| **Volume** | Louder = importance; Softer = intimacy | Strategic variation |
| **Pause** | Emphasis, processing time | Before key points |

---

## Written Communication

### Email Psychology

| Element | Best Practice | Psychology |
|---------|---------------|------------|
| Subject | Specific, actionable | Attention, filtering |
| Opening | Context or ask | Orientation |
| Body | Scannable, structured | Cognitive load |
| Close | Clear CTA | Completion drive |
| Length | As short as possible | Respect time |

### Readability Factors

| Factor | Guideline |
|--------|-----------|
| Sentence length | 15-20 words average |
| Paragraph length | 3-4 sentences |
| Reading level | 8th grade for general audience |
| White space | Generous margins, line spacing |
| Formatting | Headers, bullets, bold for scanning |

### Tone in Writing

| Tone | Achieved By | Use When |
|------|-------------|----------|
| **Formal** | Full sentences, no contractions | Official, legal |
| **Professional** | Clear, respectful, balanced | Business default |
| **Conversational** | Contractions, "you," questions | Friendly brands |
| **Urgent** | Short sentences, imperatives | Time-sensitive |
| **Empathetic** | Acknowledging feelings | Complaints, support |

### Persuasive Writing Structure

| Section | Content | Purpose |
|---------|---------|---------|
| Hook | Attention-grabber | Engage |
| Problem | Pain point | Relevance |
| Solution | Your offering | Value |
| Proof | Evidence, testimonials | Credibility |
| CTA | Clear next step | Action |

---

## Difficult Conversations

### Preparation Framework

| Step | Question |
|------|----------|
| 1. Purpose | What outcome do I want? |
| 2. Facts | What do I know vs assume? |
| 3. Feelings | How am I feeling? How might they? |
| 4. Contribution | What's my part in this? |
| 5. Approach | How can I open constructively? |

### Opening Difficult Conversations

| Approach | Example |
|----------|---------|
| **Third story** | "We seem to see this differently..." |
| **Curious** | "I'd like to understand your perspective..." |
| **Impact** | "When X happened, I felt..." |
| **Collaborative** | "I want to find a solution that works for both..." |

### De-Escalation Techniques

| Technique | Application |
|-----------|-------------|
| **Lower voice** | Calm triggers calm |
| **Slow pace** | Reduces urgency |
| **Acknowledge** | "I hear you're frustrated" |
| **Find agreement** | "You're right that..." |
| **Take responsibility** | "I should have..." |
| **Propose break** | "Can we take 5 minutes?" |

### Feedback Model (SBI-I)

| Component | Description | Example |
|-----------|-------------|---------|
| **Situation** | When/where | "In yesterday's meeting..." |
| **Behavior** | Observable action | "You interrupted twice..." |
| **Impact** | Effect | "Which made it hard to finish..." |
| **Intent/Inquiry** | Explore | "What was going on for you?" |

### Conflict Styles (Thomas-Kilmann)

| Style | When to Use | Limitations |
|-------|-------------|-------------|
| **Competing** | Quick decision, unpopular action | Damages relationships |
| **Collaborating** | Complex issues, commitment needed | Time-consuming |
| **Compromising** | Moderate importance, time pressure | Partial satisfaction |
| **Avoiding** | Trivial issue, cooling needed | Issues unresolved |
| **Accommodating** | Wrong, relationship > issue | Resentment risk |
