# Color Psychology

Understanding how color influences perception, emotion, and behavior in design and marketing.

## Table of Contents

1. [Color Associations](#color-associations)
2. [Color in Marketing](#color-in-marketing)
3. [Cultural Variations](#cultural-variations)
4. [Color Combinations](#color-combinations)
5. [Practical Application](#practical-application)

---

## Color Associations

### Primary Color Meanings

| Color | Positive Associations | Negative Associations | Common Uses |
|-------|----------------------|----------------------|-------------|
| **Red** | Energy, passion, urgency, excitement | Danger, aggression, anger | Sales, CTAs, food, entertainment |
| **Blue** | Trust, calm, security, professionalism | Cold, distant, sadness | Finance, tech, healthcare, corporate |
| **Yellow** | Optimism, happiness, warmth, attention | Caution, anxiety, cowardice | Warnings, children, energy, food |
| **Green** | Nature, growth, health, money | Envy, inexperience | Health, finance, environment, organic |
| **Orange** | Friendly, confident, creative, fun | Cheap, immature | CTAs, youth brands, food, energy |
| **Purple** | Luxury, creativity, wisdom, royalty | Decadence, moodiness | Beauty, luxury, spirituality |
| **Black** | Sophistication, power, elegance | Death, evil, mystery | Luxury, fashion, tech |
| **White** | Purity, cleanliness, simplicity | Sterile, cold, empty | Healthcare, minimal design, tech |
| **Pink** | Femininity, romance, care | Weakness, immaturity | Beauty, romance, children |
| **Brown** | Earthy, reliable, warm | Dull, unsophisticated | Food, organic, outdoor |
| **Gray** | Neutral, professional, balanced | Boring, dull, sad | Corporate, tech, luxury |

### Emotional Impact

| Emotion | Colors That Evoke |
|---------|-------------------|
| Trust | Blue, green, white |
| Excitement | Red, orange, yellow |
| Calm | Blue, green, lavender |
| Urgency | Red, orange |
| Luxury | Black, purple, gold |
| Health | Green, blue, white |
| Creativity | Purple, orange, yellow |
| Power | Black, red, navy |

---

## Color in Marketing

### Industry Color Norms

| Industry | Common Colors | Reasoning |
|----------|---------------|-----------|
| Finance | Blue, green, black | Trust, money, stability |
| Healthcare | Blue, green, white | Calm, health, cleanliness |
| Food | Red, yellow, orange | Appetite, energy, warmth |
| Tech | Blue, black, white | Trust, sophistication, simplicity |
| Luxury | Black, gold, purple | Elegance, premium, royalty |
| Children | Primary colors, pastels | Playful, cheerful, simple |
| Eco/Organic | Green, brown, earth tones | Nature, authenticity |
| Fashion | Black, white, brand-specific | Sophistication, canvas |

### Color and Conversion

| Element | Effective Colors | Why |
|---------|-----------------|-----|
| **CTAs** | Red, orange, green | Contrast, urgency, go |
| **Trust signals** | Blue, green | Security, reliability |
| **Sale/discount** | Red | Urgency, attention |
| **Premium** | Black, gold, white | Luxury perception |
| **Eco-friendly** | Green | Nature association |

### CTA Button Colors

| Color | Effect | Best For |
|-------|--------|----------|
| **Red** | Highest urgency, attention | Limited offers, sales |
| **Orange** | Friendly urgency | Trials, signups |
| **Green** | Positive action, "go" | Confirmations, proceed |
| **Blue** | Trustworthy | Financial, subscription |

**Key principle**: Contrast with page matters more than specific color.

### Color Temperature

| Temperature | Effect | Use |
|-------------|--------|-----|
| **Warm** (red, orange, yellow) | Energizing, advancing | CTAs, attention |
| **Cool** (blue, green, purple) | Calming, receding | Backgrounds, trust |
| **Neutral** (black, white, gray) | Balanced | Text, structure |

---

## Cultural Variations

### Color Meanings by Culture

| Color | Western | East Asian | Middle Eastern | Latin American |
|-------|---------|------------|----------------|----------------|
| **Red** | Danger, love | Luck, prosperity | Danger | Passion, religion |
| **White** | Purity, wedding | Death, mourning | Purity | Peace |
| **Black** | Death, elegance | Power, knowledge | Mystery, evil | Death, masculinity |
| **Yellow** | Happiness | Royalty, courage | Happiness | Death, mourning |
| **Green** | Nature, money | Eternity | Islam, paradise | Nature |
| **Blue** | Trust, sadness | Immortality | Heaven | Trust |
| **Purple** | Royalty | Wealth | Royalty | Death, spirituality |

### Global Brand Considerations

| Consideration | Recommendation |
|---------------|----------------|
| Research target market | Color meanings vary |
| Test locally | A/B test in each market |
| Avoid offensive combinations | Research taboos |
| Consider religion | Sacred colors exist |
| Adapt vs. maintain | Balance consistency and cultural fit |

---

## Color Combinations

### Color Harmony Types

| Type | Description | Use |
|------|-------------|-----|
| **Monochromatic** | Shades of one color | Elegant, unified |
| **Complementary** | Opposite on wheel | High contrast, vibrant |
| **Analogous** | Adjacent colors | Harmonious, natural |
| **Triadic** | Three evenly spaced | Balanced, vibrant |
| **Split-complementary** | One + two adjacent to complement | High contrast, less tension |

### 60-30-10 Rule

| Proportion | Use |
|------------|-----|
| **60%** | Dominant (backgrounds) |
| **30%** | Secondary (navigation, cards) |
| **10%** | Accent (CTAs, highlights) |

### Contrast for Accessibility

| Use | Minimum Ratio | Recommended |
|-----|---------------|-------------|
| Body text | 4.5:1 | 7:1 |
| Large text | 3:1 | 4.5:1 |
| UI components | 3:1 | 4.5:1 |

**Tools**: WebAIM contrast checker, Stark plugin

---

## Practical Application

### Brand Color Selection

| Step | Consideration |
|------|---------------|
| 1. Values | What does brand stand for? |
| 2. Audience | Who are you targeting? |
| 3. Industry | What are norms/expectations? |
| 4. Differentiation | How to stand out? |
| 5. Cultural | Any market-specific concerns? |
| 6. Accessibility | Sufficient contrast? |

### Testing Color Effectiveness

| Method | Application |
|--------|-------------|
| A/B testing | CTA colors, page themes |
| Heat maps | Attention patterns |
| Eye tracking | Focus areas |
| Surveys | Emotional response |
| Conversion data | Performance metrics |

### Color in Data Visualization

| Use | Guidance |
|-----|----------|
| Categories | Distinct, accessible colors |
| Sequential | Single hue, varying intensity |
| Diverging | Two hues from neutral center |
| Highlight | One accent color |
| Colorblind-safe | Test with simulators |

### Quick Reference: When to Use

| Goal | Colors |
|------|--------|
| Build trust | Blue, green |
| Create urgency | Red, orange |
| Premium feel | Black, gold, white |
| Eco/health | Green, blue |
| Fun/playful | Orange, yellow, pink |
| Professional | Navy, gray, white |
| Creative | Purple, orange |
| Calm | Blue, green, lavender |

### Common Mistakes

| Mistake | Better Approach |
|---------|-----------------|
| Too many colors | Stick to 3-4 |
| Ignoring contrast | Check accessibility |
| Trendy over timeless | Consider longevity |
| Ignoring cultural context | Research markets |
| Color without strategy | Align with brand values |
| Same as competitors | Differentiate thoughtfully |
