# Proxmox Skill for OpenClaw

---

## Proxmox VE Management

**Monitor node health, list cluster resources, and manage VM/LXC power states.**

# [ Quick Start ]

#### <u>Install Dependencies</u>

**Ensure you have Python 3.10+ and the required API libraries installed on the machine running OpenClaw:**

```
pip install proxmoxer requests
```

#### ⚙️ <u>Environment Variables</u>

**Add these to your .bashrc or OpenClaw environment config:**

```
export PVE_HOST="https://your.proxmox.local:8006"
export PVE_TOKEN_ID="user@pam!token-name"
export PVE_TOKEN_SECRET="your-generated-secret"
```

---

# [ Permission Setup ]

**For security, use a dedicated API token rather than the root password.**

###### <u>Step 1: Create an API Token</u>

1. Log in to the Proxmox VE web interface.
2. Navigate to **Datacenter > Permissions > Users**.
3. **Optional but Recommended:** Click **Add** to create a dedicated service user  
   (e.g., openclaw@pve).
4. Go to the **API Tokens** tab and click **Add**.
5. Select your user and enter a **Token ID** (e.g., bot-token).
6. **Important:** Copy the **Token Secret** immediately. It will only be displayed once.

##### <u>Step 2: Assign Permissions your API token</u>

1. Navigate to **Datacenter > Permissions > Add > API Token Permission**.
2. **Path:** Enter / (to allow access to the whole cluster) or a specific VM path.
3. **Token:** Select the token you just created.
4. **Role:** - **PVEAuditor:** If you only want the bot to *see* stats but not touch anything.  
   **PVEDatastoreAdmin / PVEVMAdmin:** If you want the bot to be able to start/stop VMs.
5. **Propagate:** Check this box so the permissions apply to all nodes and VMs.

---

# [ Features ]

##### 🖥️ Node Health

> **Monitor real-time CPU and RAM usage for physical hosts.**
> *Stay ahead of hardware bottlenecks before they impact your services.*

##### 🔍 Resource Discovery

> **List all VMs and Containers across the Proxmox cluster.**
> *Instant visibility into your entire infrastructure.*

##### ⚡ Power Management

> **Start, Stop, Reboot, and Shutdown.**
> *Full control over your virtual fleet with safety-first logic.*

##### 📸 Snapshot Management

> **Take, list, and rollback snapshots for any VM or Container.**
> *One-click recovery points for your lab experiments.*

---

# 🛡️ Security & Guardrails

- Non-Root Users: Always create a restricted user for your API tokens.

- Secret Management: Never commit your **PVE_TOKEN_SECRET** to a public repository.

- Approval Guards: By default, destructive actions (Stop/Shutdown) require you to click an "Approve" button in your chat client.

# [ Manual Usage ]

---

**To test the connection and list all nodes:**

` python3 scripts/proxmox.py nodes`

**To see all VMs and Containers across the cluster:**

` python3 scripts/proxmox.py vms`

**To take a manual snapshot of a VM:**

 `python3 scripts/proxmox.py take_snapshot pve qemu 100 "Manual-Backup"`

**To power on a specific VM:** 

`python3 scripts/proxmox.py start pve qemu 100`



> **Note:** Ensure your Environment Variables (PVE_HOST, PVE_TOKEN_ID, and PVE_TOKEN_SECRET) are exported in your terminal before running these commands manually.


