#!/usr/bin/env bash
set -euo pipefail

# Encrypt a plaintext .env file into ~/clawd/secrets/proton.env.age using age.
# Usage:
#   encrypt_env.sh /path/to/proton.env age1PUBLICKEY...

ENV_FILE="${1:-}"
PUBKEY="${2:-}"

if [[ -z "$ENV_FILE" || -z "$PUBKEY" ]]; then
  echo "Usage: $0 /path/to/proton.env age1PUBLICKEY..." >&2
  exit 2
fi

OUT_DIR="$HOME/clawd/secrets"
OUT_FILE="$OUT_DIR/proton.env.age"

mkdir -p "$OUT_DIR"
chmod 700 "$OUT_DIR" || true

age -r "$PUBKEY" -o "$OUT_FILE" "$ENV_FILE"

echo "Wrote: $OUT_FILE" >&2
