# Proton Mail Bridge setup (Linux)

This skill assumes you want local IMAP/SMTP for automation.

## Install

Proton distributes Bridge installers on their site (often a .deb for Debian/Ubuntu).

- Download: https://proton.me/mail/bridge
- Install (Deb/Ubuntu):

```bash
cd ~/Downloads
sudo apt install ./protonmail-bridge_*.deb
sudo apt -f install
```

## Configure

1) Launch Bridge.
2) Sign in.
3) Open the “IMAP/SMTP” connection details.
4) Record:
- IMAP Host/Port + Security
- SMTP Host/Port + Security
- Username (can be the email address)
- **Bridge password** (“Use this password”) — do not store your main Proton password.

## Encrypted config format

Store these keys in a plaintext file (temporarily), then encrypt:

```ini
PROTON_EMAIL=boilermolt@proton.me
PROTON_BRIDGE_USER=boilermolt@proton.me
PROTON_BRIDGE_PASS=... (bridge password)
IMAP_HOST=127.0.0.1
IMAP_PORT=1143
IMAP_SECURITY=STARTTLS
SMTP_HOST=127.0.0.1
SMTP_PORT=1025
SMTP_SECURITY=STARTTLS
```

Then encrypt with `scripts/encrypt_env.sh`.

## Runtime requirement

Bridge must be running for localhost IMAP/SMTP to work.
