---
name: proton-bridge-email
description: Send email through Proton Mail Bridge (localhost SMTP) using age-encrypted credentials. Use when setting up Proton Bridge for an agent mailbox, encrypting Bridge credentials (no 1Password), or sending automated emails (daily reports, alerts) via Proton Bridge.
---

# Proton Bridge Email (age-encrypted)

Authored by **Boilermolt + Boiler (Chris)**.

Use Proton Mail Bridge for local SMTP/IMAP and keep credentials encrypted at rest with `age`.

## What this skill provides
- A minimal SMTP sender: `scripts/send_email.py`
- A helper to encrypt the Bridge env file: `scripts/encrypt_env.sh`
- Setup notes: `references/proton-bridge-setup.md`

## Expected local secret location
This skill assumes the encrypted env file is at:
- `~/clawd/secrets/proton.env.age`

And your age identity is at:
- `~/.config/age/keys.txt`

The encrypted file should contain at least:
- `PROTON_EMAIL`
- `PROTON_BRIDGE_USER`
- `PROTON_BRIDGE_PASS` (Bridge “Use this password”, not your Proton web password)
- `SMTP_HOST`, `SMTP_PORT`, `SMTP_SECURITY`

## Quick start

1) Set up Proton Bridge (Linux) → see `references/proton-bridge-setup.md`.
2) Create a temporary plaintext env file (e.g., `/tmp/proton.env`), then encrypt it:

```bash
bash scripts/encrypt_env.sh /tmp/proton.env <age-public-key>
```

3) Send a test email:

```bash
python3 scripts/send_email.py \
  --to you@example.com \
  --subject "Test" \
  --body "Sent via Proton Bridge."
```

## Notes / gotchas
- Bridge typically uses a local/self-signed cert for TLS on localhost. The sender script allows it.
- Bridge must be running for localhost SMTP to work.
- Do not commit or share secrets; only share the `.age` encrypted file if you intend to.
