---
name: proto-cog
description: "Build prototypes you can click. UI/UX wireframes, app mockups, and fully interactive HTML prototypes — from napkin sketch to clickable experience in one prompt. Landing pages, mobile app screens, SaaS dashboards, design systems, and user flows — prototyped and playable, not just pretty."
metadata:
  openclaw:
    emoji: "✏️"
author: CellCog
dependencies: [cellcog]
---

# Proto Cog - Build Prototypes You Can Click

**Build prototypes you can click.** UI/UX wireframes, app mockups, and fully interactive HTML prototypes — from napkin sketch to clickable experience in one prompt.

Every other AI design tool gives you static images. CellCog builds working prototypes — real HTML, real interactions, real user flows you can click through and share with stakeholders. Landing pages, mobile app screens, SaaS dashboards, design systems — prototyped and playable, not just pretty.

---

## Prerequisites

This skill requires the `cellcog` skill for SDK setup and API calls.

```bash
clawhub install cellcog
```

**Read the cellcog skill first** for SDK setup. This skill shows you what's possible.

**Quick pattern (v1.0+):**
```python
# Fire-and-forget - returns immediately
result = client.create_chat(
    prompt="[your prototype request]",
    notify_session_key="agent:main:main",
    task_label="prototype-task",
    chat_mode="agent"  # Agent mode for most prototypes
)
# Daemon notifies you when complete - do NOT poll
```

---

## Why Interactive Prototypes Matter

Static mockups create a fundamental gap: stakeholders see pictures, not experiences. The difference matters:

| Static Mockup | Interactive Prototype |
|--------------|---------------------|
| "Imagine clicking this button" | Click the button, see what happens |
| "This would scroll to..." | Scroll and see the content load |
| "The hover state looks like..." | Hover and watch the animation |
| "Trust me, the flow makes sense" | Walk through the flow yourself |

CellCog generates **real HTML/CSS/JS prototypes** hosted on live URLs. Share a link, get feedback on the actual experience — not on someone's imagination of the experience.

---

## What You Can Prototype

### Landing Pages

Validate your messaging and design:

- **SaaS Landing Pages**: "Create a landing page for an AI writing assistant — hero, features, pricing, testimonials, CTA"
- **Product Launch Pages**: "Build a launch page for a new fitness app with countdown and email signup"
- **Event Pages**: "Create a conference landing page with schedule, speakers, and registration"
- **Portfolio Sites**: "Build a personal portfolio landing page for a UX designer"

**Example prompt:**
> "Create an interactive landing page prototype for 'FlowState' — a productivity app for developers:
> 
> Sections:
> - Hero: 'Code in the zone. Stay in the zone.' with app screenshot and CTA
> - Problem: Distractions kill developer flow (statistics)
> - Solution: How FlowState blocks distractions intelligently
> - Features: 3-4 key features with icons
> - Pricing: Free, Pro ($12/mo), Team ($8/user/mo)
> - Testimonials: 3 developer quotes
> - Final CTA
> 
> Style: Dark theme, developer-friendly, monospace accents
> Make all buttons and navigation interactive."

### Mobile App Screens

Design full app experiences:

- **Onboarding Flows**: "Create a 5-screen onboarding flow for a meditation app"
- **Core Features**: "Prototype the main dashboard and navigation for a fitness tracking app"
- **E-commerce**: "Build a product browse → detail → cart → checkout flow for a fashion app"
- **Social Features**: "Prototype a profile page, feed, and messaging interface"

**Example prompt:**
> "Prototype a mobile food delivery app (phone-sized viewport):
> 
> Screens:
> 1. Home — restaurant grid with search and category filters
> 2. Restaurant — menu with items, ratings, delivery time
> 3. Item detail — customization options, add to cart
> 4. Cart — order summary, delivery address, payment
> 5. Order tracking — live status with map placeholder
> 
> Make navigation between screens work with smooth transitions.
> Style: Clean, modern, Uber Eats / DoorDash inspired."

### SaaS Dashboards

Prototype complex business tools:

- **Analytics Dashboards**: "Create a marketing analytics dashboard with real chart interactions"
- **Admin Panels**: "Build a user management panel with tables, filters, and modals"
- **CRM Interfaces**: "Prototype a sales pipeline view with drag-and-drop kanban board"
- **Settings Pages**: "Create a comprehensive settings page with tabs, forms, and toggles"

**Example prompt:**
> "Prototype a SaaS project management dashboard:
> 
> Left sidebar: Navigation (Projects, Tasks, Team, Reports, Settings)
> Main area:
> - Overview: KPI cards (tasks completed, overdue, in progress)
> - Kanban board: Columns for To Do, In Progress, Review, Done
> - Task cards with assignee avatars, priority tags, due dates
> 
> Interactions:
> - Sidebar navigation switches views
> - Clicking a task card opens a detail modal
> - Filter dropdown for project/team member
> 
> Style: Clean, professional, Notion/Linear inspired."

### Design Systems & Components

Build reusable design foundations:

- **Component Libraries**: "Create a UI component library: buttons, inputs, cards, modals, navigation"
- **Style Guides**: "Build an interactive style guide showing typography, colors, spacing, and components"
- **Form Patterns**: "Prototype common form patterns: login, signup, multi-step wizard, settings"
- **Navigation Patterns**: "Create examples of sidebar nav, top nav, bottom tab bar, and hamburger menu"

### Wireframes

Quick structural explorations:

- **Low-Fidelity Wireframes**: "Create grayscale wireframes for a blog platform — home, article, author pages"
- **User Flows**: "Wireframe the complete signup → onboarding → first action flow for a project management tool"
- **Layout Explorations**: "Show 3 different layout approaches for a real estate listing page"
- **Information Architecture**: "Wireframe the navigation structure for an e-learning platform with courses, lessons, and progress tracking"

---

## Prototype Features

CellCog prototypes can include:

| Feature | Description |
|---------|-------------|
| **Navigation** | Working links, page transitions, tab switching |
| **Interactions** | Hover states, click actions, toggles, accordions |
| **Forms** | Input fields, validation states, dropdowns, checkboxes |
| **Modals & Overlays** | Popup dialogs, slide-out panels, tooltips |
| **Responsive Design** | Adapts to desktop, tablet, and mobile viewports |
| **Animations** | Smooth transitions, loading states, micro-interactions |
| **Data Display** | Charts, tables, cards with realistic sample data |
| **Dark/Light Themes** | Theme switching support |

---

## Output Formats

| Format | Best For |
|--------|----------|
| **Interactive HTML** (Default) | Clickable prototypes hosted on live URL — share with anyone |
| **Static Images** | Screenshots for documentation or comparison |
| **PDF** | Wireframe documentation for handoff |

**Interactive HTML is the default.** That's the whole point — prototypes you can click.

---

## Chat Mode for Prototyping

| Scenario | Recommended Mode |
|----------|------------------|
| Individual pages, single components, wireframes | `"agent"` |
| Full app prototypes with multiple interconnected screens, design systems | `"agent team"` |

**Use `"agent"` for most prototypes.** Landing pages, individual app screens, and component designs execute well in agent mode.

**Use `"agent team"` for full application prototypes** — multi-screen apps where navigation, state, and user flows need to work together cohesively.

---

## Example Prompts

**SaaS landing page:**
> "Create a landing page for 'CodeReview.ai' — an AI code review tool:
> 
> Hero: 'Ship better code. Ship it faster.' with demo video placeholder
> Social proof: 'Trusted by 500+ engineering teams'
> Features: AI-powered reviews, integration with GitHub/GitLab, security scanning
> Pricing: Starter (free), Pro ($29/mo), Enterprise (custom)
> 
> Dark theme, developer-focused, green accent color.
> All navigation and CTAs should be interactive."

**Mobile app prototype:**
> "Prototype a habit tracking app (mobile viewport):
> 
> Tab bar: Today, Habits, Stats, Profile
> 
> Today screen: List of today's habits with checkboxes, streak counts, and progress ring
> Habits screen: All habits with edit/delete, add new habit button
> Stats screen: Charts showing completion rates, longest streaks, weekly/monthly view
> Profile screen: Settings, notification preferences, export data
> 
> Tab navigation should work. Checking habits should animate.
> Style: Minimal, calming, inspired by Streaks app."

**Design system:**
> "Build an interactive design system for a fintech startup:
> 
> Colors: Primary (deep blue), secondary (teal), accent (amber), semantic (success/warning/error)
> Typography: Scale from h1 to body to caption with clear hierarchy
> Components:
> - Buttons (primary, secondary, ghost, destructive — each with hover/active/disabled states)
> - Input fields (default, focused, error, disabled)
> - Cards (simple, interactive, stat card)
> - Table with sortable headers
> - Modal dialog
> - Toast notifications
> 
> Show each component with interactive states. Professional, banking-grade aesthetic."

**Wireframe exploration:**
> "Create 3 different layout approaches for an AI chatbot interface:
> 
> Option A: Full-page chat (like ChatGPT)
> Option B: Side panel chat with main content area
> Option C: Floating chat widget
> 
> Each should include: message input, conversation history, suggested prompts, and settings access.
> Grayscale wireframes, focused on layout and information hierarchy."

---

## Tips for Better Prototypes

1. **Describe the interactions**: "Button opens a modal" or "Tabs switch content" — tell CellCog what should happen, not just what should appear.

2. **Reference existing products**: "Like Notion's sidebar" or "Stripe's pricing page" communicates more than paragraphs of description.

3. **Specify viewport**: "Mobile phone viewport" vs "Full desktop" changes the entire design approach.

4. **Include realistic content**: Real text, real numbers, real labels — not "Lorem ipsum". Prototypes with real content get better feedback.

5. **State the purpose**: "For user testing", "For investor demo", "For developer handoff" — context shapes fidelity level.

6. **Think in flows, not pages**: "Signup → Onboarding → Dashboard" is more useful than 3 disconnected page requests.
