---
name: prospector
description: |
  This skill should be used when the user wants to find leads, prospects, or contacts matching their ICP (Ideal Customer Profile). It searches for companies via Exa and enriches contacts via Apollo, outputting to CSV and optionally syncing to Attio CRM.

  MANDATORY TRIGGERS: "find leads", "prospecting", "ICP search", "find contacts", "lead generation", "/prospector"
version: 1.0.0
---

# Prospector

Find leads matching your ICP via Exa company search + Apollo contact enrichment.

## Prerequisites

Run `/prospector:setup` first to configure your API keys:
- **Exa** (required): https://exa.ai - company discovery
- **Apollo** (required): https://apollo.io - contact enrichment
- **Attio** (optional): https://attio.com - CRM sync

You can also set keys via environment variables:
- `PROSPECTOR_EXA_API_KEY`
- `PROSPECTOR_APOLLO_API_KEY`
- `PROSPECTOR_ATTIO_API_KEY` (optional)

## Usage

### Setup (one-time)

```
/prospector:setup
```

Collects and validates API keys, stores securely in `~/.config/prospector/config.json`.

### Find Leads

```
/prospector
```

Asks ICP questions, searches Exa, enriches via Apollo, outputs CSV to Desktop.

## Main Command: /prospector

When the user invokes `/prospector`, follow this workflow:

### Step 1: Check Config or Env Vars

First, verify env vars or config exist:

```bash
python3 -c "
import json
import os
from pathlib import Path
config_path = Path.home() / '.config' / 'prospector' / 'config.json'
env_exa = bool(os.getenv('PROSPECTOR_EXA_API_KEY'))
env_apollo = bool(os.getenv('PROSPECTOR_APOLLO_API_KEY'))
env_attio = bool(os.getenv('PROSPECTOR_ATTIO_API_KEY'))
if not config_path.exists():
    print('NOT_FOUND')
else:
    with open(config_path) as f:
        config = json.load(f)
    print('FOUND')
    print(f'exa: {bool(config.get(\"exa_api_key\"))}')
    print(f'apollo: {bool(config.get(\"apollo_api_key\"))}')
    print(f'attio: {bool(config.get(\"attio_api_key\"))}')
print(f'env_exa: {env_exa}')
print(f'env_apollo: {env_apollo}')
print(f'env_attio: {env_attio}')
"
```

If NOT_FOUND and env vars are not set, tell user to run `/prospector:setup` first.

### Step 2: Ask ICP Questions

Use AskUserQuestion to collect ICP criteria in order:

**Question 1: Industry**
```
header: "Industry"
question: "What industry are you targeting?"
options:
  - label: "SaaS"
    description: "Software as a Service companies"
  - label: "Fintech"
    description: "Financial technology companies"
  - label: "Healthcare"
    description: "Healthcare and health tech"
  - label: "E-commerce"
    description: "Online retail and marketplaces"
  - label: "AI/ML"
    description: "Artificial intelligence and machine learning"
  - label: "Any"
    description: "No industry filter"
multiSelect: false
```

**Question 2: Company Size**
```
header: "Size"
question: "What company size are you targeting?"
options:
  - label: "1-10"
    description: "Early stage startups"
  - label: "11-50"
    description: "Seed to Series A"
  - label: "51-200"
    description: "Series A to B"
  - label: "201-500"
    description: "Growth stage"
  - label: "500+"
    description: "Enterprise"
  - label: "Any"
    description: "No size filter"
multiSelect: false
```

**Question 3: Funding Stage**
```
header: "Funding"
question: "What funding stage are you targeting?"
options:
  - label: "Pre-seed"
    description: "Pre-product market fit"
  - label: "Seed"
    description: "Building initial product"
  - label: "Series A"
    description: "Scaling product"
  - label: "Series B+"
    description: "Growth and expansion"
  - label: "Any"
    description: "No funding filter"
multiSelect: false
```

**Question 4: Geography**
```
header: "Geography"
question: "What geography are you targeting?"
options:
  - label: "United States"
    description: "US-based companies"
  - label: "Europe"
    description: "European companies"
  - label: "Global"
    description: "Worldwide"
  - label: "Any"
    description: "No geography filter"
multiSelect: false
```

**Question 5: Keywords (optional)**
```
header: "Keywords"
question: "Any specific keywords that should appear in company descriptions? (optional)"
options:
  - label: "Skip"
    description: "No keyword filter"
  - label: "Enter keywords"
    description: "I'll type specific keywords"
multiSelect: false
```

If "Enter keywords", ask for the text input.

**Question 6: Contact Count**
```
header: "Count"
question: "How many contacts do you want to find?"
options:
  - label: "25"
    description: "Quick search, lower API usage"
  - label: "50"
    description: "Balanced (recommended)"
  - label: "100"
    description: "Larger batch, more API usage"
multiSelect: false
```

### Step 3: Run Search

Execute the Python script with the collected ICP:

```bash
cd [skill_directory]/scripts
python3 -c "
from prospector import run_search, export_csv, Config

icp = {
    'industry': '[INDUSTRY]',
    'company_size': '[SIZE]',
    'funding_stage': '[FUNDING]',
    'geography': '[GEOGRAPHY]',
    'keywords': '[KEYWORDS or empty string]'
}

leads = run_search(icp, num_contacts=[COUNT])
if leads:
    path = export_csv(leads)
    print(f'SUCCESS: {len(leads)} leads saved to {path}')
else:
    print('NO_RESULTS: No leads found matching criteria')
"
```

Replace placeholders with actual values from questions.

### Step 4: Attio Sync (if configured)

If Attio is configured and leads were found, ask:

```
header: "Attio"
question: "Sync leads to Attio CRM?"
options:
  - label: "Yes"
    description: "Sync companies and contacts to Attio"
  - label: "No"
    description: "Just keep the CSV"
multiSelect: false
```

If yes:

```bash
cd [skill_directory]/scripts
python3 -c "
from prospector import sync_to_attio, Config, Lead
import json

# Load leads from the CSV we just created (or pass them directly)
# For simplicity, re-run with sync
leads = [...]  # Pass leads from previous step

companies, people = sync_to_attio(leads)
print(f'SYNCED: {companies} companies, {people} contacts')
"
```

### Step 5: Report Results

Tell the user:
- How many leads were found
- Where the CSV was saved
- If Attio sync was done, how many records were synced

## Error Handling

- **Config not found**: Tell user to run `/prospector:setup`
- **Invalid API key**: Tell user which key failed, suggest re-running setup
- **No results**: Suggest broadening ICP criteria
- **Partial failures**: Report what succeeded, warn about failures
