# Prospector

A Claude Code skill for finding leads matching your ICP (Ideal Customer Profile).

**Workflow:** Define your ICP → Search companies via Exa → Enrich contacts via Apollo → Export to CSV (+ optional Attio sync)

## Installation

1. Clone this repo:
   ```bash
   git clone https://github.com/YOUR_USERNAME/prospector.git ~/.claude/skills/prospector
   ```

2. Install the Python dependency:
   ```bash
   pip install httpx
   ```

3. Get API keys:
   - **Exa** (required): https://exa.ai - Sign up for free tier
   - **Apollo** (required): https://apollo.io - Sign up for API access
   - **Attio** (optional): https://attio.com - If you want CRM sync

## Usage

### First-time Setup

Run the setup command to configure your API keys:

```
/prospector:setup
```

This will:
1. Ask for your Exa API key and validate it
2. Ask for your Apollo API key and validate it
3. Optionally ask for your Attio API key
4. Optionally set environment variables in your shell profile
5. Save keys securely to `~/.config/prospector/config.json` (chmod 600)

### Finding Leads

Run the main command:

```
/prospector
```

You'll be asked:
1. **Industry** - SaaS, Fintech, Healthcare, E-commerce, AI/ML, or Any
2. **Company Size** - 1-10, 11-50, 51-200, 201-500, 500+, or Any
3. **Funding Stage** - Pre-seed, Seed, Series A, Series B+, or Any
4. **Geography** - United States, Europe, Global, or Any
5. **Keywords** (optional) - Specific terms to look for
6. **Contact Count** - 25, 50, or 100

Results are saved to your Desktop as `prospector-leads-YYYY-MM-DD.csv`.

### CSV Output

The CSV includes:
- `company_name` - Company name
- `company_domain` - Company website domain
- `company_size` - Employee count range
- `industry` - Industry vertical
- `location` - Contact's location
- `contact_name` - Full name
- `contact_title` - Job title
- `contact_email` - Email address
- `contact_linkedin` - LinkedIn profile URL
- `source` - Data source (exa+apollo)

### Attio CRM Sync

If you configured Attio during setup, you'll be asked after each search if you want to sync the leads. This will:
- Create/update Companies in Attio (matched by domain to avoid duplicates)
- Create People linked to their companies

## CLI Usage

You can also run the script directly:

```bash
cd ~/.claude/skills/prospector/scripts

python prospector.py \
  --industry "SaaS" \
  --size "51-200" \
  --funding "Series A" \
  --geography "United States" \
  --keywords "AI automation" \
  --count 50 \
  --sync-attio
```

## Configuration

Config is stored at `~/.config/prospector/config.json`:

```json
{
  "exa_api_key": "your-exa-key",
  "apollo_api_key": "your-apollo-key",
  "attio_api_key": "your-attio-key"
}
```

The file is automatically set to `chmod 600` (owner read/write only).

### Environment Variables (Recommended)

You can set keys as environment variables instead of (or in addition to) the config file:

```bash
export PROSPECTOR_EXA_API_KEY="your-exa-key"
export PROSPECTOR_APOLLO_API_KEY="your-apollo-key"
export PROSPECTOR_ATTIO_API_KEY="your-attio-key"  # optional
```

Environment variables take precedence over the config file.

## API Usage

- **Exa**: ~1 API call per search (returns up to 100 companies)
- **Apollo**: ~1 API call per company (returns up to 3 contacts each)
- **Attio**: 1 API call per company + 1 per contact for sync

For 50 contacts, expect roughly:
- 1 Exa call
- 17-25 Apollo calls
- 17-25 Attio company calls + 50 Attio people calls (if syncing)

## Troubleshooting

**"Run /prospector:setup first"**
- You haven't configured API keys yet. Run `/prospector:setup`.

**"Config has insecure permissions"**
- Run `chmod 600 ~/.config/prospector/config.json`

**"Apollo enrichment failed"**
- Apollo may not have data for that company, or you've hit rate limits.
- The skill continues with partial data.

**"No companies found"**
- Try broadening your ICP criteria (use "Any" for some filters).

## License

MIT
