# Proposal Writing — Confirmation-First Closing Framework

Write proposals that confirm verbal agreements and close deals, not proposals that try to sell.
Sources: Consulting Success (reviewed 100s of proposals, 60%+ win rate benchmark), Aura/Prosal (2024 survey: 30% RFP win rate), McKinsey SCR framework, Melisa Liberman.
All outputs go to `workspace/artifacts/`.

## Use when
- Writing a proposal after a discovery call where the client verbally agreed
- Crafting Upwork proposals for fixed-price or hourly jobs
- Formalizing a service agreement (like Alfred's automation)
- Responding to an RFP with a structured bid
- Reviewing/improving an existing proposal before sending

## Don't use when
- You haven't done discovery yet (use client-discovery skill first)
- Cold outreach (use cold-outreach skill — proposals come after interest)
- Pricing strategy (use pricing-psychology skill for the pricing, this skill for the wrapper)
- Writing internal project plans (different audience, different format)

## Negative examples
- "Help me find clients" → No. This is for closing, not finding.
- "Write a business plan" → No. Business plans and proposals are different documents.
- "Send a follow-up email" → Borderline. Use cold-outreach for follow-ups.

## Edge cases
- Upwork cover letter → YES. It's a micro-proposal. Same principles, compressed format.
- "They haven't said yes yet" → STOP. Get a verbal yes first, then send the proposal to confirm it.
- Informal text/email agreement → YES. Even a brief "Here's what we discussed + next steps" is a proposal.

---

## The #1 Mistake: Proposals That Sell

**Consulting Success (from reviewing hundreds of proposals):**

> "Your consulting proposal isn't a sales tool. It's a confirmation tool. The selling happens before the proposal."

Most consultants win less than 60% of their proposals. The top performers win 80-90%. The difference? Top performers only send proposals after getting a **verbal yes**.

### The Right Sequence
```
Discovery call → verbal agreement → proposal confirms → signed
```

### The Wrong Sequence
```
Discovery call → send proposal hoping it convinces them → silence
```

If you're sending proposals to people who haven't said "yes" yet, you're wasting time. Go back to discovery.

---

## The SCR Proposal Framework

**Situation → Complication → Resolution** (used by McKinsey, BCG, Bain)

This mirrors how decisions are made naturally:

1. **Situation**: "Here's where you are" (recap their context)
2. **Complication**: "Here's what's in the way" (the problem + cost of inaction)
3. **Resolution**: "Here's how we fix it" (your solution + expected outcomes)

---

## Proposal Structure (7 Sections)

### 1. Executive Summary (3-5 sentences)
The most important section. Many decision-makers read ONLY this.

**Formula:**
```
[Client name] is facing [specific problem] which is costing [quantified impact].
Our proposed approach [brief method] will deliver [specific outcome] within [timeframe].
Investment: [price]. Next step: [action].
```

**Rules:**
- Write it LAST (after you've written everything else)
- No jargon
- Must stand alone — if they read nothing else, this closes
- Include the price here (don't make them hunt for it)

### 2. Understanding of the Problem
Prove you listened during discovery. Use their exact words.

```
Based on our conversation on [date], [Client] is experiencing:
- [Problem 1 — in their language]
- [Problem 2 — quantified if possible]
- [Impact: what this costs them in time/money/customers]
```

**Why this works:** When a client reads their own words back to them, trust skyrockets. They feel understood.

### 3. Proposed Solution
What you'll do, step by step. Be specific but not overwhelming.

```
Phase 1: [Deliverable] — [Timeline]
Phase 2: [Deliverable] — [Timeline]
Phase 3: [Deliverable] — [Timeline]
```

**Rules:**
- 3-5 phases maximum
- Each phase has a clear deliverable (noun, not verb — "Automated SMS system" not "Working on SMS")
- Include what's NOT included (prevents scope creep)

### 4. Expected Outcomes / ROI
Quantify the value of your solution in their terms.

```
Based on [data from discovery]:
- [Outcome 1]: Save [X hours/week] = $[Y/month]
- [Outcome 2]: Capture [X additional clients/month] = $[Y/month]
- Total projected value: $[Z/month]
- Investment: $[price/month]
- ROI: [X]x return
```

**Anchoring trick (from pricing-psychology):** Always show the value before the price. $500/month in captured bookings makes $149/month feel like a no-brainer.

### 5. Investment (Pricing)
State the price clearly. No hiding, no apologizing.

**Options structure (from pricing-psychology):**

| Option | What's Included | Price |
|--------|----------------|-------|
| Starter | Core solution only | $X |
| Growth (recommended) | Core + extras | $Y |
| Scale | Everything + premium | $Z |

**Rules:**
- Use the word "investment," not "cost" or "fee" (frames as value, not expense)
- If offering tiers, bold or highlight the recommended option
- Include payment terms (monthly, milestone-based, upfront discount)

### 6. Timeline & Next Steps
```
Week 1: [Setup/onboarding]
Week 2-3: [Build/implement]
Week 4: [Launch/go-live]
Ongoing: [Support/optimization]
```

End with a clear call to action:
"To proceed, [sign below / reply to this email / schedule kickoff call]. We can begin as early as [date]."

### 7. About Us / Credibility (Brief)
Keep this SHORT. 2-3 sentences + one relevant result.

```
[Your name/company] specializes in [relevant expertise].
Recent result: [Specific client outcome with numbers].
```

**Don't:** Write a full company history. They don't care. They care about results.

---

## Upwork Proposal Template (Micro-Format)

Upwork proposals are mini-proposals. Same principles, 150-300 words:

```
[Opening — reference THEIR job post specifically, not generic]

Hi [name if visible],

I read your post about [specific need]. [One sentence proving you understand the problem.]

[Credibility — one relevant result]
I recently built [similar thing] for [type of client] — [specific outcome].

[Approach — 2-3 sentences on HOW you'd do it]
For your project, I'd [step 1], then [step 2], delivering [outcome] within [timeframe].

[De-risk]
Happy to start with [small milestone] so you can evaluate before committing to the full scope.

[CTA]
Can we hop on a quick call to clarify [1 specific question from the post]?

[Name]
```

**Upwork-specific tips:**
- First 2 lines are visible before "Read more" — make them count
- Ask a question (shows engagement, invites response)
- Reference the budget range (shows you read the post)
- Keep under 250 words (long proposals get skimmed)

---

## Proposal Delivery Checklist

Before sending any proposal:

- [ ] Verbal "yes" obtained (or at minimum, strong buying signal)
- [ ] Problem statement uses client's exact words from discovery
- [ ] Price appears after value/ROI section (anchoring)
- [ ] Clear next step with specific date
- [ ] Scope boundaries defined (what's NOT included)
- [ ] Proofread — typos kill credibility
- [ ] Sent within 24-48 hours of discovery call (momentum matters)
- [ ] Follow-up scheduled for 3 days after sending

---

## Common Proposal Killers (Consulting Success)

1. **Too long** — 2-3 pages max for freelance/small consulting. Enterprise RFPs are different.
2. **Written for you, not them** — Every section should answer "so what?" from the client's perspective.
3. **No price** — Burying or omitting the price wastes everyone's time.
4. **No timeline** — "We'll figure it out" is not a plan.
5. **Sent without verbal agreement** — Win rate plummets from 80%+ to <30%.
6. **No follow-up** — 50% of deals are won in the follow-up, not the initial send.
7. **Scope creep baked in** — If you promise everything, you'll deliver nothing well.

---

## Key Numbers
- Average RFP win rate: ~30% (Prosal 2024 survey)
- Top consultants with verbal-first approach: 80-90% win rate
- Proposals sent within 24 hours of call convert significantly better than 48+ hours
- Optimal proposal length: 2-3 pages (freelance), 5-10 pages (enterprise)
- Follow-up within 3 days increases close rate substantially
