---
name: proposal-writing
description: Write winning proposals and quotes for a solopreneur business. Use when putting together a proposal for a potential client, structuring a sales document, pricing a project scope, or improving proposal win rates. Covers proposal structure, scoping, pricing presentation, objection pre-emption, and the psychology of persuasive proposals. Trigger on "write a proposal", "proposal template", "sales proposal", "quote for client", "how to structure a proposal", "proposal writing", "win more proposals", "client proposal".
---

# Proposal Writing

## Overview
A proposal is not a quote. A quote is a price list. A proposal is a persuasion document that makes the client feel confident, understood, and excited about working with you — and then makes paying feel like the obvious next step. This playbook builds proposals that win, structured around how buyers actually make decisions.

---

## Step 1: Before You Write Anything — The Discovery Checklist

A great proposal is 80% listening and 20% writing. Before drafting, confirm you have answers to every one of these from your discovery conversation:

```
DISCOVERY CHECKLIST
====================
- [ ] What specific problem is the client trying to solve?
- [ ] What outcome do they want? (Be specific — not "better results")
- [ ] What have they already tried? What didn't work and why?
- [ ] What is the cost of NOT solving this? (In time, money, missed opportunity)
- [ ] What is their timeline / deadline? Is there urgency?
- [ ] Who else is involved in the decision? (Decision-maker vs. influencer)
- [ ] Have they worked with anyone like you before? What was that experience?
- [ ] What does "success" look like to them in 3 months / 6 months?
- [ ] What is their budget range? (Even a rough number helps structure pricing)
- [ ] What are their biggest concerns or hesitations about moving forward?
```

**If you can't answer most of these, you don't have enough information to write a strong proposal. Ask for a follow-up call before writing.**

---

## Step 2: Proposal Structure (In This Exact Order)

The order matters. Each section builds on the one before it, moving the client from "I feel understood" to "I'm ready to say yes."

### Section 1: Cover Page
- Their company name (not yours — make it about them)
- Project title (something descriptive and inspiring, not "Proposal for Services")
- Date
- Your name and logo (small — this is their document)
- Optional: a one-line summary of the outcome you'll deliver

### Section 2: Executive Summary (The Most-Read Section)
Many clients read ONLY this section. Make it count.

Write 3-4 sentences that:
1. Restate THEIR problem back to them (shows you listened)
2. State the outcome you'll deliver (the "after" picture)
3. Give a one-sentence summary of your approach
4. State the investment (price) and timeline

**If they read nothing else, this section alone should make them want to say yes.**

### Section 3: Understanding Your Challenge
This is where you prove you actually listened during discovery. Restate their problem, their context, and their goals in YOUR words. Do not copy-paste from their brief — reframe it to show understanding.

Structure:
- **Their current situation** — where they are now
- **The pain** — what this situation is costing them (quantify if possible)
- **Their goal** — where they want to be
- **The gap** — the distance between now and the goal that you'll bridge

**This section does more to build trust than anything else in the proposal.** If the client reads this and thinks "they actually get it," you've already won halfway.

### Section 4: Our Approach
Explain HOW you'll solve their problem. This is not a feature list — it's a narrative. Walk them through what will happen, step by step, from their perspective.

Structure:
- **Phase 1:** [What happens first, why, and what the client can expect]
- **Phase 2:** [Next step]
- **Phase 3:** [Final delivery or ongoing work]

For each phase, include: what you do, what they need to do (their involvement), and what the output looks like.

**Keep it high-level.** Too much technical detail buries the value. Save the deep details for after they sign.

### Section 5: What You'll Get (Deliverables)
A clear, bulleted list of exactly what they receive. This is the "contract" section that clients refer back to. Be specific:

- NOT: "Website redesign"
- YES: "5-page responsive website (homepage, about, services, blog, contact) with mobile optimization, SEO-optimized page structure, and 2 rounds of revisions"

### Section 6: Investment (Pricing)
Put this AFTER the value sections — never lead with price. By the time they get here, they should already understand what they're getting and why it matters.

**Pricing presentation rules:**
- Present ONE recommended option first (your preferred scope and price). Then offer 1-2 alternatives (a stripped-down version or an expanded version).
- Anchor high → recommend middle → offer low. The middle option should be where you want them to land.
- Frame price in terms of ROI where possible: "At $X/month, this pays for itself in the first week based on the 5 hours/week you told us you're currently spending on [problem]."
- Include what's NOT included (scope boundaries). This prevents scope creep and surprises later.

**Pricing option template:**
```
OPTION A — [Name that implies scope, e.g., "Essential"]
  Includes: [deliverables]
  Investment: $[amount]
  Timeline: [weeks]

OPTION B — [Recommended ★] — [Name, e.g., "Complete"]
  Includes: [deliverables — superset of Option A]
  Investment: $[amount]
  Timeline: [weeks]

OPTION C — [Name, e.g., "Enterprise / Full-Service"]
  Includes: [deliverables — everything + extras]
  Investment: $[amount]
  Timeline: [weeks]
```

### Section 7: Why Us (Social Proof)
Brief. 2-3 bullet points max. This is NOT the place for a long bio.

- A relevant case study or result ("Helped [similar company] achieve [specific result] in [timeframe]")
- A relevant credential or experience
- A testimonial quote (if you have one from a similar client)

**Put this AFTER pricing, not before.** It functions as final confidence-building right before the decision, not as a sales pitch.

### Section 8: Next Steps
Make it crystal clear what happens if they say yes. Remove ALL friction from the decision.

```
If you'd like to move forward:
  1. Reply to this email with "Let's do it" (or sign the attached contract)
  2. We'll schedule a kickoff call within [X days]
  3. [First deliverable or milestone] will be ready by [date]
```

**Include a deadline or a gentle urgency signal:** "This proposal is valid for 14 days. After that, availability and pricing may change." This is honest (your availability IS limited as a solopreneur) and creates gentle urgency.

---

## Step 3: Proposal Design and Delivery

**Format:** PDF. Always. Not a Google Doc link, not a Word doc. A polished PDF signals professionalism.

**Design rules:**
- Clean, minimal design. White space is your friend.
- Use your brand colors and fonts (from brand-identity).
- No walls of text. Use short paragraphs, bullet points for deliverables, and clear section headers.
- Include a cover image or illustration that's relevant to their industry.

**Delivery:**
- Send via email with a short, warm cover message (2-3 sentences max).
- Walk them through the proposal on a call if possible (talking through it live dramatically increases win rates).
- Follow up within 24-48 hours if they haven't responded.

---

## Step 4: Handle Common Objections In Advance

A great proposal pre-empts objections so they never need to be raised. Weave these into the relevant sections:

| Objection | Pre-emption |
|---|---|
| "This is too expensive" | Anchor with ROI. Show the cost of NOT acting. Offer a lower-scope option. |
| "We need time to think about it" | Add a validity deadline. Offer a call to answer questions. |
| "Can you do it cheaper?" | Build in a stripped-down option that's already cheaper. Show what gets cut and why. |
| "We don't know if we need this yet" | Section 3 (Understanding Your Challenge) should make the need undeniable. |
| "We've had bad experiences with freelancers before" | Section 7 (Why Us) with specific proof of delivery. Offer a milestone-based payment structure. |

---

## Proposal Mistakes to Avoid
- Writing a generic proposal and swapping in the client's name. Clients can tell. Every proposal should feel custom-written for them specifically.
- Leading with your story or credentials. Lead with THEIR problem. Earn the right to talk about yourself later.
- Burying the price. Put it in a clear, dedicated section. Hiding it erodes trust.
- Giving only one price. Options create anchoring and give the client a sense of control.
- Not following up. The proposal is not the end of the conversation — it's the beginning of the closing conversation.
