---
name: proposal-generator
description: Create professional, persuasive proposals from client briefs. Generates structured proposals with executive summaries, scope of work, timelines, pricing tiers, and terms. Use when responding to RFPs, pitching new clients, or creating standardized proposal templates for your services.
---

# Proposal Generator

Win more deals with proposals that sell. This skill transforms client briefs into professional, persuasive proposals with clear scope, compelling value, and pricing that converts.

## What It Does

- **Brief Analysis**: Extract requirements, constraints, and success criteria
- **Executive Summary**: Hook the reader with outcomes, not activities
- **Scope of Work**: Detailed deliverables with clear boundaries
- **Timeline & Milestones**: Realistic schedules with buffer built in
- **Pricing Tiers**: Good/better/best options that anchor value
- **Terms & Conditions**: Protect yourself without being adversarial
- **Case Studies**: Relevant proof points that build trust

## Quick Start

### 1. From Client Brief

```
"Create a proposal based on this client brief:
[paste brief/email]

My services: [web design/development/consulting/etc.]
Typical rate: [$X/hour or $Y/project]
Timeline preference: [2 weeks/1 month/etc.]
Include: 3 pricing tiers, case study, terms"
```

### 2. From Discovery Call Notes

```
"Generate a proposal from these call notes:
[paste notes]

Key points discussed:
- Budget range: $X-$Y
- Timeline: [urgent/standard/flexible]
- Decision maker: [name/role]
- Main pain point: [problem]
- Success looks like: [outcome]

Proposed solution: [your approach]"
```

### 3. Template Creation

```
"Create a reusable proposal template for my [service] business.

Sections needed:
- Cover letter
- Executive summary
- Scope of work
- Investment (3 tiers)
- Timeline
- About me/us
- Case studies
- Terms & conditions
- Next steps

Tone: Professional but personable
Target: [industry/client type]"
```

## The Proposal Structure

### 1. Cover Letter (1 page)

**Purpose**: Personal connection + preview of value

**Template**:
```
[Date]

[Client Name]
[Company]
[Address]

Dear [Name],

Thank you for the opportunity to submit this proposal for [project name].

After our [call/meeting/discussion], I'm excited about the possibility of working together to [achieve specific outcome]. This proposal outlines how I can help you [solve problem] and [achieve goal].

What makes this project exciting to me: [personalized connection to their situation]

I've structured this proposal to give you three options based on different levels of engagement. Each tier delivers clear value, and you can choose the approach that best fits your current needs and budget.

I look forward to your feedback and am happy to discuss any questions you may have.

Best regards,

[Your name]
[Contact info]
```

### 2. Executive Summary (1 page)

**Purpose**: Decision-makers read this first (and maybe only)

**Structure**:
- **The Challenge**: 2-3 sentences on their problem
- **The Solution**: Your approach in plain English
- **The Outcome**: Specific, measurable results they'll get
- **The Investment**: Price range (save details for later)
- **The Timeline**: Key milestones
- **Why Me**: 1-2 sentences of differentiation

**Example**:
```
Executive Summary

[Client] needs a modern, conversion-focused website that reflects their 
brand and drives qualified leads. Their current site is outdated, 
mobile-unfriendly, and not generating business.

I will design and develop a custom WordPress website with clear user 
flows, compelling copy, and integrated analytics. The new site will 
position [Client] as the premium option in their market.

Expected outcomes:
• 40%+ increase in contact form submissions
• Mobile traffic conversion improvement
• Page load time under 2 seconds
• SEO-optimized structure for organic growth

Investment: $8,500 - $15,000 (three tiers detailed below)
Timeline: 6-8 weeks from kickoff

With 8+ years designing websites for [industry] companies, I understand 
your market and what converts your specific audience.
```

### 3. Scope of Work (2-3 pages)

**Purpose**: Exactly what's included (and what's not)

**Format**: Table or structured list

**Example**:
```
Phase 1: Discovery & Strategy (Week 1)
├── Stakeholder interviews (up to 3)
├── Competitor analysis
├── User persona development
├── Content audit
└── Strategy document delivery

Phase 2: Design (Weeks 2-3)
├── Wireframes (homepage + 3 key pages)
├── Visual design mockups
├── 2 rounds of revisions
└── Design system documentation

Phase 3: Development (Weeks 4-6)
├── WordPress theme development
├── Responsive implementation
├── CMS setup and training
├── Analytics configuration
└── SEO optimization

Phase 4: Launch (Week 7)
├── Quality assurance testing
├── Content migration
├── Launch coordination
├── Post-launch monitoring
└── 30-day support period

What's Not Included:
× Copywriting (can add for $2,000)
× Photography (stock images included)
× Ongoing maintenance (available separately)
× Third-party tool subscriptions
```

### 4. Investment & Pricing Tiers (1 page)

**Purpose**: Present options that guide toward middle tier

**The Three-Tier Structure**:

| Tier | Name | Price | Best For |
|------|------|-------|----------|
| 1 | Essential | $8,500 | Tight budget, core needs only |
| 2 | Professional | $12,500 | Most clients, full solution |
| 3 | Premium | $18,500 | Maximum impact, priority support |

**Tier Comparison Table**:

```
                    Essential    Professional    Premium
Discovery           ✓            ✓               ✓
Custom Design       3 pages      6 pages         10 pages
Revisions           2 rounds     3 rounds        Unlimited
CMS Training        Video        Live session    1:1 training
Support Period      30 days      60 days         90 days
Response Time       48 hours     24 hours        Same day
Strategy Calls      -            Monthly         Weekly
Priority Queue      -            -               ✓

Investment          $8,500       $12,500         $18,500
Timeline            6 weeks      7 weeks         8 weeks
```

**Pricing Psychology Tips**:
- **Anchor high**: Premium tier makes Professional look reasonable
- **Middle bias**: Most people choose middle option
- **Decoy effect**: Make Essential clearly "less than you need"
- **Value stacking**: List everything included, even obvious items

### 5. Timeline & Milestones (1 page)

**Purpose**: Set expectations and create accountability

**Visual Timeline**:
```
Week 1    Week 2    Week 3    Week 4    Week 5    Week 6    Week 7
|---------|---------|---------|---------|---------|---------|
[Discovery][====Design====][=====Development=====][Launch]

Milestones:
• Week 1: Strategy approved
• Week 3: Design approved
• Week 6: Development complete
• Week 7: Site launched
```

**Assumptions**:
- Client feedback within 48 hours
- Content provided by Week 3
- No scope changes after Week 3 approval
- Third-party access granted by kickoff

### 6. About Me/Us (1 page)

**Purpose**: Build trust and credibility

**Structure**:
- **Headline**: Not "About Me" — "Why Work With Me"
- **Story**: 2-3 sentences on your background
- **Relevant Experience**: Specific to their industry/problem
- **Results**: Quantified achievements
- **Process**: How you work (collaborative, transparent, etc.)
- **Personal**: One humanizing detail

### 7. Case Studies (1-2 pages)

**Purpose**: Proof that you deliver results

**Format** (per case study):
```
[Client Name] — [Brief outcome statement]

Challenge:
[Specific problem they faced]

Solution:
[What you did]

Results:
• Metric 1: X% improvement
• Metric 2: $Y saved/earned
• Metric 3: Specific outcome

Testimonial:
"[Quote from client]" — Name, Title
```

### 8. Terms & Conditions (1 page)

**Purpose**: Protect both parties

**Key Clauses**:
- **Payment Terms**: 50% deposit, 50% on completion (or milestone-based)
- **Scope Changes**: Hourly rate for out-of-scope work
- **Timeline**: Client delays extend delivery date
- **Intellectual Property**: Transfer on final payment
- **Cancellation**: Deposit forfeiture after work begins
- **Limitation of Liability**: Cap on damages

**Sample Payment Terms**:
```
Payment Schedule:
• 50% deposit ($6,250) due upon contract signing
• 25% ($3,125) due at design approval
• 25% ($3,125) due at project completion

Late payments subject to 1.5% monthly service charge.
Work pauses if payment is more than 7 days overdue.
```

### 9. Next Steps (1/2 page)

**Purpose**: Clear call to action

**Template**:
```
Next Steps

To move forward:

1. Review this proposal and select your preferred tier
2. Sign the attached agreement
3. Submit your deposit via [payment method]
4. Schedule kickoff call: [calendar link]

I'm available to discuss any questions:
• Email: [email]
• Phone: [phone]
• Calendar: [link]

This proposal is valid for 30 days from the date above.

Looking forward to working together,

[Signature]
[Name]
```

## Proposal Formulas by Service Type

### Consulting Proposals

**Structure**:
- Discovery/Assessment
- Recommendations
- Implementation support
- Knowledge transfer

**Pricing**: Daily rate or project fee
**Key differentiator**: Depth of expertise, methodology

### Development Proposals

**Structure**:
- Technical architecture
- Feature specifications
- Testing & QA
- Deployment & training

**Pricing**: Fixed bid with change order process
**Key differentiator**: Technical approach, past similar projects

### Design Proposals

**Structure**:
- Research & discovery
- Concept development
- Design iterations
- Production & delivery

**Pricing**: Per deliverable or project fee
**Key differentiator**: Creative process, portfolio quality

### Marketing Proposals

**Structure**:
- Audit & analysis
- Strategy & planning
- Execution
- Measurement & optimization

**Pricing**: Retainer or performance-based
**Key differentiator**: Track record, industry expertise

## Advanced Techniques

### The "Choice of Three" Strategy

Always present 3 options:
- **Option 1**: Budget (they feel smart for considering it)
- **Option 2**: Sweet spot (where you want them)
- **Option 3**: Premium (makes Option 2 look reasonable)

### Urgency Without Pressure

```
"This proposal is valid for 30 days. After that, my availability 
and pricing may change."
```

### Risk Reversal

```
"If you're not satisfied with the initial design concepts, you can 
walk away and receive a full refund of your deposit."
```

### Social Proof Integration

- Logos of past clients
- Testimonials throughout (not just in case studies)
- "As seen in" media mentions
- Awards/certifications

## Common Mistakes

1. **Leading with features** — lead with outcomes
2. **One-size-fits-all** — customize for each client
3. **Hiding the price** — be transparent
4. **No clear scope** — vague proposals = scope creep
5. **Missing next steps** — tell them exactly what to do
6. **Too long** — 6-10 pages max for most projects
7. **No follow-up plan** — schedule the follow-up before sending

## Integration Ideas

- Connect to **client-intake-bot** to auto-generate proposals from qualified leads
- Use with **invoice-tracker** to manage proposal-to-payment workflow
- Pair with **content-repurposer** to create case study content

## Monetization Note

This skill is part of the **Freelancer Revenue Engine**. For maximum value, use alongside:
- `client-intake-bot` — qualify leads before proposing
- `invoice-tracker` — manage payments post-close

Bundle available: Freelancer Revenue Engine ($89)
