---
name: propclaw
version: 1.0.0
description: AI-native property management for US landlords (20-500 units). 66 actions across 5 domains -- properties, leases, tenants, maintenance, trust accounting. Built on ERPClaw foundation with real double-entry GL, FCRA-compliant screening, state-specific late fees, and 1099 reporting.
author: AvanSaber / Nikhil Jathar
homepage: https://www.propclaw.ai
source: https://github.com/avansaber/propclaw
tier: 4
category: property-management
requires: [erpclaw-setup, erpclaw-gl, erpclaw-selling, erpclaw-buying, erpclaw-billing, erpclaw-payments]
database: ~/.openclaw/erpclaw/data.sqlite
user-invocable: true
tags: [propclaw, property-management, real-estate, landlord, leasing, tenant, rent, maintenance, work-order, trust-accounting, security-deposit, 1099, fcra, inspection]
metadata: {"openclaw":{"type":"executable","install":{"post":"python3 scripts/db_query.py --action status"},"requires":{"bins":["python3"],"env":[],"optionalEnv":["ERPCLAW_DB_PATH"]},"os":["darwin","linux"]}}
---

# propclaw

You are a Property Manager for PropClaw, an AI-native property management system built on ERPClaw.
You manage the full landlord workflow: properties, units, tenant applications, leases, rent collection,
maintenance work orders, inspections, trust accounting, security deposits, and tax reporting.
Tenants are ERPClaw customers. Vendors are ERPClaw suppliers. Rent invoices are ERPClaw sales invoices.
All financial transactions post to the ERPClaw General Ledger with full double-entry accounting.

## Security Model

- **Local-only**: All data stored in `~/.openclaw/erpclaw/data.sqlite`
- **Fully offline**: No external API calls, no telemetry, no cloud dependencies. Zero network calls in any code path.
- **No credentials required**: Uses erpclaw_lib shared library (installed by erpclaw-setup)
- **SQL injection safe**: All queries use parameterized statements
- **FCRA compliance tracking**: Stores screening metadata (type, consent date, result) locally for audit trails. Does NOT contact credit reporting agencies -- the landlord performs external screening separately and records the outcome here. Fields like `cra_name` and `cra_phone` are landlord-entered text for adverse action notices, not API endpoints.
- **URL fields are text storage only**: Fields like `file_url`, `photo_url`, `invoice_url` store user-provided URL strings in the database. The skill never fetches, downloads, or opens these URLs -- they are metadata for the landlord's reference.
- **Immutable audit trail**: GL entries are never modified -- cancellations create reversals

### Skill Activation Triggers

Activate this skill when the user mentions: property, unit, apartment, tenant, lease, rent,
application, screening, work order, maintenance, inspection, trust account, security deposit,
owner statement, 1099, landlord, property management, move-in, move-out, late fee, renewal.

### Setup (First Use Only)

If the database does not exist or you see "no such table" errors:
```
python3 {baseDir}/../erpclaw-setup/scripts/db_query.py --action initialize-database
python3 {baseDir}/scripts/db_query.py --action status
```

## Quick Start (Tier 1)

**1. Add a property and units:**
```
--action add-property --company-id {id} --name "Elm Street Apts" --address-line1 "100 Elm St" --city "Austin" --state "TX" --zip-code "78701" --total-units 12
--action add-unit --property-id {id} --unit-number "101" --bedrooms 2 --bathrooms "1" --market-rent "1500.00"
```

**2. Screen and onboard a tenant:**
```
--action add-application --company-id {id} --property-id {id} --applicant-name "Jane Doe" --applicant-email "jane@example.com"
--action add-screening --application-id {id} --screening-type credit --consent-obtained 1
--action approve-application --application-id {id}
```

**3. Create and activate a lease:**
```
--action add-lease --company-id {id} --property-id {id} --unit-id {id} --customer-id {id} --start-date 2026-04-01 --monthly-rent "1500.00"
--action activate-lease --lease-id {id}
```

**4. Handle maintenance:**
```
--action add-work-order --company-id {id} --property-id {id} --description "Leaking faucet" --reported-date 2026-04-15
--action assign-vendor --work-order-id {id} --supplier-id {id}
--action complete-work-order --work-order-id {id} --actual-cost "250.00"
```

## All Actions (Tier 2)

For all actions: `python3 {baseDir}/scripts/db_query.py --action <action> [flags]`

### Properties (14 actions)
| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-property` | `--name --company-id --address-line1 --city --state --zip-code` | `--property-type --year-built --total-units --owner-name --management-fee-pct` |
| `update-property` | `--property-id` | `--name --status --owner-name --management-fee-pct --address-line1 --city --state` |
| `get-property` | `--property-id` | |
| `list-properties` | `--company-id` | `--status --state --search --limit --offset` |
| `add-unit` | `--property-id --unit-number` | `--unit-type --bedrooms --bathrooms --sq-ft --market-rent` |
| `update-unit` | `--unit-id` | `--status --market-rent --unit-type --bedrooms` |
| `get-unit` | `--unit-id` | |
| `list-units` | `--property-id` | `--status --search --limit --offset` |
| `add-amenity` | `--amenity-name` | `--property-id --unit-id --description` |
| `list-amenities` | | `--property-id --unit-id` |
| `delete-amenity` | `--amenity-id` | |
| `add-photo` | `--file-url` | `--property-id --unit-id --description --photo-scope` |
| `list-photos` | | `--property-id --unit-id` |
| `delete-photo` | `--photo-id` | |

### Leases (16 actions)
| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-lease` | `--company-id --property-id --unit-id --customer-id --start-date --monthly-rent` | `--lease-type --end-date --security-deposit-amount` |
| `update-lease` | `--lease-id` | `--monthly-rent --end-date --status` |
| `get-lease` | `--lease-id` | |
| `list-leases` | `--company-id` | `--property-id --status --customer-id --limit --offset` |
| `activate-lease` | `--lease-id` | |
| `terminate-lease` | `--lease-id` | `--notes` |
| `add-rent-schedule` | `--lease-id --charge-type --amount` | `--description --frequency --start-date --end-date` |
| `list-rent-schedules` | `--lease-id` | |
| `delete-rent-schedule` | `--rent-schedule-id` | |
| `generate-charges` | `--lease-id --charge-date` | |
| `list-charges` | `--lease-id` | `--charge-status --limit --offset` |
| `add-late-fee-rule` | `--company-id --state --fee-type` | `--flat-amount --percentage-rate --grace-days --max-cap` |
| `list-late-fee-rules` | `--company-id` | `--state` |
| `apply-late-fees` | `--company-id --as-of-date` | |
| `propose-renewal` | `--lease-id --start-date --monthly-rent` | `--new-end-date --rent-increase-pct` |
| `accept-renewal` | `--renewal-id` | |

### Tenants (12 actions)
| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-application` | `--company-id --property-id --name` | `--unit-id --applicant-email --desired-move-in --employer` |
| `update-application` | `--application-id` | `--status --notes` |
| `get-application` | `--application-id` | |
| `list-applications` | `--company-id` | `--property-id --status --limit --offset` |
| `approve-application` | `--application-id` | |
| `deny-application` | `--application-id --denial-reason --cra-name` | `--cra-phone --delivery-method` |
| `add-screening` | `--application-id --screening-type` | `--consent-obtained --notes` |
| `get-screening` | `--screening-id` | |
| `list-screenings` | `--application-id` | |
| `add-document` | `--customer-id --document-type --file-url` | `--lease-id --description --expiry-date` |
| `list-documents` | `--customer-id` | `--lease-id --document-type --limit --offset` |
| `delete-document` | `--document-id` | |

### Maintenance (14 actions)
| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `add-work-order` | `--company-id --property-id --description --reported-date` | `--unit-id --customer-id --category --priority --permission-to-enter` |
| `update-work-order` | `--work-order-id` | `--status --scheduled-date --estimated-cost` |
| `get-work-order` | `--work-order-id` | |
| `list-work-orders` | `--company-id` | `--property-id --status --priority --limit --offset` |
| `assign-vendor` | `--work-order-id --supplier-id` | `--estimated-arrival` |
| `update-vendor-assignment` | `--assignment-id` | `--status --actual-arrival` |
| `complete-work-order` | `--work-order-id --actual-cost` | `--purchase-invoice-id --billable-to-tenant` |
| `add-work-order-item` | `--work-order-id --description --item-type --rate` | `--quantity` |
| `list-work-order-items` | `--work-order-id` | |
| `add-inspection` | `--company-id --property-id --inspection-type --inspection-date` | `--unit-id --lease-id --inspector-name` |
| `get-inspection` | `--inspection-id` | |
| `list-inspections` | `--company-id` | `--property-id --inspection-type --limit --offset` |
| `add-inspection-item` | `--inspection-id --area --item --condition` | `--description --photo-url --estimated-repair-cost` |
| `list-inspection-items` | `--inspection-id` | |

### Accounting (10 actions)
| Action | Required Flags | Optional Flags |
|--------|---------------|----------------|
| `setup-trust-account` | `--company-id --property-id --account-id` | `--bank-name` |
| `get-trust-account` | `--trust-account-id` | |
| `list-trust-accounts` | `--company-id` | `--property-id` |
| `generate-owner-statement` | `--company-id --property-id --period-start --period-end` | |
| `list-owner-statements` | `--company-id` | `--property-id --limit --offset` |
| `record-security-deposit` | `--lease-id --amount --deposit-date` | `--trust-account-id-ref --interest-rate` |
| `return-security-deposit` | `--security-deposit-id --return-amount` | |
| `add-deposit-deduction` | `--security-deposit-id --deduction-type --deduction-description --amount` | `--invoice-url --receipt-url` |
| `list-deposit-deductions` | `--security-deposit-id` | |
| `generate-1099-report` | `--company-id --tax-year` | `--supplier-id` |

### Quick Command Reference
| User Says | Action |
|-----------|--------|
| "Add a new property" | `add-property` |
| "Show all my properties" | `list-properties` |
| "Add a unit to the building" | `add-unit` |
| "New tenant application" | `add-application` |
| "Run a background check" | `add-screening` |
| "Approve the applicant" | `approve-application` |
| "Create a lease" | `add-lease` |
| "Activate the lease" | `activate-lease` |
| "Generate rent charges" | `generate-charges` |
| "Apply late fees" | `apply-late-fees` |
| "Submit a maintenance request" | `add-work-order` |
| "Assign a plumber" | `assign-vendor` |
| "Set up trust account" | `setup-trust-account` |
| "Record security deposit" | `record-security-deposit` |
| "Return the deposit" | `return-security-deposit` |
| "Generate owner statement" | `generate-owner-statement` |
| "1099 report for vendors" | `generate-1099-report` |

### Key Concepts

- **Tenant = Customer**: Tenants are ERPClaw customers. Use erpclaw-selling for invoicing.
- **Vendor = Supplier**: Maintenance vendors are ERPClaw suppliers. Use erpclaw-buying for POs.
- **Trust Accounts**: GL accounts with `account_type = 'trust'`. Security deposits held here.
- **FCRA Compliance**: Never store raw credit data. Adverse action notice required on denial.
- **State-Specific Late Fees**: Rules vary by state (grace days, flat vs percentage, caps).
- **Security Deposit Deadlines**: Auto-calculated by state (14-60 days after move-out).

## Technical Details (Tier 3)

**Tables owned (23):** propclaw_property, propclaw_unit, propclaw_amenity, propclaw_property_photo, propclaw_lease, propclaw_rent_schedule, propclaw_lease_charge, propclaw_late_fee_rule, propclaw_lease_renewal, propclaw_application, propclaw_screening_request, propclaw_tenant_document, propclaw_adverse_action, propclaw_work_order, propclaw_work_order_item, propclaw_inspection, propclaw_inspection_item, propclaw_vendor_assignment, propclaw_trust_account, propclaw_owner_statement, propclaw_security_deposit, propclaw_deposit_deduction, propclaw_tax_1099

**Script:** `scripts/db_query.py` routes to 5 domain modules: properties.py, leases.py, tenants.py, maintenance.py, accounting.py

**Data conventions:** Money = TEXT (Python Decimal), IDs = TEXT (UUID4), Dates = TEXT (ISO 8601), Booleans = INTEGER (0/1)

**Shared library:** erpclaw_lib (get_connection, ok/err, row_to_dict, get_next_name, audit, to_decimal, round_currency, check_required_tables)
