# Common Phoneme Issues & Coaching Tips

## Vowels

| Phoneme | IPA | Example | Common Issue | Fix |
|---------|-----|---------|-------------|-----|
| /ax/ (schwa) | /ə/ | "about", "sofa" | Over-pronouncing unstressed vowels | Relax the mouth, say a lazy "uh" |
| /iy/ | /iː/ | "see", "me" | Too short | Stretch it: "seee" |
| /ih/ | /ɪ/ | "sit", "bit" | Confused with /iy/ | Shorter, more relaxed than "ee" |
| /ey/ | /eɪ/ | "say", "day" | Missing the glide | Start with "eh", glide to "ee" |
| /ae/ | /æ/ | "cat", "bat" | Not open enough | Drop jaw, spread lips slightly |
| /ah/ | /ʌ/ | "cup", "but" | Confused with /ax/ | Short, stressed "uh" |
| /uw/ | /uː/ | "too", "blue" | Too short | Round lips, stretch it |
| /aw/ | /aʊ/ | "now", "how" | Missing the glide | Start with "ah", glide to "oo" |

## Consonants

| Phoneme | IPA | Example | Common Issue | Fix |
|---------|-----|---------|-------------|-----|
| /th/ | /θ/ | "think", "three" | Replaced with /t/ or /s/ | Tongue between teeth, blow air |
| /dh/ | /ð/ | "the", "this" | Replaced with /d/ or /z/ | Tongue between teeth, vibrate |
| /r/ | /ɹ/ | "red", "car" | Too trilled or too weak | Curl tongue tip back, don't touch anything |
| /l/ | /l/ | "light", "pull" | Dark L vs light L confusion | Light: tongue tip on ridge. Dark: tongue pulls back |
| /v/ | /v/ | "very" | Replaced with /w/ | Top teeth on bottom lip |
| /s/ | /s/ | "see", "bus" | Too soft or whistling | Tongue behind upper teeth, steady air |
| /z/ | /z/ | "zoo", "buzz" | Replaced with /s/ | Same as /s/ but vibrate vocal cords |
| /sh/ | /ʃ/ | "she", "push" | Confused with /s/ | Lips slightly rounded, broader airflow |
| /ch/ | /tʃ/ | "church", "match" | Too soft | Tongue on roof, build pressure, release burst |
| /ng/ | /ŋ/ | "sing", "ring" | Adding /g/ after | Back of tongue touches soft palate only |

## Prosody Issues

| Issue | Description | Fix |
|-------|-------------|-----|
| Monotone | Flat pitch throughout | Rise on stressed words, fall at sentence ends |
| Unexpected break | Pausing in wrong places | Group words into natural thought chunks |
| Missing break | Running words together | Pause between clauses and sentences |

## Word Stress Patterns

Common academic/presentation words:
- **aNALysis** (not a-na-LY-sis)
- **perFORMance** (not per-for-MANCE)
- **sigNIFicant** (not sig-ni-fi-CANT)
- **proDUCtivity** (not pro-duc-ti-VI-ty)
- **arTIFicial** (not ar-ti-FI-cial)
- **proNUNciation** (not pro-NOUNCE-iation)
- **CONference** (not con-FER-ence)
- **COMplement** (not com-ple-MENT)
