---
name: prompt-optimizer
description: Evaluate, optimize, and enhance prompts using 58 proven prompting techniques. Use when user asks to improve, optimize, or analyze a prompt; when a prompt needs better clarity, specificity, or structure; or when generating prompt variations for different use cases. Covers quality assessment, targeted improvements, and automatic optimization across techniques like CoT, few-shot learning, role-play, and 50+ more.
---

# Prompt Optimizer

A Node.js implementation of 58 proven prompting techniques cataloged in `references/prompt-techniques.md`.

## Usage

### 1. List Available Techniques
See all 58 techniques with their IDs and descriptions.
```bash
node skills/prompt-optimizer/index.js list
```

### 2. Get Technique Details
View the template and purpose of a specific technique.
```bash
node skills/prompt-optimizer/index.js get <technique_name>
```
Example: `node skills/prompt-optimizer/index.js get "Chain of Thought"`

### 3. Optimize a Prompt
Apply a specific technique's template to your prompt.
```bash
node skills/prompt-optimizer/index.js optimize "<your_prompt>" --technique "<technique_name>"
```
Example:
```bash
node skills/prompt-optimizer/index.js optimize "Write a python script to reverse a string" --technique "Chain of Thought"
```

## References
- `references/prompt-techniques.md`: Full catalog of techniques.
- `references/quality-framework.md`: Framework for evaluating prompt quality manually.
