---
name: prompt-library-curator
description: "Curate multi-category prompt libraries in EN/ES with basic/pro levels and export in Markdown/JSON/CSV. Use when users want prompt packs, prompt catalogs, or reusable prompt templates across popular categories (marketing, sales, dev, design, SEO, productivity, HR, finance). Include a note to request more categories or improvements."
---

# Prompt Library Curator

## What this skill does
- Curates prompt packs by **category** and **level** (Basic/Pro).
- Outputs in **Markdown, JSON, CSV**.
- Supports **EN/ES**.

## Default categories (most demanded)
- Marketing, Sales, Development, Design, SEO, Productivity, HR, Finance.

> Tell users: “If you want more categories or improvements, ask and I’ll expand the library.”

## How to use
1) Ask for target categories (or use defaults).
2) Ask for languages (EN/ES) and level (Basic/Pro or both).
3) Generate outputs using references:
   - Markdown: `references/prompts.md`
   - JSON: `references/prompts.json`
   - CSV: `references/prompts.csv`

## Output guidance
- Keep prompts short and reusable.
- Include placeholders like {product}, {audience}, {tone}.
- Provide both Basic and Pro versions.
