# Prompt Engineering Expert Skill - Complete Index

## 📋 Quick Navigation

### Getting Started
- **[README.md](README.md)** - Start here! Overview, how to use, and quick start guide
- **[SUMMARY.md](SUMMARY.md)** - What was created and how to use it

### Core Skill Files
- **[SKILL.md](SKILL.md)** - Skill metadata and capabilities overview
- **[CLAUDE.md](CLAUDE.md)** - Main skill instructions and expertise areas

### Documentation
- **[docs/BEST_PRACTICES.md](docs/BEST_PRACTICES.md)** - Comprehensive best practices guide
- **[docs/TECHNIQUES.md](docs/TECHNIQUES.md)** - Advanced prompt engineering techniques
- **[docs/TROUBLESHOOTING.md](docs/TROUBLESHOOTING.md)** - Common issues and solutions

### Examples & Templates
- **[examples/EXAMPLES.md](examples/EXAMPLES.md)** - 10 real-world examples and templates

---

## 📚 What's Included

### Expertise Areas (7 Major Areas)
1. Prompt Writing Best Practices
2. Advanced Prompt Engineering Techniques
3. Custom Instructions & System Prompts
4. Prompt Optimization & Refinement
5. Anti-Patterns & Common Mistakes
6. Evaluation & Testing
7. Multimodal & Advanced Prompting

### Key Capabilities (8 Capabilities)
1. Prompt Analysis
2. Prompt Generation
3. Prompt Refinement
4. Custom Instruction Design
5. Best Practice Guidance
6. Anti-Pattern Recognition
7. Testing Strategy
8. Documentation

### Use Cases (9 Use Cases)
1. Refining vague or ineffective prompts
2. Creating specialized system prompts
3. Designing custom instructions for agents
4. Optimizing for consistency and reliability
5. Teaching prompt engineering best practices
6. Debugging prompt performance issues
7. Creating prompt templates for workflows
8. Improving efficiency and token usage
9. Developing evaluation frameworks

---

## 🎯 How to Use This Skill

### For Prompt Analysis
```
"Review this prompt and suggest improvements:
[YOUR PROMPT]

Focus on: clarity, specificity, format, and consistency."
```

### For Prompt Generation
```
"Create a prompt that:
- [Requirement 1]
- [Requirement 2]
- [Requirement 3]

The prompt should handle [use cases]."
```

### For Custom Instructions
```
"Design custom instructions for an agent that:
- [Role/expertise]
- [Key responsibilities]
- [Behavioral guidelines]"
```

### For Troubleshooting
```
"This prompt isn't working well:
[PROMPT]

Issues: [DESCRIBE ISSUES]

How can I fix it?"
```

---

## 📖 Documentation Structure

### BEST_PRACTICES.md (Comprehensive Guide)
- Core principles (clarity, conciseness, degrees of freedom)
- Advanced techniques (CoT, few-shot, XML, role-based, prefilling, chaining)
- Custom instructions design
- Skill structure best practices
- Evaluation & testing frameworks
- Anti-patterns to avoid
- Workflows and feedback loops
- Content guidelines
- Multimodal prompting
- Development workflow
- Complete checklist

### TECHNIQUES.md (Advanced Methods)
- Chain-of-Thought prompting with examples
- Few-Shot learning (1-shot, 2-shot, multi-shot)
- Structured output with XML tags
- Role-based prompting
- Prefilling responses
- Prompt chaining
- Context management
- Multimodal prompting
- Combining techniques
- Anti-patterns

### TROUBLESHOOTING.md (Problem Solving)
- 8 common issues with solutions
- Debugging workflow
- Quick reference table
- Testing checklist

### EXAMPLES.md (Real-World Cases)
- 10 practical examples
- Before/after comparisons
- Templates and frameworks
- Optimization checklists

---

## ✅ Best Practices Summary

### Do's ✅
- Be clear and specific
- Provide examples
- Specify format
- Define constraints
- Test thoroughly
- Document assumptions
- Use progressive disclosure
- Handle edge cases

### Don'ts ❌
- Be vague or ambiguous
- Assume understanding
- Skip format specification
- Ignore edge cases
- Over-specify constraints
- Use jargon without explanation
- Hardcode values
- Ignore error handling

---

## 🚀 Getting Started

### Step 1: Read the Overview
Start with **README.md** to understand what this skill provides.

### Step 2: Learn Best Practices
Review **docs/BEST_PRACTICES.md** for foundational knowledge.

### Step 3: Explore Examples
Check **examples/EXAMPLES.md** for real-world use cases.

### Step 4: Try It Out
Share your prompt or describe your need to get started.

### Step 5: Troubleshoot
Use **docs/TROUBLESHOOTING.md** if you encounter issues.

---

## 🔧 Advanced Topics

### Chain-of-Thought Prompting
Encourage step-by-step reasoning for complex tasks.
→ See: TECHNIQUES.md, Section 1

### Few-Shot Learning
Use examples to guide behavior without explicit instructions.
→ See: TECHNIQUES.md, Section 2

### Structured Output
Use XML tags for clarity and parsing.
→ See: TECHNIQUES.md, Section 3

### Role-Based Prompting
Assign expertise to guide behavior.
→ See: TECHNIQUES.md, Section 4

### Prompt Chaining
Break complex tasks into sequential prompts.
→ See: TECHNIQUES.md, Section 6

### Context Management
Optimize token usage and clarity.
→ See: TECHNIQUES.md, Section 7

### Multimodal Integration
Work with images, files, and embeddings.
→ See: TECHNIQUES.md, Section 8

---

## 📊 File Structure

```
prompt-engineering-expert/
├── INDEX.md                    # This file
├── SUMMARY.md                  # What was created
├── README.md                   # User guide & getting started
├── SKILL.md                    # Skill metadata
├── CLAUDE.md                   # Main instructions
├── docs/
│   ├── BEST_PRACTICES.md       # Best practices guide
│   ├── TECHNIQUES.md           # Advanced techniques
│   └── TROUBLESHOOTING.md      # Common issues & solutions
└── examples/
    └── EXAMPLES.md             # Real-world examples
```

---

## 🎓 Learning Path

### Beginner
1. Read: README.md
2. Read: BEST_PRACTICES.md (Core Principles section)
3. Review: EXAMPLES.md (Examples 1-3)
4. Try: Create a simple prompt

### Intermediate
1. Read: TECHNIQUES.md (Sections 1-4)
2. Review: EXAMPLES.md (Examples 4-7)
3. Read: TROUBLESHOOTING.md
4. Try: Refine an existing prompt

### Advanced
1. Read: TECHNIQUES.md (Sections 5-8)
2. Review: EXAMPLES.md (Examples 8-10)
3. Read: BEST_PRACTICES.md (Advanced sections)
4. Try: Combine multiple techniques

---

## 🔗 Integration Points

This skill works well with:
- **Claude Code** - For testing and iterating on prompts
- **Agent SDK** - For implementing custom instructions
- **Files API** - For analyzing prompt documentation
- **Vision** - For multimodal prompt design
- **Extended Thinking** - For complex prompt reasoning

---

## 📝 Key Concepts

### Clarity
- Explicit objectives
- Precise language
- Concrete examples
- Logical structure

### Conciseness
- Focused content
- No redundancy
- Progressive disclosure
- Token efficiency

### Consistency
- Defined constraints
- Specified format
- Clear guidelines
- Repeatable results

### Completeness
- Sufficient context
- Edge case handling
- Success criteria
- Error handling

---

## ⚠️ Limitations

- **Analysis Only**: Doesn't execute code or run actual prompts
- **No Real-Time Data**: Can't access external APIs or current data
- **Best Practices Based**: Recommendations based on established patterns
- **Testing Required**: Suggestions should be validated with actual use cases
- **Human Judgment**: Doesn't replace human expertise in critical applications

---

## 🎯 Common Use Cases

### 1. Refining Vague Prompts
Transform unclear prompts into specific, actionable ones.
→ See: EXAMPLES.md, Example 1

### 2. Creating Specialized Prompts
Design prompts for specific domains or tasks.
→ See: EXAMPLES.md, Example 2

### 3. Designing Agent Instructions
Create custom instructions for AI agents and skills.
→ See: EXAMPLES.md, Example 2

### 4. Optimizing for Consistency
Improve reliability and reduce variability.
→ See: BEST_PRACTICES.md, Skill Structure section

### 5. Debugging Prompt Issues
Identify and fix problems with existing prompts.
→ See: TROUBLESHOOTING.md

### 6. Teaching Best Practices
Learn prompt engineering principles and techniques.
→ See: BEST_PRACTICES.md, TECHNIQUES.md

### 7. Building Evaluation Frameworks
Develop test cases and success criteria.
→ See: BEST_PRACTICES.md, Evaluation & Testing section

### 8. Multimodal Prompting
Design prompts for vision, embeddings, and files.
→ See: TECHNIQUES.md, Section 8

---

## 📞 Support & Resources

### Within This Skill
- Detailed documentation
- Real-world examples
- Troubleshooting guides
- Best practice checklists
- Quick reference tables

### External Resources
- Claude Documentation: https://docs.claude.com
- Anthropic Blog: https://www.anthropic.com/blog
- Claude Cookbooks: https://github.com/anthropics/claude-cookbooks
- Prompt Engineering Guide: https://www.promptingguide.ai

---

## 🚀 Next Steps

1. **Explore the documentation** - Start with README.md
2. **Review examples** - Check examples/EXAMPLES.md
3. **Try it out** - Share your prompt or describe your need
4. **Iterate** - Use feedback to improve
5. **Share** - Help others with their prompts

---

**Ready to master prompt engineering?** Start with [README.md](README.md)!
